/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.AutoValue_Attributes_ArrayBackedAttributes;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Attributes
extends ImmutableKeyValuePairs<AttributeKey, Object>
implements ReadableAttributes {
    private static final Attributes EMPTY = Attributes.builder().build();

    @Override
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    @Override
    public void forEach(AttributeConsumer consumer) {
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            consumer.accept((AttributeKey)data.get(i), data.get(i + 1));
        }
    }

    public static Attributes empty() {
        return EMPTY;
    }

    public static <T> Attributes of(AttributeKey<T> key, T value) {
        return Attributes.sortAndFilterToAttributes(key, value);
    }

    public static <T, U> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2);
    }

    public static <T, U, V> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3);
    }

    public static <T, U, V, W> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static <T, U, V, W, X> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static <T, U, V, W, X, Y> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5, AttributeKey<Y> key6, Y value6) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
    }

    public static AttributesBuilder builder() {
        return new AttributesBuilder();
    }

    public static AttributesBuilder builder(ReadableAttributes attributes) {
        AttributesBuilder builder = new AttributesBuilder();
        attributes.forEach(builder::put);
        return builder;
    }

    public abstract AttributesBuilder toBuilder();

    static Attributes sortAndFilterToAttributes(Object ... data) {
        for (int i = 0; i < data.length; i += 2) {
            AttributeKey key = (AttributeKey)data[i];
            if (key == null || key.getKey() != null && !"".equals(key.getKey())) continue;
            data[i] = null;
        }
        return new AutoValue_Attributes_ArrayBackedAttributes(Attributes.sortAndFilter(data, true));
    }

    @AutoValue
    @Immutable
    static abstract class ArrayBackedAttributes
    extends Attributes {
        ArrayBackedAttributes() {
        }

        @Override
        protected abstract List<Object> data();

        @Override
        public AttributesBuilder toBuilder() {
            return new AttributesBuilder(new ArrayList<Object>(this.data()));
        }
    }
}

