/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.HeaderUtil;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.StatusCodes;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public enum WebClientHttpAttributesGetter implements HttpClientAttributesGetter<ClientRequest, ClientResponse>
{
    INSTANCE;


    public String getUrlFull(ClientRequest request) {
        return request.url().toString();
    }

    public String getHttpRequestMethod(ClientRequest request) {
        return request.method().name();
    }

    public List<String> getHttpRequestHeader(ClientRequest request, String name) {
        return HeaderUtil.getHeader(request.headers(), name);
    }

    @Nullable
    public Integer getHttpResponseStatusCode(ClientRequest request, ClientResponse response, @Nullable Throwable error) {
        return StatusCodes.get(response);
    }

    public List<String> getHttpResponseHeader(ClientRequest request, ClientResponse response, String name) {
        return response.headers().header(name);
    }

    @Nullable
    public String getServerAddress(ClientRequest request) {
        return request.url().getHost();
    }

    public Integer getServerPort(ClientRequest request) {
        return request.url().getPort();
    }

    @Nullable
    public String getErrorType(ClientRequest request, @Nullable ClientResponse response, @Nullable Throwable error) {
        if (response == null && error == null) {
            return "cancelled";
        }
        return null;
    }
}

