/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.http.HttpHeaders;

public final class HeaderUtil {
    @Nullable
    private static final MethodHandle GET_HEADERS = HeaderUtil.findGetHeadersMethod(MethodType.methodType(List.class, String.class, List.class));

    private static MethodHandle findGetHeadersMethod(MethodType methodType) {
        try {
            return MethodHandles.lookup().findVirtual(HttpHeaders.class, "getOrDefault", methodType);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static List<String> getHeader(HttpHeaders headers, String name) {
        if (headers instanceof Map) {
            return headers.getOrDefault(name, Collections.emptyList());
        }
        if (GET_HEADERS != null) {
            try {
                return GET_HEADERS.invoke(headers, name, Collections.emptyList());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private HeaderUtil() {
    }
}

