/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxClientTelemetryBuilder;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientTracingFilter;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;

public final class SpringWebfluxClientTelemetry {
    private final Instrumenter<ClientRequest, ClientResponse> clientInstrumenter;
    private final ContextPropagators propagators;

    public static SpringWebfluxClientTelemetry create(OpenTelemetry openTelemetry) {
        return SpringWebfluxClientTelemetry.builder(openTelemetry).build();
    }

    public static SpringWebfluxClientTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringWebfluxClientTelemetryBuilder(openTelemetry);
    }

    SpringWebfluxClientTelemetry(Instrumenter<ClientRequest, ClientResponse> clientInstrumenter, ContextPropagators propagators) {
        this.clientInstrumenter = clientInstrumenter;
        this.propagators = propagators;
    }

    public void addFilter(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        for (ExchangeFilterFunction filterFunction : exchangeFilterFunctions) {
            if (!(filterFunction instanceof WebClientTracingFilter)) continue;
            return;
        }
        exchangeFilterFunctions.add(new WebClientTracingFilter(this.clientInstrumenter, this.propagators));
    }

    public void addFilterAndRegisterReactorHook(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        SpringWebfluxClientTelemetry.registerReactorHook();
        this.addFilter(exchangeFilterFunctions);
    }

    private static void registerReactorHook() {
        ContextPropagationOperator.builder().build().registerOnEachOperator();
    }
}

