/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

enum KafkaConsumerAttributesGetter implements MessagingAttributesGetter<KafkaProcessRequest, Void>
{
    INSTANCE;


    public String getSystem(KafkaProcessRequest request) {
        return "kafka";
    }

    public String getDestination(KafkaProcessRequest request) {
        return request.getRecord().topic();
    }

    @Nullable
    public String getDestinationTemplate(KafkaProcessRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(KafkaProcessRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(KafkaProcessRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(KafkaProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(KafkaProcessRequest request) {
        long size = request.getRecord().serializedValueSize();
        return size >= 0L ? Long.valueOf(size) : null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(KafkaProcessRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(KafkaProcessRequest request, @Nullable Void unused) {
        return null;
    }

    @Nullable
    public String getClientId(KafkaProcessRequest request) {
        return request.getClientId();
    }

    @Nullable
    public Long getBatchMessageCount(KafkaProcessRequest request, @Nullable Void unused) {
        return null;
    }

    public List<String> getMessageHeader(KafkaProcessRequest request, String name) {
        return StreamSupport.stream(request.getRecord().headers().headers(name).spliterator(), false).filter(header -> header.value() != null).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

