/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContextUtil;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.internal.KafkaConsumerTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.internal.KafkaConsumerTelemetrySupplier;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class OpenTelemetryConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    public static final String CONFIG_KEY_KAFKA_CONSUMER_TELEMETRY_SUPPLIER = "opentelemetry.kafka-consumer-telemetry.supplier";
    @Nullable
    private KafkaConsumerTelemetry consumerTelemetry;
    private String consumerGroup;
    private String clientId;

    @CanIgnoreReturnValue
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        if (this.consumerTelemetry == null) {
            return records;
        }
        Timer timer = Timer.start();
        Context receiveContext = this.consumerTelemetry.buildAndFinishSpan(records, this.consumerGroup, this.clientId, timer);
        if (receiveContext == null) {
            receiveContext = Context.current();
        }
        KafkaConsumerContext consumerContext = KafkaConsumerContextUtil.create((Context)receiveContext, (String)this.consumerGroup, (String)this.clientId);
        return this.consumerTelemetry.addTracing(records, consumerContext);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.consumerGroup = Objects.toString(configs.get("group.id"), null);
        this.clientId = Objects.toString(configs.get("client.id"), null);
        KafkaConsumerTelemetrySupplier supplier = OpenTelemetryConsumerInterceptor.getProperty(configs, CONFIG_KEY_KAFKA_CONSUMER_TELEMETRY_SUPPLIER, KafkaConsumerTelemetrySupplier.class);
        this.consumerTelemetry = supplier.get();
    }

    private static <T> T getProperty(Map<String, ?> configs, String key, Class<T> requiredType) {
        Object value = configs.get(key);
        if (value == null) {
            throw new IllegalStateException("Missing required configuration property: " + key);
        }
        if (!requiredType.isInstance(value)) {
            throw new IllegalStateException("Configuration property " + key + " is not instance of " + requiredType.getSimpleName());
        }
        return requiredType.cast(value);
    }
}

