/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaHeadersSetter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProducerRequest;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Headers;

public class KafkaProducerTelemetry {
    private static final Logger logger = Logger.getLogger(KafkaProducerTelemetry.class.getName());
    private static final TextMapSetter<Headers> SETTER = KafkaHeadersSetter.INSTANCE;
    private final TextMapPropagator propagator;
    private final Instrumenter<KafkaProducerRequest, RecordMetadata> producerInstrumenter;
    private final boolean producerPropagationEnabled;

    public KafkaProducerTelemetry(TextMapPropagator propagator, Instrumenter<KafkaProducerRequest, RecordMetadata> producerInstrumenter, boolean producerPropagationEnabled) {
        this.propagator = propagator;
        this.producerInstrumenter = producerInstrumenter;
        this.producerPropagationEnabled = producerPropagationEnabled;
    }

    public <K, V> void buildAndInjectSpan(ProducerRecord<K, V> record, String clientId) {
        KafkaProducerRequest request;
        Context parentContext = Context.current();
        if (!this.producerInstrumenter.shouldStart(parentContext, (Object)(request = KafkaProducerRequest.create(record, (String)clientId)))) {
            return;
        }
        Context context = this.producerInstrumenter.start(parentContext, (Object)request);
        if (this.producerPropagationEnabled) {
            try {
                this.propagator.inject(context, (Object)record.headers(), SETTER);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "failed to inject span context. sending record second time?", t);
            }
        }
        this.producerInstrumenter.end(context, (Object)request, null, null);
    }

    public <K, V> Future<RecordMetadata> buildAndInjectSpan(ProducerRecord<K, V> record, Producer<K, V> producer, Callback callback, BiFunction<ProducerRecord<K, V>, Callback, Future<RecordMetadata>> sendFn) {
        KafkaProducerRequest request;
        Context parentContext = Context.current();
        if (!this.producerInstrumenter.shouldStart(parentContext, (Object)(request = KafkaProducerRequest.create(record, producer)))) {
            return sendFn.apply(record, callback);
        }
        Context context = this.producerInstrumenter.start(parentContext, (Object)request);
        this.propagator.inject(context, (Object)record.headers(), SETTER);
        try (Scope ignored = context.makeCurrent();){
            Future<RecordMetadata> future = sendFn.apply(record, new ProducerCallback(callback, parentContext, context, request));
            return future;
        }
    }

    private class ProducerCallback
    implements Callback {
        private final Callback callback;
        private final Context parentContext;
        private final Context context;
        private final KafkaProducerRequest request;

        ProducerCallback(Callback callback, Context parentContext, Context context, KafkaProducerRequest request) {
            this.callback = callback;
            this.parentContext = parentContext;
            this.context = context;
            this.request = request;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            KafkaProducerTelemetry.this.producerInstrumenter.end(this.context, (Object)this.request, (Object)metadata, (Throwable)exception);
            if (this.callback != null) {
                try (Scope ignored = this.parentContext.makeCurrent();){
                    this.callback.onCompletion(metadata, exception);
                }
            }
        }
    }
}

