/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaReceiveRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaUtil;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.TracingList;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

public class KafkaConsumerTelemetry {
    private final Instrumenter<KafkaReceiveRequest, Void> consumerReceiveInstrumenter;
    private final Instrumenter<KafkaProcessRequest, Void> consumerProcessInstrumenter;

    public KafkaConsumerTelemetry(Instrumenter<KafkaReceiveRequest, Void> consumerReceiveInstrumenter, Instrumenter<KafkaProcessRequest, Void> consumerProcessInstrumenter) {
        this.consumerReceiveInstrumenter = consumerReceiveInstrumenter;
        this.consumerProcessInstrumenter = consumerProcessInstrumenter;
    }

    public <K, V> ConsumerRecords<K, V> addTracing(ConsumerRecords<K, V> consumerRecords, KafkaConsumerContext consumerContext) {
        if (consumerRecords.isEmpty()) {
            return consumerRecords;
        }
        LinkedHashMap<TopicPartition, List> records = new LinkedHashMap<TopicPartition, List>();
        for (TopicPartition partition : consumerRecords.partitions()) {
            List list = consumerRecords.records(partition);
            if (list != null && !list.isEmpty()) {
                list = TracingList.wrap((List)list, this.consumerProcessInstrumenter, () -> true, (KafkaConsumerContext)consumerContext);
            }
            records.put(partition, list);
        }
        return new ConsumerRecords(records);
    }

    public <K, V> Context buildAndFinishSpan(ConsumerRecords<K, V> records, Consumer<K, V> consumer, Timer timer) {
        return this.buildAndFinishSpan(records, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer), timer);
    }

    public <K, V> Context buildAndFinishSpan(ConsumerRecords<K, V> records, String consumerGroup, String clientId, Timer timer) {
        if (records.isEmpty()) {
            return null;
        }
        Context parentContext = Context.current();
        KafkaReceiveRequest request = KafkaReceiveRequest.create(records, (String)consumerGroup, (String)clientId);
        Context context = null;
        if (this.consumerReceiveInstrumenter.shouldStart(parentContext, (Object)request)) {
            context = InstrumenterUtil.startAndEnd(this.consumerReceiveInstrumenter, (Context)parentContext, (Object)request, null, null, (Instant)timer.startTime(), (Instant)timer.now());
        }
        return context;
    }
}

