/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer.utils;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.attributes.SemanticAttributes;
import io.opentelemetry.instrumentation.api.config.Config;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NetPeerUtils {
    public static final Map<String, String> ENDPOINT_PEER_SERVICE_MAPPING = Collections.unmodifiableMap(Config.get().getMapProperty("otel.endpoint.peer.service.mapping"));

    private NetPeerUtils() {
    }

    public static void setNetPeer(Span span, @Nullable InetSocketAddress remoteConnection) {
        if (remoteConnection != null) {
            InetAddress remoteAddress = remoteConnection.getAddress();
            if (remoteAddress != null) {
                NetPeerUtils.setNetPeer(span, remoteAddress, remoteConnection.getPort());
            } else {
                NetPeerUtils.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), remoteConnection.getHostString(), null, remoteConnection.getPort());
            }
        }
    }

    public static void setNetPeer(Span span, InetAddress remoteAddress, int port) {
        NetPeerUtils.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), remoteAddress.getHostName(), remoteAddress.getHostAddress(), port);
    }

    public static void setNetPeer(Span span, String nameOrIp, int port) {
        try {
            InetSocketAddress address = new InetSocketAddress(nameOrIp, port);
            NetPeerUtils.setNetPeer(span, address);
        }
        catch (IllegalArgumentException iae) {
            NetPeerUtils.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), nameOrIp, null, port);
        }
    }

    public static void setNetPeer(Span span, String peerName, String peerIp) {
        NetPeerUtils.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, -1);
    }

    public static void setNetPeer(Span span, String peerName, String peerIp, int port) {
        NetPeerUtils.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, port);
    }

    public static void setNetPeer(SpanAttributeSetter span, String peerName, String peerIp, int port) {
        String peerService;
        if (peerName != null && !peerName.equals(peerIp)) {
            span.setAttribute(SemanticAttributes.NET_PEER_NAME, peerName);
        }
        if (peerIp != null) {
            span.setAttribute(SemanticAttributes.NET_PEER_IP, peerIp);
        }
        if ((peerService = NetPeerUtils.mapToPeer(peerName)) == null) {
            peerService = NetPeerUtils.mapToPeer(peerIp);
        }
        if (peerService != null) {
            span.setAttribute(SemanticAttributes.PEER_SERVICE, peerService);
        }
        if (port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, Long.valueOf(port));
        }
    }

    private static String mapToPeer(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return ENDPOINT_PEER_SERVICE_MAPPING.get(endpoint);
    }

    @FunctionalInterface
    public static interface SpanAttributeSetter {
        public <T> void setAttribute(AttributeKey<T> var1, @Nullable T var2);
    }
}

