/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.attributes.SemanticAttributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.instrumentation.api.decorator.HttpStatusConverter;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    public static final String CONTEXT_ATTRIBUTE = HttpServerTracer.class.getName() + ".Context";
    protected static final String USER_AGENT = "User-Agent";
    private static final boolean FAIL_ON_CONTEXT_LEAK = Boolean.getBoolean("otel.internal.failOnContextLeak");

    public HttpServerTracer() {
    }

    public HttpServerTracer(Tracer tracer) {
        super(tracer);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, Method origin) {
        String spanName = this.spanNameForMethod(origin);
        return this.startSpan(request, connection, spanName);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, String spanName) {
        return this.startSpan(request, connection, spanName, -1L);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, String spanName, long startTimestamp) {
        Context parentContext = this.extract(request, this.getGetter());
        SpanBuilder builder = this.tracer.spanBuilder(spanName).setSpanKind(Span.Kind.SERVER).setParent(parentContext);
        if (startTimestamp >= 0L) {
            builder.setStartTimestamp(startTimestamp, TimeUnit.NANOSECONDS);
        }
        Span span = builder.startSpan();
        this.onConnection(span, connection);
        this.onRequest(span, request);
        this.onConnectionAndRequest(span, connection, request);
        return parentContext.with((ImplicitContextKeyed)span);
    }

    public Scope startScope(Span span, STORAGE storage) {
        return this.startScope(span, storage, Context.current());
    }

    public Scope startScope(Span span, STORAGE storage, Context context) {
        Context newContext = context.with(CONTEXT_SERVER_SPAN_KEY, (Object)span).with((ImplicitContextKeyed)span);
        this.attachServerContext(newContext, storage);
        return newContext.makeCurrent();
    }

    public void end(Span span, RESPONSE response) {
        this.end(span, response, -1L);
    }

    public void end(Span span, RESPONSE response, long timestamp) {
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        HttpServerTracer.endSpan(span, timestamp);
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, null);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response) {
        this.endExceptionally(span, throwable, response, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response, long timestamp) {
        this.onError(span, this.unwrapThrowable(throwable));
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        HttpServerTracer.endSpan(span, timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : (Span)attachedContext.get(CONTEXT_SERVER_SPAN_KEY);
    }

    public abstract @Nullable Context getServerContext(STORAGE var1);

    protected void onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        }
    }

    protected void onRequest(Span span, REQUEST request) {
        span.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)this.method(request));
        span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)this.requestHeader(request, USER_AGENT));
        this.setUrl(span, request);
    }

    private void setUrl(Span span, REQUEST request) {
        span.setAttribute(SemanticAttributes.HTTP_URL, (Object)this.url(request));
    }

    protected void onConnectionAndRequest(Span span, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)flavor);
        }
        span.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)this.clientIP(connection, request));
    }

    private String clientIP(CONNECTION connection, REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null) {
            int endIndex = forwarded.indexOf(44);
            if (endIndex > 0) {
                forwarded = forwarded.substring(0, endIndex);
            }
            if (!forwarded.isEmpty()) {
                return forwarded;
            }
        }
        return this.peerHostIP(connection);
    }

    static String extractForwardedFor(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private <C> Context extract(C carrier, TextMapPropagator.Getter<C> getter) {
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            this.debugContextLeak();
        }
        return OpenTelemetry.getGlobalPropagators().getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    private void debugContextLeak() {
        Context current = Context.current();
        if (current != Context.root()) {
            List<StackTraceElement[]> locations;
            log.error("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = Span.fromContextOrNull((Context)current);
            if (currentSpan != null) {
                log.error("It contains this span: {}", (Object)currentSpan);
            }
            if ((locations = ContextPropagationDebug.getLocations(current)) != null) {
                StringBuilder sb = new StringBuilder();
                Iterator<StackTraceElement[]> i = locations.iterator();
                while (i.hasNext()) {
                    for (StackTraceElement ste : i.next()) {
                        sb.append("\n");
                        sb.append(ste);
                    }
                    if (!i.hasNext()) continue;
                    sb.append("\nwhich was propagated from:");
                }
                log.error("a context leak was detected. it was propagated from:{}", (Object)sb);
            }
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    private static void setStatus(Span span, int status) {
        span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, (Object)status);
        span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
    }

    private static void endSpan(Span span, long timestamp) {
        if (timestamp >= 0L) {
            span.end(timestamp, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    protected abstract @Nullable Integer peerPort(CONNECTION var1);

    protected abstract @Nullable String peerHostIP(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract TextMapPropagator.Getter<REQUEST> getGetter();

    protected abstract String url(REQUEST var1);

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);

    protected boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }
}

