/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.attributes.SemanticAttributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.decorator.HttpStatusConverter;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.utils.NetPeerUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientTracer<REQUEST, CARRIER, RESPONSE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTracer.class);
    public static final String DEFAULT_SPAN_NAME = "HTTP request";
    protected static final String USER_AGENT = "User-Agent";

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable URI url(REQUEST var1) throws URISyntaxException;

    protected @Nullable String flavor(REQUEST request) {
        return "1.1";
    }

    protected abstract Integer status(RESPONSE var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract @Nullable String responseHeader(RESPONSE var1, String var2);

    protected abstract TextMapPropagator.Setter<CARRIER> getSetter();

    protected HttpClientTracer() {
    }

    protected HttpClientTracer(Tracer tracer) {
        super(tracer);
    }

    public Span startSpan(REQUEST request) {
        return this.startSpan(request, -1L);
    }

    public Span startSpan(REQUEST request, long startTimeNanos) {
        return this.internalStartSpan(request, this.spanNameForRequest(request), startTimeNanos);
    }

    public Scope startScope(Span span, CARRIER carrier) {
        Context context = Context.current().with((ImplicitContextKeyed)span);
        TextMapPropagator.Setter<CARRIER> setter = this.getSetter();
        if (setter == null) {
            throw new IllegalStateException("getSetter() not defined but calling startScope(), either getSetter must be implemented or the scope should be setup manually");
        }
        OpenTelemetry.getGlobalPropagators().getTextMapPropagator().inject(context, carrier, setter);
        context = context.with(CONTEXT_CLIENT_SPAN_KEY, (Object)span);
        return context.makeCurrent();
    }

    public void end(Span span, RESPONSE response) {
        this.end(span, response, -1L);
    }

    public void end(Span span, RESPONSE response, long endTimeNanos) {
        this.onResponse(span, response);
        super.end(span, endTimeNanos);
    }

    public void endExceptionally(Span span, RESPONSE response, Throwable throwable) {
        this.endExceptionally(span, response, throwable, -1L);
    }

    public void endExceptionally(Span span, RESPONSE response, Throwable throwable, long endTimeNanos) {
        this.onResponse(span, response);
        super.endExceptionally(span, throwable, endTimeNanos);
    }

    private Span internalStartSpan(REQUEST request, String name, long startTimeNanos) {
        Context context = Context.current();
        Span clientSpan = (Span)context.get(CONTEXT_CLIENT_SPAN_KEY);
        if (clientSpan != null) {
            return Span.getInvalid();
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder(name).setSpanKind(Span.Kind.CLIENT).setParent(context);
        if (startTimeNanos > 0L) {
            spanBuilder.setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS);
        }
        Span span = spanBuilder.startSpan();
        this.onRequest(span, request);
        return span;
    }

    protected Span onRequest(Span span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setAttribute(SemanticAttributes.NET_TRANSPORT, (Object)"IP.TCP");
            span.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)this.method(request));
            span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)this.requestHeader(request, USER_AGENT));
            this.setFlavor(span, request);
            this.setUrl(span, request);
        }
        return span;
    }

    private void setFlavor(Span span, REQUEST request) {
        String flavor = this.flavor(request);
        if (flavor == null) {
            return;
        }
        String httpProtocolPrefix = "HTTP/";
        if (flavor.startsWith(httpProtocolPrefix)) {
            flavor = flavor.substring(httpProtocolPrefix.length());
        }
        span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)flavor);
    }

    private void setUrl(Span span, REQUEST request) {
        try {
            URI url = this.url(request);
            if (url != null) {
                NetPeerUtils.setNetPeer(span, url.getHost(), null, url.getPort());
                span.setAttribute(SemanticAttributes.HTTP_URL, (Object)url.toString());
            }
        }
        catch (Exception e) {
            log.debug("Error tagging url", (Throwable)e);
        }
    }

    protected Span onResponse(Span span, RESPONSE response) {
        Integer status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, (Object)status);
            span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
        }
        return span;
    }

    protected String spanNameForRequest(REQUEST request) {
        if (request == null) {
            return DEFAULT_SPAN_NAME;
        }
        String method = this.method(request);
        return method != null ? "HTTP " + method : DEFAULT_SPAN_NAME;
    }
}

