/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.attributes.SemanticAttributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.utils.NetPeerUtils;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;

public abstract class DatabaseClientTracer<CONNECTION, QUERY>
extends BaseTracer {
    protected static final String DB_QUERY = "DB Query";
    protected final Tracer tracer = OpenTelemetry.getGlobalTracer((String)this.getInstrumentationName(), (String)this.getVersion());

    public Span startSpan(CONNECTION connection, QUERY query) {
        String normalizedQuery = this.normalizeQuery(query);
        Span span = this.tracer.spanBuilder(this.spanName(connection, query, normalizedQuery)).setSpanKind(Span.Kind.CLIENT).setAttribute(SemanticAttributes.DB_SYSTEM, (Object)this.dbSystem(connection)).startSpan();
        if (connection != null) {
            this.onConnection(span, connection);
            this.setNetSemanticConvention(span, connection);
        }
        this.onStatement(span, normalizedQuery);
        return span;
    }

    @Override
    public Scope startScope(Span span) {
        Context clientSpanContext = Context.current().with(CONTEXT_CLIENT_SPAN_KEY, (Object)span);
        Context newContext = clientSpanContext.with((ImplicitContextKeyed)span);
        return newContext.makeCurrent();
    }

    @Override
    public Span getCurrentSpan() {
        return Span.current();
    }

    public Span getClientSpan() {
        Context context = Context.current();
        return (Span)context.get(CONTEXT_CLIENT_SPAN_KEY);
    }

    @Override
    public void end(Span span) {
        span.end();
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.onError(span, throwable);
        this.end(span);
    }

    protected Span onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.DB_USER, (Object)this.dbUser(connection));
        span.setAttribute(SemanticAttributes.DB_NAME, (Object)this.dbName(connection));
        span.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, (Object)this.dbConnectionString(connection));
        return span;
    }

    @Override
    protected void onError(Span span, Throwable throwable) {
        if (throwable != null) {
            span.setStatus(StatusCode.ERROR);
            this.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
    }

    protected void setNetSemanticConvention(Span span, CONNECTION connection) {
        NetPeerUtils.setNetPeer(span, this.peerAddress(connection));
    }

    protected void onStatement(Span span, String statement) {
        span.setAttribute(SemanticAttributes.DB_STATEMENT, (Object)statement);
    }

    protected abstract String normalizeQuery(QUERY var1);

    protected abstract String dbSystem(CONNECTION var1);

    protected String dbUser(CONNECTION connection) {
        return null;
    }

    protected String dbName(CONNECTION connection) {
        return null;
    }

    protected String dbConnectionString(CONNECTION connection) {
        return null;
    }

    protected abstract InetSocketAddress peerAddress(CONNECTION var1);

    protected String spanName(CONNECTION connection, QUERY query, String normalizedQuery) {
        if (normalizedQuery != null) {
            return normalizedQuery;
        }
        String result = null;
        if (connection != null) {
            result = this.dbName(connection);
        }
        return result == null ? DB_QUERY : result;
    }
}

