/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.decorator;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.attributes.SemanticAttributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.tracer.utils.NetPeerUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

@Deprecated
public abstract class BaseDecorator {
    private static final ClassValue<SpanNames> SPAN_NAMES = new ClassValue<SpanNames>(){

        @Override
        protected SpanNames computeValue(Class<?> type) {
            return new SpanNames(BaseDecorator.getClassName(type));
        }
    };

    protected BaseDecorator() {
    }

    public Span afterStart(Span span) {
        assert (span != null);
        return span;
    }

    public Span beforeFinish(Span span) {
        assert (span != null);
        return span;
    }

    public Span onError(Span span, Throwable throwable) {
        assert (span != null);
        if (throwable != null) {
            this.onComplete(span, StatusCode.ERROR, throwable);
        }
        return span;
    }

    public Span onComplete(Span span, StatusCode status, Throwable throwable) {
        assert (span != null);
        span.setStatus(status);
        if (throwable != null) {
            BaseDecorator.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
        return span;
    }

    public Span onPeerConnection(Span span, InetSocketAddress remoteConnection) {
        assert (span != null);
        if (remoteConnection != null) {
            InetAddress remoteAddress = remoteConnection.getAddress();
            if (remoteAddress != null) {
                this.onPeerConnection(span, remoteAddress);
            } else {
                BaseDecorator.setPeer(span, remoteConnection.getHostString(), null);
            }
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)remoteConnection.getPort());
        }
        return span;
    }

    public Span onPeerConnection(Span span, InetAddress remoteAddress) {
        assert (span != null);
        BaseDecorator.setPeer(span, remoteAddress.getHostName(), remoteAddress.getHostAddress());
        return span;
    }

    public static void setPeer(Span span, String peerName, String peerIp) {
        String peerService;
        assert (span != null);
        if (peerName != null && !peerName.equals(peerIp)) {
            span.setAttribute(SemanticAttributes.NET_PEER_NAME, (Object)peerName);
        }
        if (peerIp != null) {
            span.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)peerIp);
        }
        if ((peerService = BaseDecorator.mapToPeer(peerName)) == null) {
            peerService = BaseDecorator.mapToPeer(peerIp);
        }
        if (peerService != null) {
            span.setAttribute(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    public static void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForMethod(method.getDeclaringClass(), method);
    }

    public String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    public String spanNameForMethod(Class<?> clazz, String methodName) {
        SpanNames cn = SPAN_NAMES.get(clazz);
        return null == methodName ? cn.getClassName() : cn.getSpanName(methodName);
    }

    public String spanNameForClass(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.isEmpty() ? SPAN_NAMES.get(clazz).getClassName() : simpleName;
    }

    private static String getClassName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            String name = clazz.getName();
            int start = name.lastIndexOf(46);
            return name.substring(start + 1);
        }
        return simpleName;
    }

    public static <C> Context extract(C carrier, TextMapPropagator.Getter<C> getter) {
        return OpenTelemetry.getGlobalPropagators().getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    protected static String mapToPeer(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return NetPeerUtils.ENDPOINT_PEER_SERVICE_MAPPING.get(endpoint);
    }

    private static class SpanNames {
        private final String className;
        private final ConcurrentHashMap<String, String> spanNames = new ConcurrentHashMap(1);

        private SpanNames(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSpanName(String methodName) {
            String spanName = this.spanNames.get(methodName);
            if (null == spanName) {
                spanName = this.className + "." + methodName;
                this.spanNames.putIfAbsent(methodName, spanName);
            }
            return spanName;
        }
    }
}

