/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.DbAttributes;
import io.opentelemetry.semconv.ErrorAttributes;
import javax.annotation.Nullable;

public final class DbClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey((String)"db.name");
    private static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey((String)"db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey((String)"db.connection_string");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey((String)"db.statement");
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private final DbClientAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new DbClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientAttributesExtractor(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        DbClientAttributesExtractor.onStartCommon(attributes, this.getter, request);
    }

    static <REQUEST, RESPONSE> void onStartCommon(AttributesBuilder attributes, DbClientAttributesGetter<REQUEST, RESPONSE> getter, REQUEST request) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_SYSTEM_NAME, (Object)SemconvStability.stableDbSystemName((String)getter.getDbSystem(request)));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_NAMESPACE, (Object)getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_QUERY_TEXT, (Object)getter.getDbQueryText(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_OPERATION_NAME, (Object)getter.getDbOperationName(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_QUERY_SUMMARY, (Object)getter.getDbQuerySummary(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)getter.getDbSystem(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_USER, (Object)getter.getUser(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_NAME, (Object)getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_CONNECTION_STRING, (Object)getter.getConnectionString(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_STATEMENT, (Object)getter.getDbQueryText(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)getter.getDbOperationName(request));
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        DbClientAttributesExtractor.onEndCommon(attributes, this.getter, response, error);
    }

    static <REQUEST, RESPONSE> void onEndCommon(AttributesBuilder attributes, DbClientAttributesGetter<REQUEST, RESPONSE> getter, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (error != null) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)ErrorAttributes.ERROR_TYPE, (Object)error.getClass().getName());
            }
            if (error != null || response != null) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_RESPONSE_STATUS_CODE, (Object)getter.getResponseStatus(response, error));
            }
        }
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

