/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Function;
import javax.annotation.Nullable;

public class AnnotationReflectionHelper {
    private AnnotationReflectionHelper() {
    }

    @Nullable
    public static Class<? extends Annotation> forNameOrNull(ClassLoader classLoader, String className) {
        try {
            return Class.forName(className, true, classLoader).asSubclass(Annotation.class);
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            return null;
        }
    }

    public static <A extends Annotation, T> Function<A, T> bindAnnotationElementMethod(MethodHandles.Lookup lookup, Class<? extends Annotation> annotationClass, String methodName, Class<T> returnClass) throws Throwable {
        MethodHandle valueHandle = lookup.findVirtual(annotationClass, methodName, MethodType.methodType(returnClass));
        return a -> {
            try {
                return valueHandle.invoke((Annotation)a);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        };
    }
}

