/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.contrib.sampler.RuleBasedRoutingSampler;
import io.opentelemetry.contrib.sampler.RuleBasedRoutingSamplerBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.List;

public class RuleBasedRoutingSamplerComponentProvider
implements ComponentProvider<Sampler> {
    private static final String ACTION_RECORD_AND_SAMPLE = "RECORD_AND_SAMPLE";
    private static final String ACTION_DROP = "DROP";

    public Class<Sampler> getType() {
        return Sampler.class;
    }

    public String getName() {
        return "rule_based_routing";
    }

    public Sampler create(DeclarativeConfigProperties config) {
        SpanKind spanKind;
        Sampler fallbackSampler;
        DeclarativeConfigProperties fallbackModel = config.getStructured("fallback_sampler");
        if (fallbackModel == null) {
            throw new DeclarativeConfigException("rule_based_routing sampler .fallback is required but is null");
        }
        try {
            fallbackSampler = DeclarativeConfiguration.createSampler((DeclarativeConfigProperties)fallbackModel);
        }
        catch (DeclarativeConfigException e) {
            throw new DeclarativeConfigException("rule_based_routing sampler failed to create .fallback sampler", (Throwable)e);
        }
        String spanKindString = config.getString("span_kind", "SERVER");
        try {
            spanKind = SpanKind.valueOf((String)spanKindString);
        }
        catch (IllegalArgumentException e) {
            throw new DeclarativeConfigException("rule_based_routing sampler .span_kind is invalid: " + spanKindString, (Throwable)e);
        }
        RuleBasedRoutingSamplerBuilder builder = RuleBasedRoutingSampler.builder(spanKind, fallbackSampler);
        List rules = config.getStructuredList("rules");
        if (rules == null || rules.isEmpty()) {
            throw new DeclarativeConfigException("rule_based_routing sampler .rules is required");
        }
        for (DeclarativeConfigProperties rule : rules) {
            String attribute = rule.getString("attribute");
            if (attribute == null) {
                throw new DeclarativeConfigException("rule_based_routing sampler .rules[].attribute is required");
            }
            AttributeKey attributeKey = AttributeKey.stringKey((String)attribute);
            String pattern = rule.getString("pattern");
            if (pattern == null) {
                throw new DeclarativeConfigException("rule_based_routing sampler .rules[].pattern is required");
            }
            String action = rule.getString("action");
            if (action == null) {
                throw new DeclarativeConfigException("rule_based_routing sampler .rules[].action is required");
            }
            if (action.equals(ACTION_RECORD_AND_SAMPLE)) {
                builder.recordAndSample((AttributeKey<String>)attributeKey, pattern);
                continue;
            }
            if (action.equals(ACTION_DROP)) {
                builder.drop((AttributeKey<String>)attributeKey, pattern);
                continue;
            }
            throw new DeclarativeConfigException("rule_based_routing sampler .rules[].action must be RECORD_AND_SAMPLE or DROP");
        }
        return builder.build();
    }
}

