/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.azure.resource.AzureEnvVarPlatform;
import io.opentelemetry.contrib.azure.resource.AzureVmResourceProvider;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.contrib.azure.resource.IncubatingAttributes;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;

public final class AzureFunctionsResourceProvider
extends CloudResourceProvider {
    static final String FUNCTIONS_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_MEM_LIMIT = "WEBSITE_MEMORY_LIMIT_MB";
    private static final Map<AttributeKey<String>, String> ENV_VAR_MAPPING = new HashMap<AttributeKey<String>, String>();
    private final Map<String, String> env;

    public AzureFunctionsResourceProvider() {
        this(System.getenv());
    }

    AzureFunctionsResourceProvider(Map<String, String> env) {
        this.env = env;
    }

    @Override
    public Resource createResource() {
        return Resource.create((Attributes)this.getAttributes());
    }

    public Attributes getAttributes() {
        AzureEnvVarPlatform detect = AzureEnvVarPlatform.detect(this.env);
        if (detect != AzureEnvVarPlatform.FUNCTIONS) {
            return Attributes.empty();
        }
        AttributesBuilder builder = AzureVmResourceProvider.azureAttributeBuilder("azure.functions");
        String limit = this.env.get(FUNCTIONS_MEM_LIMIT);
        if (limit != null) {
            builder.put(IncubatingAttributes.FAAS_MAX_MEMORY, (Object)Long.parseLong(limit));
        }
        AzureEnvVarPlatform.addAttributesFromEnv(ENV_VAR_MAPPING, this.env, builder);
        return builder.build();
    }

    static {
        ENV_VAR_MAPPING.put(IncubatingAttributes.CLOUD_REGION, "REGION_NAME");
        ENV_VAR_MAPPING.put(IncubatingAttributes.FAAS_NAME, "WEBSITE_SITE_NAME");
        ENV_VAR_MAPPING.put(IncubatingAttributes.FAAS_VERSION, FUNCTIONS_VERSION);
        ENV_VAR_MAPPING.put(IncubatingAttributes.FAAS_INSTANCE, "WEBSITE_INSTANCE_ID");
    }
}

