/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.test;

import com.jayway.awaitility.Awaitility;
import com.jayway.restassured.RestAssured;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public class OpenShiftTestAssistant {
    private final OpenShiftClient client;
    private final String project;
    private String applicationName;
    private Map<String, List<HasMetadata>> created = new LinkedHashMap<String, List<HasMetadata>>();

    public OpenShiftTestAssistant() {
        this.client = (OpenShiftClient)new DefaultKubernetesClient().adapt(OpenShiftClient.class);
        this.project = this.client.getNamespace();
    }

    public List<? extends HasMetadata> deploy(String name, File template) throws IOException {
        try (FileInputStream fis = new FileInputStream(template);){
            NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable declarations = this.client.load((InputStream)fis);
            List entities = (List)declarations.createOrReplace();
            this.created.put(name, entities);
            System.out.println(name + " deployed, " + entities.size() + " object(s) created.");
            List list = entities;
            return list;
        }
    }

    public String deployApplication() throws IOException {
        this.applicationName = System.getProperty("app.name");
        List<? extends HasMetadata> entities = this.deploy("application", new File("target/classes/META-INF/fabric8/openshift.yml"));
        Optional<String> first = entities.stream().filter(hm -> hm instanceof DeploymentConfig).map(hm -> (DeploymentConfig)hm).map(dc -> dc.getMetadata().getName()).findFirst();
        if (this.applicationName == null && first.isPresent()) {
            this.applicationName = first.get();
        }
        Route route = (Route)((ClientResource)((ClientNonNamespaceOperation)((OpenShiftClient)this.client.adapt(OpenShiftClient.class)).routes().inNamespace(this.project)).withName(this.applicationName)).get();
        Assertions.assertThat((Object)route).isNotNull();
        RestAssured.baseURI = "http://" + Objects.requireNonNull(route).getSpec().getHost();
        System.out.println("Route url: " + RestAssured.baseURI);
        return this.applicationName;
    }

    public void cleanup() {
        ArrayList<String> keys = new ArrayList<String>(this.created.keySet());
        Collections.reverse(keys);
        for (String key : keys) {
            this.created.remove(key).stream().sorted(Comparator.comparing(HasMetadata::getKind)).forEach(metadata -> {
                boolean isDeploymentConfigOrReplicationController = metadata instanceof DeploymentConfig || metadata instanceof ReplicationController;
                System.out.println(String.format("Deleting %s : %s", key, metadata.getKind()));
                ((Deletable)((CascadingDeletable)this.client.resource(metadata).withGracePeriod(0L)).cascading(!isDeploymentConfigOrReplicationController)).delete();
            });
        }
    }

    public void awaitApplicationReadinessOrFail() {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> {
            List list = ((PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.project)).list()).getItems();
            return list.stream().filter(pod -> pod.getMetadata().getName().startsWith(this.applicationName)).filter(this::isRunning).collect(Collectors.toList()).size() >= 1;
        });
    }

    private boolean isRunning(Pod pod) {
        return "running".equalsIgnoreCase(pod.getStatus().getPhase());
    }

    public OpenShiftClient client() {
        return this.client;
    }

    public String project() {
        return this.project;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public void awaitPodReadinessOrFail(Predicate<Pod> filter) {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> {
            List list = ((PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.project)).list()).getItems();
            return list.stream().filter(filter).filter(this::isRunning).collect(Collectors.toList()).size() >= 1;
        });
    }
}

