/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server;

import io.opencmw.MimeType;
import io.opencmw.QueryParameterParser;
import io.opencmw.rbac.RbacRole;
import io.opencmw.serialiser.annotations.MetaInfo;
import io.opencmw.server.BasicMdpWorker;
import io.opencmw.server.MajordomoBroker;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class MmiServiceHelper {
    public static final String INTERNAL_SERVICE_NAMES = "mmi.service";
    public static final String INTERNAL_SERVICE_OPENAPI = "mmi.openapi";
    public static final String INTERNAL_SERVICE_DNS = "mmi.dns";
    public static final String INTERNAL_SERVICE_ECHO = "mmi.echo";

    private MmiServiceHelper() {
    }

    public static boolean isHtmlRequest(URI topic) {
        return topic != null && topic.getQuery() != null && MimeType.HTML == QueryParameterParser.getMimeType((String)topic.getQuery());
    }

    public static String wrapInAnchor(String text, URI uri) {
        if (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            return "<a href=\"" + uri.toString() + "\">" + text + "</a>";
        }
        return text;
    }

    @MetaInfo(description="definition according to <a href = \"http://rfc.zeromq.org/spec:8\">http://rfc.zeromq.org/spec:8</a>", unit="MMI Service/Property Definitions")
    public static class MmiService
    extends BasicMdpWorker {
        public MmiService(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), broker.brokerName + "/mmi.service", rbacRoles);
            this.registerHandler(context -> {
                String serviceName;
                String string = serviceName = context.req.data == null ? "" : new String(context.req.data, StandardCharsets.UTF_8);
                context.rep.data = serviceName.isBlank() ? (MmiServiceHelper.isHtmlRequest(context.req.topic) ? broker.services.keySet().stream().sorted().map(s -> MmiServiceHelper.wrapInAnchor(s, URI.create("/" + s))).collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8) : broker.services.keySet().stream().sorted().collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8)) : (broker.services.containsKey(serviceName) || broker.services.containsKey(broker.brokerName + "/" + serviceName) ? "200" : "400").getBytes(StandardCharsets.UTF_8);
            });
        }
    }

    @MetaInfo(description="endpoint returning OpenAPI definitions", unit="MMI OpenAPI Worker Class Definitions")
    public static class MmiOpenApi
    extends BasicMdpWorker {
        public MmiOpenApi(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), broker.brokerName + "/mmi.openapi", rbacRoles);
            this.registerHandler(context -> {
                String serviceName = context.req.data == null ? "" : new String(context.req.data, StandardCharsets.UTF_8);
                MajordomoBroker.Service service = broker.services.get(serviceName);
                if (service == null) {
                    service = broker.services.get(broker.brokerName + "/" + serviceName);
                }
                if (service == null) {
                    throw new IllegalArgumentException("requested invalid service name '" + serviceName + "' msg " + context.req);
                }
                context.rep.data = service.serviceDescription;
            });
        }
    }

    @MetaInfo(description="Dynamic Name Service (DNS) returning registered internal and external broker endpoints' URIs (protocol, host ip, port etc.)", unit="MMI DNS Service")
    public static class MmiDns
    extends BasicMdpWorker {
        private final Map<String, MajordomoBroker.DnsServiceItem> dnsCache;
        private final String brokerName;

        public MmiDns(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), broker.brokerName + "/mmi.dns", rbacRoles);
            this.dnsCache = broker.getDnsCache();
            this.brokerName = broker.brokerName;
            this.registerHandler(ctx -> {
                String query;
                boolean isHtml = MmiServiceHelper.isHtmlRequest(ctx.req.topic);
                String delimiter = isHtml ? ", " : ",";
                String string = query = ctx.req.topic.getQuery() == null ? null : ctx.req.topic.getQuery().split("&")[0];
                if (query == null || query.isBlank() || !query.contains(",") && !query.contains(":") && !query.contains("/")) {
                    Function<MajordomoBroker.DnsServiceItem, String> mapper = isHtml ? MajordomoBroker.DnsServiceItem::getDnsEntryHtml : MajordomoBroker.DnsServiceItem::getDnsEntry;
                    ctx.rep.data = this.dnsCache.values().stream().map(mapper).collect(Collectors.joining(delimiter)).getBytes(StandardCharsets.UTF_8);
                    return;
                }
                ctx.rep.data = Arrays.stream(StringUtils.split((String)query, (char)',')).map(StringUtils::strip).map(this::findDnsEntry).collect(Collectors.joining(delimiter)).getBytes(StandardCharsets.UTF_8);
            });
        }

        public String findDnsEntry(String entry) {
            URI query;
            StringBuilder builder = new StringBuilder(64);
            try {
                query = new URI(entry);
            }
            catch (URISyntaxException e) {
                builder.append('[').append(entry).append(": null]");
                return builder.toString();
            }
            String queryPath = StringUtils.stripStart((String)query.getPath(), (String)"/");
            boolean providedScheme = query.getScheme() != null && !query.getScheme().isBlank();
            String stripStartFromSearchPath = queryPath.startsWith("mmi.") ? "/" + this.brokerName : "/";
            Predicate<URI> matcher = dnsEntry -> {
                if (providedScheme && !dnsEntry.getScheme().equalsIgnoreCase(query.getScheme())) {
                    return false;
                }
                return StringUtils.stripStart((String)dnsEntry.getPath(), (String)stripStartFromSearchPath).startsWith(queryPath);
            };
            for (String brokerName : this.dnsCache.keySet()) {
                MajordomoBroker.DnsServiceItem serviceItem = this.dnsCache.get(brokerName);
                String matchedItems = serviceItem.uri.stream().filter(matcher).map(URI::toString).collect(Collectors.joining(", "));
                if (matchedItems.isBlank()) continue;
                builder.append('[').append(query.toString()).append(": ").append(matchedItems).append(']');
            }
            if (builder.length() == 0) {
                builder.append('[').append(query.toString()).append(": null]");
            }
            return builder.toString();
        }
    }

    @MetaInfo(description="output = input : echo service is that complex :-)", unit="MMI Echo Service")
    public static class MmiEcho
    extends BasicMdpWorker {
        public MmiEcho(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), broker.brokerName + "/mmi.echo", rbacRoles);
            this.registerHandler(ctx -> {
                ctx.rep.data = ctx.req.data;
            });
        }
    }
}

