/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server;

import io.opencmw.MimeType;
import io.opencmw.OpenCmwProtocol;
import io.opencmw.domain.BinaryData;
import io.opencmw.rbac.RbacRole;
import io.opencmw.server.DefaultHtmlHandler;
import io.opencmw.server.MajordomoWorker;
import io.opencmw.server.domain.BasicCtx;
import io.opencmw.utils.Cache;
import java.lang.invoke.StringConcatFactory;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZContext;

public class ClipboardWorker
extends MajordomoWorker<BasicCtx, BinaryData, BinaryData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipboardWorker.class);
    private static final BasicCtx EMPTY_CONTEXT = new BasicCtx();
    private static final String PATH_UPLOAD = "upload";
    private static final String TAG_SERVICE_NAME = "serviceName";
    private static final String TAG_SERVICE_PATH = "servicePath";
    private static final String TAG_SERVING_SITE = "serviceType";
    private static final String TAG_RESOURCE_NAME = "resourceName";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_CATEGORIES = "categories";
    private static final String TAG_REPOSITORY_DATA = "clipboardData";
    private static final String TAG_REPOSITORY_DATA_BINARY = "clipboardDataBinary";
    private static final String TAG_POLLING_PERIOD = "updatePeriod";
    public static final String REDIRECT_TAG = "redirect";
    private final Cache<String, DataContainer> repository;

    public ClipboardWorker(@NotNull String propertyName, @NotNull ZContext ctx, Cache<String, DataContainer> repository, RbacRole<?> ... rbacRoles) {
        super(ctx, propertyName, BasicCtx.class, BinaryData.class, BinaryData.class, rbacRoles);
        this.repository = Objects.requireNonNullElse(repository, Cache.builder().build());
        this.setHtmlHandler(new DefaultHtmlHandler(this.getClass(), "/velocity/property/ClipboardLayout.vm", map -> map.put("propertyName", propertyName)));
        this.setHandler((rawCtx, reqCtx, in, repCtx, out) -> {
            switch (rawCtx.req.command) {
                case GET_REQUEST: {
                    this.handleGet(rawCtx, (BasicCtx)reqCtx, (BasicCtx)repCtx, (BinaryData)out);
                    break;
                }
                case SET_REQUEST: {
                    this.handleSet(rawCtx, (BinaryData)in);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("command not implemented by service: '" + propertyName + "' request message: " + rawCtx.req);
                }
            }
        });
        this.setDaemon(true);
        LOGGER.atDebug().addArgument((Object)ClipboardWorker.class.getName()).addArgument((Object)propertyName).log("initialised {} at '{}'");
    }

    private void handleGet(OpenCmwProtocol.Context rawCtx, BasicCtx reqCtx, BasicCtx repCtx, BinaryData out) {
        boolean isFileResource;
        String resource = StringUtils.stripStart((String)StringUtils.stripStart((String)URLDecoder.decode(rawCtx.req.topic.getPath(), StandardCharsets.UTF_8), (String)"/"), (String)this.getServiceName());
        int dotPosition = resource.lastIndexOf(46);
        boolean bl = isFileResource = dotPosition >= 0 && dotPosition < resource.length() - 1;
        if (isFileResource && reqCtx.sse == null && reqCtx.longPolling < 0L) {
            Objects.requireNonNull((DataContainer)this.repository.get((Object)resource), (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"could not retrieve resource '\u0001'"}, (String)resource))).binaryData.moveTo(out);
            repCtx.contentType = out.contentType;
            return;
        }
        String resourceName = StringUtils.substringAfterLast((String)resource, (String)"/");
        String categoryName = StringUtils.strip((String)(isFileResource ? StringUtils.substringBeforeLast((String)resource, (String)"/") : resource), (String)"/");
        rawCtx.htmlData = Objects.requireNonNullElse(rawCtx.htmlData, new HashMap());
        rawCtx.htmlData.put(TAG_SERVICE_NAME, this.getServiceName());
        rawCtx.htmlData.put(TAG_RESOURCE_NAME, resourceName);
        rawCtx.htmlData.put(TAG_SERVICE_PATH, resource);
        if (resource.endsWith(PATH_UPLOAD)) {
            rawCtx.htmlData.put(TAG_CATEGORY, StringUtils.removeEnd((String)categoryName, (String)"/upload"));
            rawCtx.htmlData.put(TAG_SERVING_SITE, PATH_UPLOAD);
            return;
        }
        rawCtx.htmlData.put(TAG_CATEGORY, categoryName);
        if (reqCtx.sse != null) {
            rawCtx.htmlData.put(TAG_RESOURCE_NAME, resource);
            rawCtx.htmlData.put(TAG_SERVING_SITE, "oneSSE");
            return;
        }
        if (reqCtx.longPolling >= 0L) {
            rawCtx.htmlData.put(TAG_RESOURCE_NAME, resource);
            rawCtx.htmlData.put(TAG_SERVING_SITE, "onePolling");
            rawCtx.htmlData.put(TAG_POLLING_PERIOD, Math.min(Math.max(reqCtx.longPolling, 20L), 10000L));
            return;
        }
        Set subCategories = this.repository.keySet().stream().filter(s -> s.startsWith("/" + categoryName)).map(s -> StringUtils.removeStart((String)s, (String)("/" + categoryName))).map(s -> StringUtils.substringBefore((String)StringUtils.strip((String)StringUtils.substringBeforeLast((String)s, (String)"/"), (String)"/"), (String)"/")).collect(Collectors.toSet());
        List dataInSubCategory = this.repository.entrySet().stream().filter(e -> StringUtils.substringBeforeLast((String)((String)e.getKey()), (String)"/").equals("/" + categoryName)).sorted(Comparator.comparing(s -> ((DataContainer)s.getValue()).getFileName())).map(Map.Entry::getValue).collect(Collectors.toList());
        rawCtx.htmlData.put(TAG_CATEGORIES, subCategories);
        rawCtx.htmlData.put(TAG_SERVING_SITE, "other");
        rawCtx.htmlData.put(TAG_REPOSITORY_DATA, dataInSubCategory.stream().filter(d -> ClipboardWorker.isDisplayableContent(d.binaryData.contentType)).collect(Collectors.toList()));
        rawCtx.htmlData.put(TAG_REPOSITORY_DATA_BINARY, dataInSubCategory.stream().filter(d -> !ClipboardWorker.isDisplayableContent(d.binaryData.contentType)).collect(Collectors.toList()));
    }

    protected static boolean isDisplayableContent(@NotNull MimeType contentType) {
        return contentType == MimeType.PDF || !contentType.getMediaType().startsWith("application");
    }

    private void handleSet(OpenCmwProtocol.Context rawCtx, BinaryData in) {
        String redirectPath = StringUtils.prependIfMissing((String)StringUtils.removeEnd((String)rawCtx.req.topic.getPath(), (String)"/upload"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        rawCtx.rep.topic = URI.create(redirectPath);
        String resource = StringUtils.stripStart((String)StringUtils.removeEnd((String)StringUtils.stripStart((String)rawCtx.req.topic.getPath(), (String)"/"), (String)PATH_UPLOAD), (String)this.getServiceName());
        this.uploadAndNotifyData(in, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadAndNotifyData(BinaryData in, String resource) {
        Cache<String, DataContainer> cache = this.repository;
        synchronized (cache) {
            String cleanedResourceName = StringUtils.removeEnd((String)StringUtils.prependIfMissing((String)resource, (CharSequence)"/", (CharSequence[])new CharSequence[0]), (String)"/") + StringUtils.prependIfMissing((String)in.resourceName, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            in.resourceName = cleanedResourceName;
            this.repository.put((Object)cleanedResourceName, (Object)new DataContainer(in));
            this.notify(cleanedResourceName, EMPTY_CONTEXT, in);
        }
    }

    public static class DataContainer {
        private final BinaryData binaryData;
        private final long updateTime = System.currentTimeMillis();

        public DataContainer(@NotNull BinaryData binaryData) {
            this.binaryData = binaryData;
        }

        public String getResourceName() {
            return this.binaryData.resourceName;
        }

        public String getEncodedResourceName() {
            return URLEncoder.encode(this.binaryData.resourceName, StandardCharsets.UTF_8);
        }

        public String getFileName() {
            return URLDecoder.decode(StringUtils.substringAfterLast((String)this.binaryData.resourceName, (String)"/"), StandardCharsets.UTF_8);
        }

        public String getMimeData() {
            return "data:" + this.binaryData.contentType.getMediaType() + ";base64," + Base64.getEncoder().encodeToString(this.binaryData.data);
        }

        public String getTimeStamp() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.UK);
            sdf.setTimeZone(TimeZone.getDefault());
            return sdf.format(this.updateTime);
        }
    }
}

