/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server;

import io.opencmw.MimeType;
import io.opencmw.QueryParameterParser;
import io.opencmw.rbac.RbacRole;
import io.opencmw.serialiser.annotations.MetaInfo;
import io.opencmw.server.BasicMdpWorker;
import io.opencmw.server.MajordomoBroker;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public final class MmiServiceHelper {
    public static final String INTERNAL_SERVICE_NAMES = "mmi.service";
    public static final String INTERNAL_SERVICE_OPENAPI = "mmi.openapi";
    public static final String INTERNAL_SERVICE_DNS = "mmi.dns";
    public static final String INTERNAL_SERVICE_ECHO = "mmi.echo";

    private MmiServiceHelper() {
    }

    public static boolean isHtmlRequest(URI topic) {
        return topic != null && topic.getQuery() != null && MimeType.HTML == QueryParameterParser.getMimeType((String)topic.getQuery());
    }

    public static String wrapInAnchor(String text, URI uri) {
        if (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            return "<a href=\"" + uri.toString() + "\">" + text + "</a>";
        }
        return text;
    }

    @MetaInfo(description="definition according to <a href = \"http://rfc.zeromq.org/spec:8\">http://rfc.zeromq.org/spec:8</a>", unit="MMI Service/Property Definitions")
    public static class MmiService
    extends BasicMdpWorker {
        public MmiService(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), MmiServiceHelper.INTERNAL_SERVICE_NAMES, rbacRoles);
            this.registerHandler(context -> {
                String serviceName;
                String string = serviceName = context.req.data == null ? "" : new String(context.req.data, StandardCharsets.UTF_8);
                context.rep.data = serviceName.isBlank() ? (MmiServiceHelper.isHtmlRequest(context.req.topic) ? broker.services.keySet().stream().sorted().map(s -> MmiServiceHelper.wrapInAnchor(s, URI.create("/" + s))).collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8) : broker.services.keySet().stream().sorted().collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8)) : (broker.services.containsKey(serviceName) ? "200" : "400").getBytes(StandardCharsets.UTF_8);
            });
        }
    }

    @MetaInfo(description="endpoint returning OpenAPI definitions", unit="MMI OpenAPI Worker Class Definitions")
    public static class MmiOpenApi
    extends BasicMdpWorker {
        public MmiOpenApi(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), MmiServiceHelper.INTERNAL_SERVICE_OPENAPI, rbacRoles);
            this.registerHandler(context -> {
                String serviceName = context.req.data == null ? "" : new String(context.req.data, StandardCharsets.UTF_8);
                MajordomoBroker.Service service = broker.services.get(serviceName);
                if (service == null) {
                    throw new IllegalArgumentException("requested invalid service name '" + serviceName + "' msg " + context.req);
                }
                context.rep.data = service.serviceDescription;
            });
        }
    }

    @MetaInfo(description="Dynamic Name Service (DNS) returning registered internal and external broker endpoints' URIs (protocol, host ip, port etc.)", unit="MMI DNS Service")
    public static class MmiDns
    extends BasicMdpWorker {
        public MmiDns(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), MmiServiceHelper.INTERNAL_SERVICE_DNS, rbacRoles);
            this.registerHandler(ctx -> {
                ctx.rep.data = MmiServiceHelper.isHtmlRequest(ctx.req.topic) ? broker.dnsCache.values().stream().map(MajordomoBroker.DnsServiceItem::getDnsEntryHtml).collect(Collectors.joining(",<br>")).getBytes(StandardCharsets.UTF_8) : broker.dnsCache.values().stream().map(MajordomoBroker.DnsServiceItem::getDnsEntry).collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8);
            });
        }
    }

    @MetaInfo(description="output = input : echo service is that complex :-)", unit="MMI Echo Service")
    public static class MmiEcho
    extends BasicMdpWorker {
        public MmiEcho(MajordomoBroker broker, RbacRole<?> ... rbacRoles) {
            super(broker.getContext(), MmiServiceHelper.INTERNAL_SERVICE_ECHO, rbacRoles);
            this.registerHandler(ctx -> {
                ctx.rep.data = ctx.req.data;
            });
        }
    }
}

