/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server;

import io.opencmw.MimeType;
import io.opencmw.OpenCmwProtocol;
import io.opencmw.QueryParameterParser;
import io.opencmw.rbac.RbacRole;
import io.opencmw.serialiser.IoBuffer;
import io.opencmw.serialiser.IoClassSerialiser;
import io.opencmw.serialiser.annotations.MetaInfo;
import io.opencmw.serialiser.spi.BinarySerialiser;
import io.opencmw.serialiser.spi.CmwLightSerialiser;
import io.opencmw.serialiser.spi.FastByteBuffer;
import io.opencmw.serialiser.spi.JsonSerialiser;
import io.opencmw.server.BasicMdpWorker;
import io.opencmw.server.DefaultHtmlHandler;
import java.net.URI;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZContext;

@MetaInfo(description="default MajordomoWorker implementation")
public class MajordomoWorker<C, I, O>
extends BasicMdpWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajordomoWorker.class);
    private static final int MAX_BUFFER_SIZE = 4000;
    protected final IoBuffer defaultBuffer = new FastByteBuffer(4000, true, null);
    protected final IoBuffer defaultNotifyBuffer = new FastByteBuffer(4000, true, null);
    protected final IoClassSerialiser deserialiser = new IoClassSerialiser(this.defaultBuffer, new Class[0]);
    protected final IoClassSerialiser serialiser = new IoClassSerialiser(this.defaultBuffer, new Class[0]);
    protected final IoClassSerialiser notifySerialiser = new IoClassSerialiser(this.defaultNotifyBuffer, new Class[0]);
    protected final Class<C> contextClassType;
    protected final Class<I> inputClassType;
    protected final Class<O> outputClassType;
    protected Handler<C, I, O> handler;
    protected Handler<C, I, O> htmlHandler;

    public MajordomoWorker(String brokerAddress, String serviceName, @NotNull Class<C> contextClassType, @NotNull Class<I> inputClassType, @NotNull Class<O> outputClassType, RbacRole<?> ... rbacRoles) {
        this(null, brokerAddress, serviceName, contextClassType, inputClassType, outputClassType, rbacRoles);
    }

    public MajordomoWorker(ZContext ctx, String serviceName, @NotNull Class<C> contextClassType, @NotNull Class<I> inputClassType, @NotNull Class<O> outputClassType, RbacRole<?> ... rbacRoles) {
        this(ctx, "inproc://broker", serviceName, contextClassType, inputClassType, outputClassType, rbacRoles);
    }

    protected MajordomoWorker(ZContext ctx, String brokerAddress, String serviceName, @NotNull Class<C> contextClassType, @NotNull Class<I> inputClassType, @NotNull Class<O> outputClassType, RbacRole<?> ... rbacRoles) {
        super(ctx, brokerAddress, serviceName, rbacRoles);
        this.contextClassType = contextClassType;
        this.inputClassType = inputClassType;
        this.outputClassType = outputClassType;
        this.deserialiser.setAutoMatchSerialiser(false);
        this.serialiser.setAutoMatchSerialiser(false);
        this.notifySerialiser.setAutoMatchSerialiser(false);
        this.serialiser.setMatchedIoSerialiser(BinarySerialiser.class);
        this.notifySerialiser.setMatchedIoSerialiser(BinarySerialiser.class);
        try {
            Class.forName("org.apache.velocity.app.VelocityEngine");
            this.setHtmlHandler(new DefaultHtmlHandler(this.getClass(), null, null));
        }
        catch (ClassNotFoundException e) {
            LOGGER.atInfo().addArgument((Object)"velocity engine not present - omitting setting DefaultHtmlHandler()");
        }
        super.registerHandler(c -> {
            Object input;
            URI reqTopic = c.req.topic;
            String queryString = reqTopic.getQuery();
            Object requestCtx = QueryParameterParser.parseQueryParameter((Class)contextClassType, (String)c.req.topic.getQuery());
            Object replyCtx = QueryParameterParser.parseQueryParameter((Class)contextClassType, (String)c.req.topic.getQuery());
            MimeType requestedMimeType = QueryParameterParser.getMimeType((String)queryString);
            if (c.req.data.length > 0) {
                switch (requestedMimeType) {
                    case HTML: 
                    case JSON: 
                    case JSON_LD: {
                        this.deserialiser.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])c.req.data));
                        this.deserialiser.setMatchedIoSerialiser(JsonSerialiser.class);
                        input = this.deserialiser.deserialiseObject(inputClassType);
                        break;
                    }
                    case CMWLIGHT: {
                        this.deserialiser.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])c.req.data));
                        this.deserialiser.setMatchedIoSerialiser(CmwLightSerialiser.class);
                        input = this.deserialiser.deserialiseObject(inputClassType);
                        break;
                    }
                    default: {
                        this.deserialiser.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])c.req.data));
                        this.deserialiser.setMatchedIoSerialiser(BinarySerialiser.class);
                        input = this.deserialiser.deserialiseObject(inputClassType);
                        break;
                    }
                }
            } else {
                input = inputClassType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object output = outputClassType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.handler.handle(c, requestCtx, input, replyCtx, output);
            String replyQuery = QueryParameterParser.generateQueryParameter((Object)replyCtx);
            c.rep.topic = new URI(reqTopic.getScheme(), reqTopic.getAuthority(), reqTopic.getPath(), replyQuery, reqTopic.getFragment());
            MimeType replyMimeType = QueryParameterParser.getMimeType((String)replyQuery);
            this.defaultBuffer.reset();
            switch (replyMimeType) {
                case HTML: {
                    this.htmlHandler.handle(c, requestCtx, input, replyCtx, output);
                    break;
                }
                case JSON: 
                case JSON_LD: {
                    this.serialiser.setMatchedIoSerialiser(JsonSerialiser.class);
                    this.serialiser.getMatchedIoSerialiser().setBuffer(this.defaultBuffer);
                    this.serialiser.serialiseObject(output);
                    this.defaultBuffer.flip();
                    c.rep.data = Arrays.copyOf(this.defaultBuffer.elements(), this.defaultBuffer.limit() + 4);
                    break;
                }
                case CMWLIGHT: {
                    this.serialiser.setMatchedIoSerialiser(CmwLightSerialiser.class);
                    this.serialiser.getMatchedIoSerialiser().setBuffer(this.defaultBuffer);
                    this.serialiser.serialiseObject(output);
                    this.defaultBuffer.flip();
                    c.rep.data = Arrays.copyOf(this.defaultBuffer.elements(), this.defaultBuffer.limit());
                    break;
                }
                default: {
                    this.serialiser.setMatchedIoSerialiser(BinarySerialiser.class);
                    this.serialiser.getMatchedIoSerialiser().setBuffer(this.defaultBuffer);
                    this.serialiser.serialiseObject(output);
                    this.defaultBuffer.flip();
                    c.rep.data = Arrays.copyOf(this.defaultBuffer.elements(), this.defaultBuffer.limit());
                }
            }
        });
    }

    @Override
    public BasicMdpWorker registerHandler(BasicMdpWorker.RequestHandler requestHandler) {
        throw new UnsupportedOperationException("do not overwrite low-level request handler, use either 'setHandler(...)' or " + BasicMdpWorker.class.getName() + " directly");
    }

    public Handler<C, I, O> getHandler() {
        return this.handler;
    }

    public void setHandler(Handler<C, I, O> handler) {
        this.handler = handler;
    }

    public Handler<C, I, O> getHtmlHandler() {
        return this.htmlHandler;
    }

    public void setHtmlHandler(Handler<C, I, O> htmlHandler) {
        this.htmlHandler = htmlHandler;
    }

    public void notify(C replyCtx, O reply) {
        this.defaultNotifyBuffer.reset();
        this.notifySerialiser.serialiseObject(reply);
        this.defaultNotifyBuffer.flip();
        byte[] data = Arrays.copyOf(this.defaultNotifyBuffer.elements(), this.defaultNotifyBuffer.limit());
        URI topic = URI.create(this.serviceName + "?" + QueryParameterParser.generateQueryParameter(replyCtx));
        OpenCmwProtocol.MdpMessage notifyMessage = new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_WORKER, OpenCmwProtocol.Command.W_NOTIFY, this.serviceBytes, OpenCmwProtocol.EMPTY_FRAME, topic, data, "", RBAC);
        super.notify(notifyMessage);
    }

    public static interface Handler<C, I, O> {
        public void handle(OpenCmwProtocol.Context var1, C var2, I var3, C var4, O var5);
    }
}

