/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server;

import io.opencmw.OpenCmwProtocol;
import io.opencmw.QueryParameterParser;
import io.opencmw.domain.BinaryData;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import io.opencmw.serialiser.utils.ClassUtils;
import io.opencmw.server.MajordomoWorker;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.zeromq.util.ZData;

public class DefaultHtmlHandler<C, I, O>
implements MajordomoWorker.Handler<C, I, O> {
    public static final String NO_MENU = "noMenu";
    private static final String TEMPLATE_DEFAULT = "/velocity/property/defaultPropertyLayout.vm";
    protected final Class<?> mdpWorkerClass;
    protected final Consumer<Map<String, Object>> userContextMapModifier;
    protected final String velocityTemplate;
    protected final VelocityEngine velocityEngine = new VelocityEngine();

    public DefaultHtmlHandler(Class<?> mdpWorkerClass, String velocityTemplate, Consumer<Map<String, Object>> userContextMapModifier) {
        this.mdpWorkerClass = mdpWorkerClass;
        this.velocityTemplate = velocityTemplate == null ? TEMPLATE_DEFAULT : velocityTemplate;
        this.userContextMapModifier = userContextMapModifier;
        this.velocityEngine.setProperty("resource.loaders", (Object)"class");
        this.velocityEngine.setProperty("resource.loader.class.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.setProperty("velocimacro.library.autoreload", (Object)"true");
        this.velocityEngine.setProperty("resource.loader.file.cache", (Object)"false");
        this.velocityEngine.setProperty("velocimacro.inline.replace_global", (Object)"true");
        this.velocityEngine.init();
    }

    @Override
    public void handle(OpenCmwProtocol.Context rawCtx, C requestCtx, I request, C replyCtx, O reply) {
        byte[] rawData;
        String queryString = rawCtx.req.topic.getQuery();
        boolean noMenu = queryString != null && queryString.contains(NO_MENU);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(NO_MENU, noMenu);
        try {
            context.put("requestedURI", rawCtx.req.topic.toString());
            context.put("requestedURInoFrame", QueryParameterParser.appendQueryParameter((URI)rawCtx.req.topic, (String)NO_MENU).toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("appendURI error for " + rawCtx.req.topic, e);
        }
        ClassFieldDescription fieldDescription = this.mdpWorkerClass == null ? null : ClassUtils.getFieldDescription(this.mdpWorkerClass, (Class[])new Class[0]);
        context.put("service", StringUtils.stripStart((String)rawCtx.req.topic.getPath(), (String)"/"));
        context.put("mdpClass", this.mdpWorkerClass);
        context.put("mdpMetaData", fieldDescription);
        context.put("mdpCommand", rawCtx.req.command);
        context.put("clientRequestID", ZData.toString((byte[])rawCtx.req.clientRequestID));
        context.put("requestTopic", rawCtx.req.topic);
        context.put("replyTopic", rawCtx.rep.topic);
        context.put("requestCtx", requestCtx);
        context.put("replyCtx", replyCtx);
        context.put("request", request);
        context.put("reply", reply);
        context.put("requestCtxClassData", DefaultHtmlHandler.generateQueryParameter(requestCtx));
        context.put("replyCtxClassData", DefaultHtmlHandler.generateQueryParameter(replyCtx));
        context.put("requestClassData", DefaultHtmlHandler.generateQueryParameter(request));
        if (BinaryData.class.equals(request.getClass())) {
            rawData = ((BinaryData)request).data;
            context.put("requestMimeType", ((BinaryData)reply).contentType.toString());
            context.put("requestResourceName", ((BinaryData)reply).resourceName);
            context.put("requestRawData", Base64.getEncoder().encodeToString(rawData));
        }
        context.put("replyClassData", DefaultHtmlHandler.generateQueryParameter(reply));
        if (BinaryData.class.equals(reply.getClass())) {
            rawData = ((BinaryData)reply).data;
            context.put("replyMimeType", ((BinaryData)reply).contentType.toString());
            context.put("replyResourceName", ((BinaryData)reply).resourceName);
            context.put("replyRawData", Base64.getEncoder().encodeToString(rawData));
        }
        if (this.userContextMapModifier != null) {
            this.userContextMapModifier.accept(context);
        }
        StringWriter writer = new StringWriter();
        this.velocityEngine.getTemplate(this.velocityTemplate).merge((Context)new VelocityContext(context), (Writer)writer);
        String returnVal = writer.toString();
        rawCtx.rep.data = returnVal.getBytes(StandardCharsets.UTF_8);
    }

    public static Map<ClassFieldDescription, String> generateQueryParameter(Object obj) {
        ClassFieldDescription fieldDescription = ClassUtils.getFieldDescription(obj.getClass(), (Class[])new Class[0]);
        HashMap<ClassFieldDescription, String> map = new HashMap<ClassFieldDescription, String>();
        List children = fieldDescription.getChildren();
        for (FieldDescription child : children) {
            ClassFieldDescription field = (ClassFieldDescription)child;
            BiFunction mapFunction = (BiFunction)QueryParameterParser.CLASS_TO_STRING_CONVERTER.get(field.getType());
            String str = mapFunction == null ? (String)((BiFunction)QueryParameterParser.CLASS_TO_STRING_CONVERTER.get(Object.class)).apply(obj, field) : (String)mapFunction.apply(obj, field);
            map.put(field, StringUtils.stripEnd((String)StringUtils.stripStart((String)str, (String)"\"["), (String)"\"]"));
        }
        return map;
    }
}

