/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server.rest.login;

import io.javalin.apibuilder.ApiBuilder;
import io.javalin.core.security.AccessManager;
import io.javalin.core.security.Role;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.plugin.openapi.annotations.OpenApi;
import io.javalin.plugin.openapi.annotations.OpenApiContent;
import io.javalin.plugin.openapi.annotations.OpenApiResponse;
import io.opencmw.rbac.BasicRbacRole;
import io.opencmw.rbac.RbacRole;
import io.opencmw.server.rest.RestRole;
import io.opencmw.server.rest.RestServer;
import io.opencmw.server.rest.user.RestUserHandler;
import io.opencmw.server.rest.util.MessageBundle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);
    public static final String LOGIN_CONTROLLER = "LoginController";
    private static final String HTTP_200_OK = "200";
    private static final String MIME_HTML = "text/html";
    private static final String MIME_JSON = "text/json";
    private static final String DEFAULT_USER = "anonymous";
    private static final String ENDPOINT_LOGIN = "/login";
    private static final String ENDPOINT_LOGOUT = "/logout";
    private static final String ENDPOINT_CHANGE_PASSWORD = "/changepassword";
    private static final String ATTR_LOCALE = "locale";
    private static final String ATTR_CURRENT_USER = "currentUser";
    private static final String ATTR_CURRENT_ROLES = "currentRoles";
    private static final String ATTR_LOGIN_REDIRECT = "loginRedirect";
    private static final String ATTR_LOGGED_OUT = "loggedOut";
    private static final String QUERY_PASSWORD = "password";
    private static final String QUERY_PASSWORD_NEW1 = "passwordNew1";
    private static final String QUERY_PASSWORD_NEW2 = "passwordNew2";
    private static final String QUERY_USERNAME = "username";
    private static final String AUTHENTICATION_SUCCEEDED = "authenticationSucceeded";
    private static final String AUTHENTICATION_FAILED = "authenticationFailed";
    private static final String AUTHENTICATION_PASSWORD_MISMATCH = "authenticationFailedPasswordsMismatch";
    private static final String TEMPLATE_LOGIN = "/velocity/login/login.vm";
    private static final String TEMPLATE_PASSWORD_CHANGE = "/velocity/login/changePassword.vm";
    private static final Handler handleLocaleChange = ctx -> {
        if (ctx.queryParam(ATTR_LOCALE) != null) {
            ctx.sessionAttribute(ATTR_LOCALE, (Object)ctx.queryParam(ATTR_LOCALE));
            ctx.redirect(ctx.path());
        }
    };
    @OpenApi(description="endpoint to receive password login request", operationId="handleLoginPost", summary="POST login command", tags={"LoginController"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/json")})})
    private static final Handler handleLoginPost = ctx -> {
        String userName;
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        RestUserHandler userHandler = RestServer.getUserHandler();
        if (userHandler.authenticate(userName = ctx.formParam(QUERY_USERNAME), ctx.formParam(QUERY_PASSWORD))) {
            ctx.sessionAttribute(ATTR_CURRENT_USER, (Object)userName);
            ctx.sessionAttribute(ATTR_CURRENT_ROLES, userHandler.getUserRolesByUsername(userName));
            model.put(AUTHENTICATION_SUCCEEDED, true);
            model.put(ATTR_CURRENT_USER, userName);
            model.put(ATTR_CURRENT_ROLES, userHandler.getUserRolesByUsername(userName));
            String loginRedirect = (String)ctx.sessionAttribute(ATTR_LOGIN_REDIRECT);
            if (loginRedirect != null) {
                ctx.redirect(loginRedirect);
            }
        } else {
            model.put(AUTHENTICATION_FAILED, true);
        }
        ctx.render(TEMPLATE_LOGIN, model);
    };
    @OpenApi(description="endpoint to receive password changes", operationId="handleChangePasswordPost", summary="POST password change page", tags={"LoginController"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    private static final Handler handleChangePasswordPost = ctx -> {
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        String userName = ctx.formParam(QUERY_USERNAME);
        String password1 = ctx.formParam(QUERY_PASSWORD_NEW1);
        String password2 = ctx.formParam(QUERY_PASSWORD_NEW2);
        if (userName == null || password1 == null || password2 == null) {
            model.put(AUTHENTICATION_FAILED, true);
            ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
            return;
        }
        if (!(LoginController.checkPasswordCriteria(password1) && LoginController.checkPasswordCriteria(password2) && password1.equals(password2))) {
            LOGGER.atWarn().addArgument((Object)userName).log("password do not match for user '{}'");
            model.put(AUTHENTICATION_PASSWORD_MISMATCH, true);
            ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
            return;
        }
        model.put(AUTHENTICATION_PASSWORD_MISMATCH, false);
        try {
            String password = ctx.formParam(QUERY_PASSWORD);
            if (password == null) {
                model.put(AUTHENTICATION_FAILED, true);
                ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
                return;
            }
            RestUserHandler userHandler = RestServer.getUserHandler();
            if (userHandler.setPassword(userName, password, password1)) {
                ctx.sessionAttribute(ATTR_CURRENT_USER, (Object)userName);
                ctx.sessionAttribute(ATTR_CURRENT_ROLES, userHandler.getUserRolesByUsername(userName));
                model.put(AUTHENTICATION_SUCCEEDED, true);
                model.put(ATTR_CURRENT_USER, userName);
                model.put(ATTR_CURRENT_ROLES, userHandler.getUserRolesByUsername(userName));
                ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
                return;
            }
            model.put(AUTHENTICATION_FAILED, true);
            ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
        }
        catch (SecurityException e) {
            LOGGER.atWarn().setCause((Throwable)e).addArgument((Object)userName).log("may not change password for user '{}'");
        }
        model.put(AUTHENTICATION_FAILED, true);
        ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
    };
    @OpenApi(description="endpoint to receive password logout request", operationId="handleLogoutPost", summary="POST logout command", tags={"LoginController"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/json")})})
    private static final Handler handleLogoutPost = ctx -> {
        ctx.sessionAttribute(ATTR_CURRENT_USER, null);
        ctx.sessionAttribute(ATTR_CURRENT_ROLES, null);
        ctx.sessionAttribute(ATTR_LOGGED_OUT, (Object)"true");
        ctx.redirect(ENDPOINT_LOGIN);
    };
    @OpenApi(description="endpoint to serve login page", operationId="serveLoginPage", summary="GET serve login page (HTML-only)", tags={"LoginController"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    private static final Handler serveLoginPage = ctx -> {
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        model.put(ATTR_LOGGED_OUT, LoginController.removeSessionAttrLoggedOut(ctx));
        ctx.render(TEMPLATE_LOGIN, model);
    };
    @OpenApi(description="endpoint to serve password change page", operationId="servePasswordChangePage", summary="GET serve password change page (HTML-only)", tags={"LoginController"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    private static final Handler servePasswordChangePage = ctx -> {
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        model.put(ATTR_LOGGED_OUT, LoginController.removeSessionAttrLoggedOut(ctx));
        ctx.render(TEMPLATE_PASSWORD_CHANGE, model);
    };
    public static final AccessManager accessManager = (handler, ctx, permittedRoles) -> {
        Set<RbacRole> userRoles = LoginController.getSessionCurrentRoles(ctx);
        Set<RbacRole> permittedRbacRoles = LoginController.convertRoles(permittedRoles);
        HashSet<RbacRole> intersection = new HashSet<RbacRole>(permittedRbacRoles);
        intersection.retainAll(userRoles);
        if (permittedRbacRoles.isEmpty() || permittedRbacRoles.contains(BasicRbacRole.ANYONE) || !intersection.isEmpty()) {
            handler.handle(ctx);
        } else {
            LOGGER.atWarn().addArgument((Object)ctx.path()).addArgument(permittedRbacRoles).addArgument(intersection).log("could not log into '{}' permitted roles {} vs. have {}");
            if (ctx.sessionAttribute(ATTR_CURRENT_USER) == null) {
                ctx.sessionAttribute(ATTR_LOGIN_REDIRECT, (Object)ctx.path());
                ctx.redirect(ENDPOINT_LOGIN);
            } else {
                ctx.status(401).result("Unauthorized");
            }
        }
    };

    private static Set<RbacRole> convertRoles(Set<Role> javalinRoles) {
        HashSet<RbacRole> set = new HashSet<RbacRole>();
        for (Role role : javalinRoles) {
            if (!(role instanceof RestRole)) continue;
            set.add(((RestRole)role).rbacRole);
        }
        return set;
    }

    private LoginController() {
    }

    public static Set<RbacRole> getSessionCurrentRoles(Context ctx) {
        Set<RbacRole> val = ctx.sessionAttribute(ATTR_CURRENT_ROLES);
        if (val == null) {
            val = RestServer.getUserHandler().getUserRolesByUsername(DEFAULT_USER);
        }
        if (!(val instanceof Set)) {
            return Collections.singleton(BasicRbacRole.NULL);
        }
        try {
            Set<RbacRole> roles = val;
            return roles;
        }
        catch (ClassCastException e) {
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)ATTR_CURRENT_ROLES).log("could not cast '{}' attribute to Set<RbacRole> -- something fishy is going on");
            return Collections.singleton(BasicRbacRole.NULL);
        }
    }

    public static String getSessionCurrentUser(Context ctx) {
        return (String)ctx.sessionAttribute(ATTR_CURRENT_USER);
    }

    public static String getSessionLocale(Context ctx) {
        return (String)ctx.sessionAttribute(ATTR_LOCALE);
    }

    public static void register() {
        RestServer.getInstance().config.accessManager(accessManager);
        RestServer.getInstance().routes(() -> {
            ApiBuilder.before((Handler)handleLocaleChange);
            ApiBuilder.post((String)ENDPOINT_LOGIN, (Handler)handleLoginPost);
            ApiBuilder.post((String)ENDPOINT_LOGOUT, (Handler)handleLogoutPost);
            ApiBuilder.post((String)ENDPOINT_CHANGE_PASSWORD, (Handler)handleChangePasswordPost);
            ApiBuilder.get((String)ENDPOINT_LOGIN, (Handler)serveLoginPage);
            ApiBuilder.get((String)ENDPOINT_CHANGE_PASSWORD, (Handler)servePasswordChangePage);
        });
    }

    private static boolean checkPasswordCriteria(String password) {
        return password != null && password.length() >= 8;
    }

    private static boolean removeSessionAttrLoggedOut(Context ctx) {
        String loggedOut = (String)ctx.sessionAttribute(ATTR_LOGGED_OUT);
        ctx.sessionAttribute(ATTR_LOGGED_OUT, null);
        return loggedOut != null;
    }
}

