/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server.rest;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import io.javalin.Javalin;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.core.compression.Gzip;
import io.javalin.core.event.HandlerMetaInfo;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.security.Role;
import io.javalin.core.util.RouteOverviewPlugin;
import io.javalin.http.Context;
import io.javalin.http.sse.SseClient;
import io.javalin.http.util.RateLimit;
import io.javalin.plugin.json.JavalinJson;
import io.javalin.plugin.metrics.MicrometerPlugin;
import io.javalin.plugin.openapi.OpenApiOptions;
import io.javalin.plugin.openapi.OpenApiPlugin;
import io.javalin.plugin.openapi.annotations.HttpMethod;
import io.javalin.plugin.openapi.ui.ReDocOptions;
import io.javalin.plugin.openapi.ui.SwaggerOptions;
import io.opencmw.MimeType;
import io.opencmw.rbac.BasicRbacRole;
import io.opencmw.rbac.RbacRole;
import io.opencmw.server.rest.RestRole;
import io.opencmw.server.rest.admin.RestServerAdmin;
import io.opencmw.server.rest.login.LoginController;
import io.opencmw.server.rest.user.RestUserHandler;
import io.opencmw.server.rest.user.RestUserHandlerImpl;
import io.opencmw.server.rest.util.MessageBundle;
import io.swagger.v3.oas.models.info.Info;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestServer {
    public static final String TAG_REST_SERVER_HOST_NAME = "restServerHostName";
    public static final String TAG_REST_SERVER_PORT = "restServerPort";
    public static final String TAG_REST_SERVER_PORT2 = "restServerPort2";
    public static final String REST_KEY_STORE = "restKeyStore";
    public static final String REST_KEY_STORE_PASSWORD = "restKeyStorePassword";
    public static final String HTML_ACCEPT = "accept";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServer.class);
    private static final String DEFAULT_HOST_NAME = "0";
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_PORT2 = 8443;
    private static final String REST_PROTOCOL = "protocol";
    private static final String TEMPLATE_UNAUTHORISED = "/velocity/errors/unauthorised.vm";
    private static final String TEMPLATE_ACCESS_DENIED = "/velocity/errors/accessDenied.vm";
    private static final String TEMPLATE_NOT_FOUND = "/velocity/errors/notFound.vm";
    private static final String TEMPLATE_BAD_REQUEST = "/velocity/errors/badRequest.vm";
    private static final ConcurrentMap<String, Queue<SseClient>> EVENT_LISTENER_SSE = new ConcurrentHashMap<String, Queue<SseClient>>();
    private static final List<HandlerMetaInfo> ENDPOINTS = new ArrayList<HandlerMetaInfo>();
    private static final Consumer<HandlerMetaInfo> ENDPOINT_ADDED_HANDLER = ENDPOINTS::add;
    private static Javalin instance;
    private static MimeType defaultProtocol;
    private static RestUserHandler userHandler;
    private static String serverName;

    private RestServer() {
    }

    public static void addLongPollingCookie(Context ctx, String key, long lastUpdateMillies) {
        String cookieComment = "stores the servcer-side time stamp of the last valid update (required for long-polling)";
        String cookie = key + "=" + lastUpdateMillies + "; Comment=\"stores the servcer-side time stamp of the last valid update (required for long-polling)\"; Expires=-1; SameSite=Strict;";
        ctx.res.addHeader("Set-Cookie", cookie);
    }

    public static URI appendUri(URI oldUri, String appendQuery) throws URISyntaxException {
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)(oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery), oldUri.getFragment());
    }

    public static void applyRateLimit(Context ctx, int numRequests, TimeUnit timeUnit) {
        new RateLimit(ctx).requestPerTimeUnit(numRequests, timeUnit);
    }

    public static MimeType getDefaultProtocol() {
        return defaultProtocol;
    }

    public static Set<Role> getDefaultRole() {
        return Collections.singleton(new RestRole((RbacRole)BasicRbacRole.ANYONE));
    }

    public static List<HandlerMetaInfo> getEndpoints() {
        return ENDPOINTS;
    }

    public static Queue<SseClient> getEventClients(@NotNull String endpointName) {
        if (endpointName.isEmpty()) {
            throw new IllegalArgumentException("endpointNmae must not be empty");
        }
        String fullEndPointName = RestServer.prefixPath(endpointName);
        return EVENT_LISTENER_SSE.computeIfAbsent(fullEndPointName, key -> new ConcurrentLinkedQueue());
    }

    public static ConcurrentMap<String, Queue<SseClient>> getEventClientMap() {
        return EVENT_LISTENER_SSE;
    }

    public static String getHostName() {
        return System.getProperty(TAG_REST_SERVER_HOST_NAME, DEFAULT_HOST_NAME);
    }

    public static int getHostPort() {
        String property = System.getProperty(TAG_REST_SERVER_PORT, Integer.toString(8080));
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.atError().addArgument((Object)TAG_REST_SERVER_PORT).addArgument((Object)property).addArgument((Object)8080).log("could not parse {}='{}' return default port {}");
            return 8080;
        }
    }

    public static int getHostPort2() {
        String property = System.getProperty(TAG_REST_SERVER_PORT2, Integer.toString(8443));
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.atError().addArgument((Object)TAG_REST_SERVER_PORT2).addArgument((Object)property).addArgument((Object)8443).log("could not parse {}='{}' return default port {}");
            return 8443;
        }
    }

    public static Javalin getInstance() {
        if (instance == null) {
            RestServer.startRestServer();
        }
        return instance;
    }

    public static URI getLocalURI() {
        try {
            return new URI("http://localhost:" + RestServer.getHostPort());
        }
        catch (URISyntaxException e) {
            LOGGER.atError().setCause((Throwable)e).log("getLocalURL()");
            return null;
        }
    }

    public static String getName() {
        return serverName;
    }

    public static URI getPublicURI() {
        String ip = RestServer.getLocalHostName();
        DatagramSocket socket = new DatagramSocket();
        try {
            URI uRI = new URI("https://" + ip + ":" + RestServer.getHostPort2());
            socket.close();
            return uRI;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SocketException | URISyntaxException e) {
                LOGGER.atError().setCause((Throwable)e).log("getPublicURL()");
                return null;
            }
        }
    }

    public static MimeType getRequestedMimeProtocol(Context ctx, MimeType ... defaultProtocol) {
        return MimeType.getEnum((String)RestServer.getRequestedProtocol(ctx, defaultProtocol.length == 0 ? RestServer.getDefaultProtocol().toString() : defaultProtocol[0].toString()));
    }

    public static String getRequestedProtocol(Context ctx, String ... defaultProtocol) {
        String protocol = defaultProtocol.length == 0 ? RestServer.getDefaultProtocol().toString() : defaultProtocol[0];
        String protocolHeader = ctx.header("Accept");
        String protocolQuery = ctx.queryParam(REST_PROTOCOL);
        if (protocolHeader != null && !protocolHeader.isBlank()) {
            protocol = protocolHeader;
        }
        if (protocolQuery != null && !protocolQuery.isBlank()) {
            protocol = protocolQuery;
        }
        return protocol;
    }

    public static Set<RbacRole> getSessionCurrentRoles(Context ctx) {
        return LoginController.getSessionCurrentRoles(ctx);
    }

    public static String getSessionCurrentUser(Context ctx) {
        return LoginController.getSessionCurrentUser(ctx);
    }

    public static String getSessionLocale(Context ctx) {
        return LoginController.getSessionLocale(ctx);
    }

    public static RestUserHandler getUserHandler() {
        return userHandler;
    }

    public static String prefixPath(@NotNull String path) {
        return ApiBuilder.prefixPath((String)path);
    }

    public static void setDefaultProtocol(MimeType defaultProtocol) {
        RestServer.defaultProtocol = defaultProtocol;
    }

    public static void setName(String serverName) {
        RestServer.serverName = serverName;
    }

    public static void setUserHandler(RestUserHandler newUserHandler) {
        LOGGER.atWarn().addArgument((Object)newUserHandler.getClass().getCanonicalName()).log("replacing default user handler with '{}'");
        userHandler = newUserHandler;
    }

    public static void startRestServer() {
        JavalinJson.setFromJsonMapper(JsonIterator::deserialize);
        JavalinJson.setToJsonMapper(JsonStream::serialize);
        instance = Javalin.create(config -> {
            config.enableCorsForAllOrigins();
            config.addStaticFiles("/public");
            config.showJavalinBanner = false;
            config.defaultContentType = RestServer.getDefaultProtocol().toString();
            config.compressionStrategy(null, new Gzip(6));
            config.server(RestServer::createHttp2Server);
            config.registerPlugin((Plugin)new RouteOverviewPlugin("/admin/endpoints", Collections.singleton(new RestRole((RbacRole)BasicRbacRole.ADMIN))));
            config.registerPlugin((Plugin)new MicrometerPlugin());
            config.sessionHandler(RestServer.getCustomSessionHandlerSupplier());
            config.registerPlugin((Plugin)new OpenApiPlugin(new OpenApiOptions[]{RestServer.getOpenApiOptions()}));
        }).events(event -> event.handlerAdded(ENDPOINT_ADDED_HANDLER));
        instance.start();
        LoginController.register();
        RestServerAdmin.register();
        instance.error(400, ctx -> ctx.render(TEMPLATE_BAD_REQUEST, MessageBundle.baseModel(ctx)));
        instance.error(401, ctx -> ctx.render(TEMPLATE_UNAUTHORISED, MessageBundle.baseModel(ctx)));
        instance.error(403, ctx -> ctx.render(TEMPLATE_ACCESS_DENIED, MessageBundle.baseModel(ctx)));
        instance.error(404, ctx -> ctx.render(TEMPLATE_NOT_FOUND, MessageBundle.baseModel(ctx)));
    }

    public static void startRestServer(int hostPort, int hostPort2) {
        System.setProperty(TAG_REST_SERVER_PORT, Integer.toString(hostPort));
        System.setProperty(TAG_REST_SERVER_PORT2, Integer.toString(hostPort2));
        RestServer.startRestServer();
    }

    public static void startRestServer(String hostName, int hostPort, int hostPort2) {
        System.setProperty(TAG_REST_SERVER_HOST_NAME, hostName);
        System.setProperty(TAG_REST_SERVER_PORT, Integer.toString(hostPort));
        System.setProperty(TAG_REST_SERVER_PORT2, Integer.toString(hostPort2));
        RestServer.startRestServer();
    }

    public static void stopRestServer() {
        if (Objects.requireNonNull(RestServer.getInstance().server()).server().isRunning()) {
            RestServer.getInstance().stop();
        }
    }

    public static void suppressCaching(Context ctx) {
        ctx.res.addHeader("Cache-Control", "no-store");
        ctx.res.addHeader("Pragma", "no-cache");
        ctx.res.addHeader("Expires", DEFAULT_HOST_NAME);
    }

    public static void writeBytesToContext(@NotNull Context ctx, byte[] bytes, int nSize) {
        try (ServletOutputStream outputStream = ctx.res.getOutputStream();){
            outputStream.write(bytes, 0, nSize);
            outputStream.flush();
        }
        catch (IOException e) {
            LOGGER.atError().setCause((Throwable)e);
        }
    }

    private static Server createHttp2Server() {
        Server server = new Server();
        try (ServerConnector connector = new ServerConnector(server);){
            String hostName = RestServer.getHostName();
            int hostPort = RestServer.getHostPort();
            LOGGER.atInfo().addArgument((Object)RestServer.getLocalHostName()).log("local hostname = '{}'");
            LOGGER.atInfo().addArgument((Object)hostName).addArgument((Object)hostPort).log("create HTTP 1.x connector at 'http://{}:{}'");
            connector.setHost(hostName);
            connector.setPort(hostPort);
            server.addConnector((Connector)connector);
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(RestServer.getHostPort2());
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol("h2");
        SslConnectionFactory ssl = new SslConnectionFactory(RestServer.createSslContextFactory(), alpn.getProtocol());
        try (ServerConnector http2Connector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfig)});){
            String hostName = RestServer.getHostName();
            int hostPort = RestServer.getHostPort2();
            LOGGER.atInfo().addArgument((Object)hostName).addArgument((Object)hostPort).log("create HTTP/2 connector at 'http://{}:{}'");
            http2Connector.setHost(hostName);
            http2Connector.setPort(hostPort);
            server.addConnector((Connector)http2Connector);
        }
        return server;
    }

    private static SslContextFactory createSslContextFactory() {
        String keyStoreFile = System.getProperty(REST_KEY_STORE, null);
        String keyStorePwdFile = System.getProperty(REST_KEY_STORE_PASSWORD, null);
        if (keyStoreFile == null || keyStorePwdFile == null) {
            LOGGER.atInfo().addArgument((Object)keyStoreFile).addArgument((Object)keyStorePwdFile).log("using internal keyStore {} and/or keyStorePasswordFile {} -- PLEASE CHANGE FOR PRODUCTION -- THIS IS UNSAFE PRACTICE");
        }
        LOGGER.atInfo().addArgument((Object)keyStoreFile).log("using keyStore at '{}'");
        LOGGER.atInfo().addArgument((Object)keyStorePwdFile).log("using keyStorePasswordFile at '{}'");
        boolean readComplete = true;
        String keyStorePwd = null;
        KeyStore keyStore = null;
        try (BufferedReader br = keyStorePwdFile == null ? new BufferedReader(new InputStreamReader(RestServer.class.getResourceAsStream("/keystore.pwd"), StandardCharsets.UTF_8)) : Files.newBufferedReader(Paths.get(keyStorePwdFile, new String[0]), StandardCharsets.UTF_8);){
            keyStorePwd = br.readLine();
        }
        catch (IOException e) {
            readComplete = false;
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)keyStorePwdFile).log("error while reading key store password from '{}'");
        }
        if (readComplete && keyStorePwd != null) {
            try (InputStream is = keyStoreFile == null ? RestServer.class.getResourceAsStream("/keystore.jks") : Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(is, keyStorePwd.toCharArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                readComplete = false;
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)(keyStoreFile == null ? "internal" : keyStoreFile)).log("error while reading key store from '{}'");
            }
        }
        SslContextFactory sslContextFactory = new SslContextFactory(true){};
        if (readComplete) {
            sslContextFactory.setKeyStore(keyStore);
            sslContextFactory.setKeyStorePassword(keyStorePwd);
        }
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        sslContextFactory.setProvider("Conscrypt");
        return sslContextFactory;
    }

    private static Supplier<SessionHandler> getCustomSessionHandlerSupplier() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.getSessionCookieConfig().setHttpOnly(true);
        sessionHandler.getSessionCookieConfig().setSecure(true);
        sessionHandler.getSessionCookieConfig().setComment("__SAME_SITE_STRICT__");
        return () -> sessionHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLocalHostName() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            if (socket.getLocalAddress() == null) {
                throw new UnknownHostException("bogus exception can be ignored");
            }
            String ip = socket.getLocalAddress().getHostAddress();
            if (ip == null) return "localhost";
            String string = ip;
            return string;
        }
        catch (SocketException | UnknownHostException e) {
            LOGGER.atError().setCause((Throwable)e).log("getLocalHostName()");
        }
        return "localhost";
    }

    private static OpenApiOptions getOpenApiOptions() {
        Info applicationInfo = new Info().version("1.0").description(serverName);
        return new OpenApiOptions(applicationInfo).path("/swagger-docs").ignorePath("/admin/endpoints", new HttpMethod[]{HttpMethod.GET}).swagger((SwaggerOptions)new SwaggerOptions("/swagger").title("My Swagger Documentation")).reDoc((ReDocOptions)new ReDocOptions("/redoc").title("My ReDoc Documentation"));
    }

    static {
        defaultProtocol = MimeType.HTML;
        userHandler = new RestUserHandlerImpl((RbacRole)BasicRbacRole.NULL);
        serverName = "Undefined REST Server";
    }
}

