/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.server.rest;

import com.google.common.io.ByteStreams;
import com.jsoniter.extra.Base64Support;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.core.security.Role;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.sse.SseClient;
import io.javalin.plugin.openapi.dsl.Composition;
import io.javalin.plugin.openapi.dsl.DocumentedContent;
import io.javalin.plugin.openapi.dsl.DocumentedContentKt;
import io.javalin.plugin.openapi.dsl.OpenApiBuilder;
import io.javalin.plugin.openapi.dsl.OpenApiDocumentation;
import io.opencmw.MimeType;
import io.opencmw.OpenCmwConstants;
import io.opencmw.OpenCmwProtocol;
import io.opencmw.QueryParameterParser;
import io.opencmw.rbac.RbacRole;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.annotations.MetaInfo;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import io.opencmw.serialiser.utils.ClassUtils;
import io.opencmw.server.BasicMdpWorker;
import io.opencmw.server.MajordomoWorker;
import io.opencmw.server.rest.RestServer;
import io.opencmw.server.rest.util.CombinedHandler;
import io.opencmw.server.rest.util.MessageBundle;
import io.opencmw.utils.CustomFuture;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.net.ProtocolException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

@MetaInfo(description="Majordomo Broker REST/HTTP plugin.<br><br> This opens two http ports and converts and forwards incoming request to the OpenCMW protocol and provides<br> some basic admin functionality<br>", unit="MajordomoRestPlugin")
public class MajordomoRestPlugin
extends BasicMdpWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajordomoRestPlugin.class);
    private static final byte[] RBAC = new byte[0];
    private static final String TEMPLATE_EMBEDDED_HTML = "/velocity/property/defaultTextPropertyLayout.vm";
    private static final String TEMPLATE_BAD_REQUEST = "/velocity/errors/badRequest.vm";
    private static final String TAG_MENU_ITEMS = "navContent";
    private static final AtomicLong REQUEST_COUNTER = new AtomicLong();
    protected final ZMQ.Socket subSocket;
    protected final Map<String, AtomicInteger> subscriptionCount = new ConcurrentHashMap<String, AtomicInteger>();
    protected static final byte[] REST_SUB_ID = "REST_SUBSCRIPTION".getBytes(StandardCharsets.UTF_8);
    protected final ConcurrentMap<String, OpenApiDocumentation> registeredEndpoints = new ConcurrentHashMap<String, OpenApiDocumentation>();
    private final BlockingArrayQueue<OpenCmwProtocol.MdpMessage> requestQueue = new BlockingArrayQueue();
    private final ConcurrentMap<String, CustomFuture<OpenCmwProtocol.MdpMessage>> requestReplies = new ConcurrentHashMap<String, CustomFuture<OpenCmwProtocol.MdpMessage>>();
    private final BiConsumer<SseClient, CombinedHandler.SseState> newSseClientHandler;
    private final AtomicReference<String> rootService = new AtomicReference<String>("/mmi.service");
    private final Map<String, String> menuMap = new ConcurrentSkipListMap<String, String>();

    public MajordomoRestPlugin(ZContext ctx, String serverDescription, String httpAddress, RbacRole<?> ... rbacRoles) {
        super(ctx, MajordomoRestPlugin.class.getSimpleName(), rbacRoles);
        assert (httpAddress != null);
        RestServer.setName(Objects.requireNonNullElse(serverDescription, MajordomoRestPlugin.class.getName()));
        this.subSocket = ctx.createSocket(SocketType.SUB);
        OpenCmwConstants.setDefaultSocketParameters((ZMQ.Socket)this.subSocket);
        this.subSocket.connect("inproc://broker/publisher");
        this.subSocket.subscribe("mmi.service");
        this.subscriptionCount.computeIfAbsent("mmi.service", s -> new AtomicInteger()).incrementAndGet();
        this.newSseClientHandler = (client, state) -> {
            String queryString = client.ctx.queryString() == null ? "" : "?" + client.ctx.queryString();
            String subService = StringUtils.stripEnd((String)StringUtils.stripStart((String)client.ctx.path(), (String)"/"), (String)"/") + queryString;
            LOGGER.atDebug().addArgument((Object)state).addArgument((Object)subService).addArgument((Object)this.subscriptionCount.computeIfAbsent(subService, s -> new AtomicInteger()).get()).log("RestPlugin {} to '{}' - existing subscriber count: {}");
            if (state == CombinedHandler.SseState.CONNECTED && this.subscriptionCount.computeIfAbsent(subService, s -> new AtomicInteger()).incrementAndGet() == 1) {
                this.subSocket.subscribe(subService);
            }
            if (state == CombinedHandler.SseState.DISCONNECTED && this.subscriptionCount.computeIfAbsent(subService, s -> new AtomicInteger()).decrementAndGet() <= 0) {
                this.subSocket.unsubscribe(subService);
                this.subscriptionCount.remove(subService);
            }
        };
        RestServer.getInstance().get("/", restCtx -> restCtx.redirect(this.rootService.get()), RestServer.getDefaultRole());
        this.registerHandler(this.getDefaultRequestHandler());
        LOGGER.atInfo().addArgument((Object)MajordomoRestPlugin.class.getName()).addArgument((Object)RestServer.getPublicURI()).log("{} started on address: {}");
    }

    public AtomicReference<String> getRootService() {
        return this.rootService;
    }

    public Map<String, String> getMenuMap() {
        return this.menuMap;
    }

    public boolean notify(@NotNull OpenCmwProtocol.MdpMessage notifyMessage) {
        this.notifyRaw(notifyMessage);
        return false;
    }

    public synchronized void start() {
        super.start();
        Thread dispatcher = new Thread(this.getDispatcherTask());
        dispatcher.setDaemon(true);
        dispatcher.setName(MajordomoRestPlugin.class.getSimpleName() + "Dispatcher");
        dispatcher.start();
        Thread serviceListener = new Thread(this.getServiceSubscriptionTask());
        serviceListener.setDaemon(true);
        serviceListener.setName(MajordomoRestPlugin.class.getSimpleName() + "Subscriptions");
        serviceListener.start();
        String services = "(uninitialised)";
        CustomFuture<OpenCmwProtocol.MdpMessage> reply = this.dispatchRequest(new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_CLIENT, OpenCmwProtocol.Command.GET_REQUEST, "mmi.service".getBytes(StandardCharsets.UTF_8), OpenCmwProtocol.EMPTY_FRAME, URI.create("mmi.service"), OpenCmwProtocol.EMPTY_FRAME, "", RBAC));
        try {
            OpenCmwProtocol.MdpMessage msg = (OpenCmwProtocol.MdpMessage)reply.get();
            services = msg.data == null ? "" : new String(msg.data, StandardCharsets.UTF_8);
            Arrays.stream(StringUtils.split((String)services, (String)",:;")).forEach(this::registerEndPoint);
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)services).log("could not perform initial registering of endpoints {}");
        }
    }

    protected static OpenCmwProtocol.Command getCommand(@NotNull Context restCtx) {
        switch (restCtx.method()) {
            case "GET": {
                return OpenCmwProtocol.Command.GET_REQUEST;
            }
            case "POST": {
                return OpenCmwProtocol.Command.SET_REQUEST;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atWarn().addArgument((Object)restCtx.req).log("unknown request: {}");
        }
        return OpenCmwProtocol.Command.UNKNOWN;
    }

    protected BasicMdpWorker.RequestHandler getDefaultRequestHandler() {
        return handler -> {
            switch (handler.req.command) {
                case PARTIAL: 
                case FINAL: {
                    if (handler.req.clientRequestID.length == 0 || Arrays.equals(REST_SUB_ID, handler.req.clientRequestID)) {
                        handler.rep = null;
                        break;
                    }
                    String clientRequestID = new String(handler.req.clientRequestID, StandardCharsets.UTF_8);
                    CustomFuture replyFuture = (CustomFuture)this.requestReplies.remove(clientRequestID);
                    if (replyFuture == null) {
                        LOGGER.atWarn().addArgument((Object)clientRequestID).addArgument((Object)handler.req).log("could not match clientRequestID '{}' to Future. msg was: {}");
                        return;
                    }
                    if (handler.req.errors == null || handler.req.errors.isBlank()) {
                        replyFuture.setReply((Object)handler.req);
                    } else {
                        replyFuture.setException((Throwable)new ProtocolException(handler.req.errors));
                    }
                    handler.rep = null;
                    return;
                }
                case W_NOTIFY: {
                    String serviceName = handler.req.getSenderName();
                    String topicName = handler.req.topic.toString();
                    long eventTimeStamp = System.currentTimeMillis();
                    String notifyMessage = "new '" + topicName + "' @" + eventTimeStamp;
                    Queue<SseClient> sseClients = RestServer.getEventClients(serviceName);
                    sseClients.forEach(client -> client.sendEvent(notifyMessage));
                    return;
                }
            }
        };
    }

    protected Runnable getDispatcherTask() {
        return () -> {
            this.shallRun.set(true);
            ArrayDeque<OpenCmwProtocol.MdpMessage> notifyCopy = new ArrayDeque<OpenCmwProtocol.MdpMessage>();
            while (this.shallRun.get() && !Thread.interrupted()) {
                BlockingArrayQueue<OpenCmwProtocol.MdpMessage> blockingArrayQueue = this.requestQueue;
                synchronized (blockingArrayQueue) {
                    try {
                        this.requestQueue.wait();
                        if (!this.requestQueue.isEmpty()) {
                            notifyCopy.addAll((Collection<OpenCmwProtocol.MdpMessage>)this.requestQueue);
                            this.requestQueue.clear();
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.atWarn().setCause((Throwable)e).log("Interrupted!");
                        Thread.currentThread().interrupt();
                    }
                }
                if (notifyCopy.isEmpty()) continue;
                notifyCopy.forEach(this::notify);
                notifyCopy.clear();
            }
        };
    }

    protected Runnable getServiceSubscriptionTask() {
        return () -> {
            this.shallRun.set(true);
            try (ZMQ.Poller subPoller = this.ctx.createPoller(1);){
                subPoller.register(this.subSocket, 1);
                while (this.shallRun.get() && !Thread.interrupted() && !this.ctx.isClosed() && subPoller.poll(TimeUnit.MILLISECONDS.toMillis(100L)) != -1) {
                    if (this.ctx.isClosed()) {
                        break;
                    }
                    boolean dataReceived = true;
                    while (dataReceived && !this.ctx.isClosed()) {
                        dataReceived = false;
                        OpenCmwProtocol.MdpMessage brokerMsg = OpenCmwProtocol.MdpMessage.receive((ZMQ.Socket)this.subSocket, (boolean)false);
                        if (brokerMsg == null) continue;
                        dataReceived = true;
                        this.liveness = this.heartBeatLiveness;
                        if (brokerMsg.data != null && brokerMsg.getServiceName().startsWith("mmi.service")) {
                            String newServiceName = new String(brokerMsg.data, StandardCharsets.UTF_8);
                            this.registerEndPoint(newServiceName);
                            if (newServiceName.contains("/mmi.")) {
                                this.registerEndPoint(StringUtils.split((String)newServiceName, (String)"/", (int)2)[1]);
                            }
                        }
                        this.notifySubscribedClients(brokerMsg.topic);
                    }
                }
            }
        };
    }

    protected void reconnectToBroker() {
        super.reconnectToBroker();
        byte[] classNameByte = ((Object)((Object)this)).getClass().getName().getBytes(StandardCharsets.UTF_8);
        new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_WORKER, OpenCmwProtocol.Command.READY, this.serviceBytes, OpenCmwProtocol.EMPTY_FRAME, Objects.requireNonNull(RestServer.getPublicURI()), classNameByte, "", RBAC).send(this.workerSocket);
        new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_WORKER, OpenCmwProtocol.Command.READY, this.serviceBytes, OpenCmwProtocol.EMPTY_FRAME, Objects.requireNonNull(RestServer.getLocalURI()), classNameByte, "", RBAC).send(this.workerSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerEndPoint(String endpoint) {
        ConcurrentMap<String, OpenApiDocumentation> concurrentMap = this.registeredEndpoints;
        synchronized (concurrentMap) {
            this.registeredEndpoints.computeIfAbsent(endpoint, ep -> {
                OpenCmwProtocol.MdpMessage requestMsg = new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_CLIENT, OpenCmwProtocol.Command.GET_REQUEST, "mmi.openapi".getBytes(StandardCharsets.UTF_8), OpenCmwProtocol.EMPTY_FRAME, URI.create("mmi.openapi"), ep.getBytes(StandardCharsets.UTF_8), "", RBAC);
                CustomFuture<OpenCmwProtocol.MdpMessage> openApiReply = this.dispatchRequest(requestMsg);
                try {
                    OpenCmwProtocol.MdpMessage serviceOpenApiData = (OpenCmwProtocol.MdpMessage)openApiReply.get();
                    if (!serviceOpenApiData.errors.isBlank()) {
                        LOGGER.atWarn().addArgument(ep).addArgument((Object)serviceOpenApiData).log("received erroneous message for service '{}': {}");
                        return null;
                    }
                    String handlerClassName = new String(serviceOpenApiData.data, StandardCharsets.UTF_8);
                    OpenApiDocumentation openApi = this.getOpenApiDocumentation(handlerClassName);
                    Set<Role> accessRoles = RestServer.getDefaultRole();
                    RestServer.getInstance().routes(() -> {
                        ApiBuilder.before((String)ep, restCtx -> {
                            Map map;
                            if ("POST".equals(restCtx.method()) && (map = restCtx.formParamMap()).size() == 0) {
                                LOGGER.atDebug().addArgument((Object)restCtx.req.getPathInfo()).log("{} called without form data");
                            }
                        });
                        ApiBuilder.post((String)(ep + "*"), (Handler)OpenApiBuilder.documented((OpenApiDocumentation)openApi, (Handler)this.getDefaultServiceRestHandler((String)ep)), (Set)accessRoles);
                        ApiBuilder.get((String)(ep + "*"), (Handler)OpenApiBuilder.documented((OpenApiDocumentation)openApi, (Handler)this.getDefaultServiceRestHandler((String)ep)), (Set)accessRoles);
                    });
                    return openApi;
                }
                catch (Exception e) {
                    LOGGER.atError().setCause((Throwable)e).addArgument(ep).log("could not register endpoint {}");
                    return null;
                }
            });
        }
    }

    @NotNull
    private OpenApiDocumentation getOpenApiDocumentation(String handlerClassName) {
        OpenApiDocumentation openApi = OpenApiBuilder.document();
        try {
            Class<?> clazz = Class.forName(handlerClassName);
            ClassFieldDescription fieldDescription = ClassUtils.getFieldDescription(clazz, (Class[])new Class[0]);
            openApi.operation(openApiOperation -> {
                openApiOperation.description(fieldDescription.getFieldDescription() + " - " + handlerClassName);
                openApiOperation.operationId("myOperationId");
                openApiOperation.summary(fieldDescription.getFieldUnit());
                openApiOperation.deprecated(Boolean.valueOf(false));
                openApiOperation.addTagsItem("user");
            });
            if (MajordomoWorker.class.isAssignableFrom(clazz)) {
                ParameterizedType genericSuperClass = (ParameterizedType)clazz.getGenericSuperclass();
                Class ctxClass = (Class)genericSuperClass.getActualTypeArguments()[0];
                Class inClass = (Class)genericSuperClass.getActualTypeArguments()[1];
                Class outClass = (Class)genericSuperClass.getActualTypeArguments()[2];
                ClassFieldDescription ctxFilter = ClassUtils.getFieldDescription((Class)ctxClass, (Class[])new Class[0]);
                for (FieldDescription field : ctxFilter.getChildren()) {
                    ClassFieldDescription classField = (ClassFieldDescription)field;
                    openApi.queryParam(classField.getFieldName(), (Class)classField.getType());
                    openApi.formParam(classField.getFieldName(), (Class)classField.getType(), false);
                }
                openApi.body((Composition)DocumentedContentKt.anyOf((DocumentedContent[])new DocumentedContent[]{DocumentedContentKt.documentedContent((Class)outClass), DocumentedContentKt.documentedContent((Class)inClass)}));
                openApi.body(outClass).json("200", outClass);
                openApi.html("200").result("demo output");
            }
        }
        catch (Exception e) {
            LOGGER.atWarn().setCause((Throwable)e).addArgument((Object)handlerClassName).log("could not find class definition for {}");
        }
        return openApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomFuture<OpenCmwProtocol.MdpMessage> dispatchRequest(OpenCmwProtocol.MdpMessage requestMsg) {
        String requestID = MajordomoRestPlugin.class.getSimpleName() + "#" + REQUEST_COUNTER.getAndIncrement();
        requestMsg.clientRequestID = requestID.getBytes(StandardCharsets.UTF_8);
        CustomFuture reply = new CustomFuture();
        CustomFuture<OpenCmwProtocol.MdpMessage> ret = this.requestReplies.put(requestID, (CustomFuture<OpenCmwProtocol.MdpMessage>)reply);
        if (ret != null) {
            LOGGER.atWarn().addArgument((Object)requestID).addArgument((Object)requestMsg.getServiceName()).log("duplicate request {} for service {}");
        }
        if (!this.requestQueue.offer((Object)requestMsg)) {
            throw new IllegalStateException("could not add MdpMessage to requestQueue: " + requestMsg);
        }
        BlockingArrayQueue<OpenCmwProtocol.MdpMessage> blockingArrayQueue = this.requestQueue;
        synchronized (blockingArrayQueue) {
            this.requestQueue.notifyAll();
        }
        return reply;
    }

    protected void notifySubscribedClients(@NotNull URI topic) {
        String topicString = topic.toString();
        String notifyPath = RestServer.prefixPath(topic.getPath());
        Queue<SseClient> clients = RestServer.getEventClients(notifyPath);
        Predicate<SseClient> filter = c -> {
            String clientPath = StringUtils.stripEnd((String)c.ctx.path(), (String)"/");
            return clientPath.length() >= notifyPath.length() && clientPath.startsWith(notifyPath);
        };
        clients.stream().filter(filter).forEach(s -> s.sendEvent(topicString));
    }

    private Handler getDefaultServiceRestHandler(String restHandler) {
        return new CombinedHandler(restCtx -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().addArgument((Object)restHandler).addArgument((Object)restCtx.path()).addArgument((Object)restCtx.fullUrl()).log("restHandler {} for service {} - full: {}");
            }
            String service = StringUtils.stripStart((String)Objects.requireNonNullElse(restCtx.path(), restHandler), (String)"/");
            MimeType acceptMimeType = MimeType.getEnum((String)restCtx.header("accept"));
            Map parameterMap = restCtx.req.getParameterMap();
            String[] mimeType = (String[])parameterMap.get("contentType");
            URI topic = mimeType == null || mimeType.length == 0 ? RestServer.appendUri(URI.create(restCtx.fullUrl()), "contentType=" + acceptMimeType.toString()) : URI.create(restCtx.fullUrl());
            OpenCmwProtocol.Command cmd = MajordomoRestPlugin.getCommand(restCtx);
            byte[] requestData = cmd == OpenCmwProtocol.Command.SET_REQUEST ? this.getFormDataAsJson(restCtx) : OpenCmwProtocol.EMPTY_FRAME;
            OpenCmwProtocol.MdpMessage requestMsg = new OpenCmwProtocol.MdpMessage(null, OpenCmwProtocol.MdpSubProtocol.PROT_CLIENT, cmd, service.getBytes(StandardCharsets.UTF_8), OpenCmwProtocol.EMPTY_FRAME, topic, requestData, "", RBAC);
            CustomFuture<OpenCmwProtocol.MdpMessage> reply = this.dispatchRequest(requestMsg);
            try {
                OpenCmwProtocol.MdpMessage replyMessage = (OpenCmwProtocol.MdpMessage)reply.get();
                MimeType replyMimeType = QueryParameterParser.getMimeType((String)replyMessage.topic.getQuery());
                replyMimeType = replyMimeType == MimeType.UNKNOWN ? acceptMimeType : replyMimeType;
                switch (replyMimeType) {
                    case HTML: {
                        String queryString;
                        String string = queryString = topic.getQuery() == null ? "" : "?" + topic.getQuery();
                        if (cmd == OpenCmwProtocol.Command.SET_REQUEST) {
                            String path = replyMessage.topic.getPath() + StringUtils.replace((String)queryString, (String)"&noMenu", (String)"");
                            restCtx.redirect(path);
                            break;
                        }
                        boolean noMenu = queryString.contains("noMenu");
                        Map<String, Object> dataMap = MessageBundle.baseModel(restCtx);
                        dataMap.put(TAG_MENU_ITEMS, this.menuMap);
                        dataMap.put("textBody", new String(replyMessage.data, StandardCharsets.UTF_8));
                        dataMap.put("noMenu", noMenu);
                        restCtx.render(TEMPLATE_EMBEDDED_HTML, dataMap);
                        break;
                    }
                    case TEXT: {
                        restCtx.contentType(replyMimeType.toString());
                        restCtx.result(new String(replyMessage.data, StandardCharsets.UTF_8));
                        break;
                    }
                    default: {
                        restCtx.contentType(replyMimeType.toString());
                        restCtx.result(replyMessage.data);
                        break;
                    }
                }
            }
            catch (Exception e) {
                switch (acceptMimeType) {
                    case HTML: 
                    case TEXT: {
                        Map<String, Object> dataMap = MessageBundle.baseModel(restCtx);
                        dataMap.put(TAG_MENU_ITEMS, this.menuMap);
                        dataMap.put("service", restHandler);
                        dataMap.put("exceptionText", e);
                        restCtx.render(TEMPLATE_BAD_REQUEST, dataMap);
                        return;
                    }
                }
                throw new BadRequestResponse(MajordomoRestPlugin.class.getName() + ": could not process service '" + service + "' - exception:\n" + e.getMessage());
            }
        }, this.newSseClientHandler);
    }

    private byte[] getFormDataAsJson(Context restCtx) {
        Map formMap = restCtx.formParamMap();
        HashMap requestMap = new HashMap();
        formMap.forEach((k, v) -> {
            if (v.isEmpty()) {
                requestMap.put(k, null);
            } else {
                requestMap.put(k, v.get(0));
            }
        });
        if (restCtx.isMultipartFormData()) {
            requestMap.remove("files");
            restCtx.uploadedFiles("files").forEach(file -> {
                block2: {
                    try {
                        byte[] rawData = ByteStreams.toByteArray((InputStream)file.getContent());
                        requestMap.put("resourceName", file.getFilename());
                        requestMap.put("contentType", file.getContentType());
                        requestMap.put("data", Base64.getEncoder().encodeToString(rawData));
                        requestMap.put("dataSize", rawData.length);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) break block2;
                        LOGGER.atWarn().setCause((Throwable)e).log("could not parse uploaded file");
                    }
                }
            });
        }
        return JsonStream.serialize(requestMap).getBytes(StandardCharsets.UTF_8);
    }

    static {
        try {
            Base64Support.enable();
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
    }
}

