/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.utils;

import io.opencmw.serialiser.spi.ClassFieldDescription;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_ARRAY_BOXED_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> BOXED_ARRAY_PRIMITIVE_MAP = new HashMap();
    public static final Map<Class<?>, String> DO_NOT_PARSE_MAP = new HashMap();
    private static final Map<Integer, ClassFieldDescription> CLASS_FIELD_DESCRIPTION_MAP = new ConcurrentHashMap<Integer, ClassFieldDescription>();
    private static final Map<String, Class<?>> CLASS_STRING_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> CLASS_METHOD_MAP = new ConcurrentHashMap();
    private static int indentationNumberOfSpace = 4;
    private static int maxRecursionDepth = 10;

    private ClassUtils() {
    }

    public static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static Class<?> getClassByName(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)name).log("exception while getting class {}");
                return null;
            }
        });
    }

    public static Class<?> getClassByNameNonVerboseError(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                return Object.class;
            }
        });
    }

    public static Map<Integer, ClassFieldDescription> getClassDescriptions() {
        return CLASS_FIELD_DESCRIPTION_MAP;
    }

    public static ClassFieldDescription getFieldDescription(Class<?> clazz, Class<?> ... classArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        return CLASS_FIELD_DESCRIPTION_MAP.computeIfAbsent(ClassUtils.computeHashCode(clazz, classArguments), key -> new ClassFieldDescription(clazz, false));
    }

    public static int getIndentationNumberOfSpace() {
        return indentationNumberOfSpace;
    }

    public static Collection<ClassFieldDescription> getKnownClasses() {
        return CLASS_FIELD_DESCRIPTION_MAP.values();
    }

    public static Map<Class<?>, Map<String, Method>> getKnownMethods() {
        return CLASS_METHOD_MAP;
    }

    public static int getMaxRecursionDepth() {
        return maxRecursionDepth;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return CLASS_METHOD_MAP.computeIfAbsent(clazz, c -> new ConcurrentHashMap()).computeIfAbsent(methodName, name -> {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            ClassUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(ClassUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return ClassUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Type[] getSecondaryType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static boolean isBoxedArray(Class<?> type) {
        return BOXED_ARRAY_PRIMITIVE_MAP.containsKey(type);
    }

    public static boolean isPrimitiveArray(Class<?> type) {
        return PRIMITIVE_ARRAY_BOXED_MAP.containsKey(type);
    }

    public static boolean isPrimitiveOrString(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || String.class.isAssignableFrom(type);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || ClassUtils.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return WRAPPER_PRIMITIVE_MAP.containsKey(type);
    }

    public static boolean isPrimitiveWrapperOrString(Class<?> type) {
        if (type == null) {
            return false;
        }
        return WRAPPER_PRIMITIVE_MAP.containsKey(type) || String.class.isAssignableFrom(type);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    public static void setIndentationNumberOfSpace(int indentationNumberOfSpace) {
        ClassUtils.indentationNumberOfSpace = indentationNumberOfSpace;
    }

    public static void setMaxRecursionDepth(int maxRecursionDepth) {
        ClassUtils.maxRecursionDepth = maxRecursionDepth;
    }

    public static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }

    public static String translateClassName(String name) {
        if (name.startsWith("[Z")) {
            return boolean[].class.getName();
        }
        if (name.startsWith("[B")) {
            return byte[].class.getName();
        }
        if (name.startsWith("[S")) {
            return short[].class.getName();
        }
        if (name.startsWith("[I")) {
            return int[].class.getName();
        }
        if (name.startsWith("[J")) {
            return long[].class.getName();
        }
        if (name.startsWith("[F")) {
            return float[].class.getName();
        }
        if (name.startsWith("[D")) {
            return double[].class.getName();
        }
        if (name.startsWith("[L")) {
            return name.substring(2, name.length() - 1) + "[]";
        }
        return name;
    }

    private static void add(Map<Class<?>, Class<?>> map1, Map<Class<?>, Class<?>> map2, Class<?> obj1, Class<?> obj2) {
        map1.put(obj1, obj2);
        map2.put(obj2, obj1);
    }

    private static int computeHashCode(Class<?> classPrototype, Class<?> ... classArguments) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (classPrototype == null ? 0 : classPrototype.getName().hashCode());
        if (classArguments == null || classArguments.length <= 0) {
            return result;
        }
        for (Class<?> clazz : classArguments) {
            result = 31 * result + clazz.hashCode();
        }
        return result;
    }

    static {
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Boolean.class, Boolean.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Byte.class, Byte.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Character.class, Character.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Short.class, Short.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Integer.class, Integer.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Long.class, Long.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Float.class, Float.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Double.class, Double.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, Void.class, Void.TYPE);
        ClassUtils.add(WRAPPER_PRIMITIVE_MAP, PRIMITIVE_WRAPPER_MAP, String.class, String.class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, boolean[].class, Boolean[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, byte[].class, Byte[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, char[].class, Character[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, short[].class, Short[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, int[].class, Integer[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, long[].class, Long[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, float[].class, Float[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, double[].class, Double[].class);
        ClassUtils.add(PRIMITIVE_ARRAY_BOXED_MAP, BOXED_ARRAY_PRIMITIVE_MAP, String[].class, String[].class);
        DO_NOT_PARSE_MAP.put(Class.class, "private java implementation");
        DO_NOT_PARSE_MAP.put(Thread.class, "recursive definitions");
        DO_NOT_PARSE_MAP.put(AtomicBoolean.class, "does not like to be parsed");
    }
}

