/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.spi.iobuffer;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.spi.utils.MultiArrayBoolean;
import de.gsi.dataset.spi.utils.MultiArrayByte;
import de.gsi.dataset.spi.utils.MultiArrayChar;
import de.gsi.dataset.spi.utils.MultiArrayDouble;
import de.gsi.dataset.spi.utils.MultiArrayFloat;
import de.gsi.dataset.spi.utils.MultiArrayInt;
import de.gsi.dataset.spi.utils.MultiArrayLong;
import de.gsi.dataset.spi.utils.MultiArrayObject;
import de.gsi.dataset.spi.utils.MultiArrayShort;
import io.opencmw.serialiser.DataType;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.FieldSerialiser;
import io.opencmw.serialiser.IoClassSerialiser;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.spi.WireDataFieldDescription;

public final class FieldMultiArrayHelper {
    private FieldMultiArrayHelper() {
    }

    public static <E> MultiArray<E> getMultiArray(IoSerialiser serialiser, MultiArray<E> dst, DataType type) {
        int[] dims = serialiser.getArraySizeDescriptor();
        int n = 1;
        for (int ni : dims) {
            n *= ni;
        }
        switch (type) {
            case BOOL_ARRAY: {
                return MultiArrayBoolean.wrap((boolean[])serialiser.getBuffer().getBooleanArray(dst == null ? null : (boolean[])dst.elements(), n), (int[])dims);
            }
            case BYTE_ARRAY: {
                return MultiArrayByte.wrap((byte[])serialiser.getBuffer().getByteArray(dst == null ? null : (byte[])dst.elements(), n), (int[])dims);
            }
            case SHORT_ARRAY: {
                return MultiArrayShort.wrap((short[])serialiser.getBuffer().getShortArray(dst == null ? null : (short[])dst.elements(), n), (int[])dims);
            }
            case INT_ARRAY: {
                return MultiArrayInt.wrap((int[])serialiser.getBuffer().getIntArray(dst == null ? null : (int[])dst.elements(), n), (int[])dims);
            }
            case LONG_ARRAY: {
                return MultiArrayLong.wrap((long[])serialiser.getBuffer().getLongArray(dst == null ? null : (long[])dst.elements(), n), (int[])dims);
            }
            case FLOAT_ARRAY: {
                return MultiArrayFloat.wrap((float[])serialiser.getBuffer().getFloatArray(dst == null ? null : (float[])dst.elements(), n), (int[])dims);
            }
            case DOUBLE_ARRAY: {
                return MultiArrayDouble.wrap((double[])serialiser.getBuffer().getDoubleArray(dst == null ? null : (double[])dst.elements(), n), (int[])dims);
            }
            case CHAR_ARRAY: {
                return MultiArrayChar.wrap((char[])serialiser.getBuffer().getCharArray(dst == null ? null : (char[])dst.elements(), n), (int[])dims);
            }
            case STRING_ARRAY: {
                return MultiArrayObject.wrap((Object[])serialiser.getBuffer().getStringArray(dst == null ? null : (String[])dst.elements(), n), (int[])dims);
            }
        }
        throw new IllegalStateException("Unexpected value: " + type);
    }

    public static <E> void put(IoSerialiser serialiser, String fieldName, MultiArray<E> value) {
        if (value instanceof MultiArrayDouble) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.DOUBLE_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putDoubleArray((double[])((MultiArrayDouble)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayFloat) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.FLOAT_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putFloatArray((float[])((MultiArrayFloat)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayInt) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.INT_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putIntArray((int[])((MultiArrayInt)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayLong) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.LONG_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putLongArray((long[])((MultiArrayLong)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayShort) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.SHORT_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putShortArray((short[])((MultiArrayShort)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayChar) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.CHAR_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putCharArray((char[])((MultiArrayChar)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayByte) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.BYTE_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putByteArray((byte[])((MultiArrayByte)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else if (value instanceof MultiArrayObject) {
            WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldName, DataType.STRING_ARRAY);
            int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
            serialiser.getBuffer().putStringArray((String[])((MultiArrayObject)value).elements(), nElements);
            serialiser.updateDataEndMarker(fieldHeader);
        } else {
            throw new IllegalArgumentException("Illegal DataType for MultiArray");
        }
    }

    public static <E> void put(IoSerialiser serialiser, FieldDescription fieldDescription, MultiArray<E> value) {
        WireDataFieldDescription fieldHeader = serialiser.putFieldHeader(fieldDescription);
        int nElements = serialiser.putArraySizeDescriptor(value.getDimensions());
        switch (fieldDescription.getDataType()) {
            case BOOL_ARRAY: {
                serialiser.getBuffer().putBooleanArray((boolean[])((MultiArrayBoolean)value).elements(), nElements);
                break;
            }
            case BYTE_ARRAY: {
                serialiser.getBuffer().putByteArray((byte[])((MultiArrayByte)value).elements(), nElements);
                break;
            }
            case SHORT_ARRAY: {
                serialiser.getBuffer().putShortArray((short[])((MultiArrayShort)value).elements(), nElements);
                break;
            }
            case INT_ARRAY: {
                serialiser.getBuffer().putIntArray((int[])((MultiArrayInt)value).elements(), nElements);
                break;
            }
            case LONG_ARRAY: {
                serialiser.getBuffer().putLongArray((long[])((MultiArrayLong)value).elements(), nElements);
                break;
            }
            case FLOAT_ARRAY: {
                serialiser.getBuffer().putFloatArray((float[])((MultiArrayFloat)value).elements(), nElements);
                break;
            }
            case DOUBLE_ARRAY: {
                serialiser.getBuffer().putDoubleArray((double[])((MultiArrayDouble)value).elements(), nElements);
                break;
            }
            case CHAR_ARRAY: {
                serialiser.getBuffer().putCharArray((char[])((MultiArrayChar)value).elements(), nElements);
                break;
            }
            case STRING_ARRAY: {
                serialiser.getBuffer().putStringArray((String[])((MultiArrayObject)value).elements(), nElements);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + fieldDescription.getDataType());
            }
        }
        serialiser.updateDataEndMarker(fieldHeader);
    }

    public static void register(IoClassSerialiser serialiser) {
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.DOUBLE_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayDouble.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.FLOAT_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayFloat.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.INT_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayInt.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.LONG_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayLong.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.SHORT_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayShort.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.BYTE_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayByte.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.CHAR_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayChar.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.BOOL_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayBoolean.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<MultiArray>((io, obj, field) -> field.getField().set(obj, FieldMultiArrayHelper.getMultiArray(io, (MultiArray)field.getField().get(obj), field.getDataType())), (io, obj, field) -> FieldMultiArrayHelper.getMultiArray(io, (MultiArray)(field == null ? obj : field.getField().get(obj)), DataType.STRING_ARRAY), (io, obj, field) -> FieldMultiArrayHelper.put(io, field, (MultiArray)field.getField().get(obj)), MultiArrayObject.class, new Class[0]));
    }
}

