/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.spi.iobuffer;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.spi.DefaultAxisDescription;
import io.opencmw.serialiser.FieldSerialiser;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import java.util.ArrayList;
import java.util.List;

public class FieldListAxisDescription
extends FieldSerialiser<List<AxisDescription>> {
    public FieldListAxisDescription() {
        super((io, obj, field) -> {}, (io, obj, field) -> null, (io, obj, field) -> {}, List.class, AxisDescription.class);
        this.readerFunction = this::execFieldReader;
        this.returnFunction = this::execFieldReturn;
        this.writerFunction = this::execFieldWriter;
    }

    protected void execFieldReader(IoSerialiser ioSerialiser, Object obj, ClassFieldDescription field) {
        field.getField().set(obj, this.execFieldReturn(ioSerialiser, obj, field));
    }

    protected List<AxisDescription> execFieldReturn(IoSerialiser ioSerialiser, Object obj, ClassFieldDescription field) {
        List<AxisDescription> setVal;
        Object oldObject = field == null ? null : field.getField().get(obj);
        boolean isListPresent = oldObject instanceof List;
        int nElements = ioSerialiser.getBuffer().getInt();
        List list = setVal = isListPresent ? (List)field.getField().get(obj) : new ArrayList(nElements);
        if (isListPresent) {
            setVal.clear();
        }
        for (int i = 0; i < nElements; ++i) {
            String axisName = ioSerialiser.getBuffer().getString();
            String axisUnit = ioSerialiser.getBuffer().getString();
            double min = ioSerialiser.getBuffer().getDouble();
            double max = ioSerialiser.getBuffer().getDouble();
            DefaultAxisDescription ad = new DefaultAxisDescription(i, axisName, axisUnit, min, max);
            setVal.add((AxisDescription)ad);
        }
        return setVal;
    }

    protected void execFieldWriter(IoSerialiser ioSerialiser, Object obj, ClassFieldDescription field) {
        List axisDescriptions = (List)field.getField().get(obj);
        int nElements = axisDescriptions.size();
        int entrySize = 50;
        ioSerialiser.getBuffer().ensureAdditionalCapacity(nElements * 50 + 9);
        ioSerialiser.getBuffer().putInt(nElements);
        for (AxisDescription axis : axisDescriptions) {
            ioSerialiser.getBuffer().putString(axis.getName());
            ioSerialiser.getBuffer().putString(axis.getUnit());
            ioSerialiser.getBuffer().putDouble(axis.getMin());
            ioSerialiser.getBuffer().putDouble(axis.getMax());
        }
    }
}

