/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.spi;

import io.opencmw.serialiser.DataType;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.utils.ClassUtils;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireDataFieldDescription
implements FieldDescription {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireDataFieldDescription.class);
    private final String fieldName;
    private final int fieldNameHashCode;
    private final DataType dataType;
    private final List<FieldDescription> children = new ArrayList<FieldDescription>();
    private final FieldDescription parent;
    private final int fieldStart;
    private final int fieldDataStart;
    private final int dataStartOffset;
    private final IoSerialiser ioSerialiser;
    private String fieldUnit;
    private String fieldDescription;
    private String fieldDirection;
    private List<String> fieldGroups;
    private int dataSize;

    public WireDataFieldDescription(IoSerialiser source, FieldDescription parent, int fieldNameHashCode, String fieldName, DataType dataType, int fieldStart, int dataStartOffset, int dataSize) {
        this.ioSerialiser = source;
        this.parent = parent;
        this.fieldNameHashCode = fieldNameHashCode;
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.fieldStart = fieldStart;
        this.dataStartOffset = dataStartOffset;
        this.dataSize = dataSize;
        this.fieldDataStart = fieldStart + dataStartOffset;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldDescription)) {
            return false;
        }
        FieldDescription other = (FieldDescription)obj;
        if (this.getFieldNameHashCode() != other.getFieldNameHashCode()) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        return this.getFieldName().equals(other.getFieldName());
    }

    @Override
    public FieldDescription findChildField(String fieldName) {
        return this.findChildField(fieldName.hashCode(), fieldName);
    }

    @Override
    public FieldDescription findChildField(int fieldNameHashCode, String fieldName) {
        for (FieldDescription field : this.children) {
            String name = field.getFieldName();
            if (name == fieldName) {
                return field;
            }
            if (field.hashCode() != fieldNameHashCode || !name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<FieldDescription> getChildren() {
        return this.children;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int size) {
        this.dataSize = size;
    }

    @Override
    public int getDataStartOffset() {
        return this.dataStartOffset;
    }

    @Override
    public int getDataStartPosition() {
        return this.fieldDataStart;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public void setFieldDescription(String fieldDescription) {
        this.fieldDescription = fieldDescription;
    }

    @Override
    public String getFieldDirection() {
        return this.fieldDirection;
    }

    public void setFieldDirection(String fieldDirection) {
        this.fieldDirection = fieldDirection;
    }

    @Override
    public List<String> getFieldGroups() {
        return this.fieldGroups;
    }

    public void setFieldGroups(List<String> fieldGroups) {
        this.fieldGroups = fieldGroups;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getFieldNameHashCode() {
        return this.fieldNameHashCode;
    }

    @Override
    public int getFieldStart() {
        return this.fieldStart;
    }

    @Override
    public String getFieldUnit() {
        return this.fieldUnit;
    }

    public void setFieldUnit(String fieldUnit) {
        this.fieldUnit = fieldUnit;
    }

    public Object data(DataType ... overwriteType) {
        this.ioSerialiser.setQueryFieldName(this.fieldName, this.fieldDataStart);
        switch (overwriteType.length == 0 ? this.dataType : overwriteType[0]) {
            case START_MARKER: 
            case END_MARKER: {
                return null;
            }
            case BOOL: {
                return this.ioSerialiser.getBoolean();
            }
            case BYTE: {
                return this.ioSerialiser.getByte();
            }
            case SHORT: {
                return this.ioSerialiser.getShort();
            }
            case INT: {
                return this.ioSerialiser.getInt();
            }
            case LONG: {
                return this.ioSerialiser.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.ioSerialiser.getFloat());
            }
            case DOUBLE: {
                return this.ioSerialiser.getDouble();
            }
            case CHAR: {
                return Character.valueOf(this.ioSerialiser.getChar());
            }
            case STRING: {
                return this.ioSerialiser.getString();
            }
            case BOOL_ARRAY: {
                return this.ioSerialiser.getBooleanArray();
            }
            case BYTE_ARRAY: {
                return this.ioSerialiser.getByteArray();
            }
            case SHORT_ARRAY: {
                return this.ioSerialiser.getShortArray();
            }
            case INT_ARRAY: {
                return this.ioSerialiser.getIntArray();
            }
            case LONG_ARRAY: {
                return this.ioSerialiser.getLongArray();
            }
            case FLOAT_ARRAY: {
                return this.ioSerialiser.getFloatArray();
            }
            case DOUBLE_ARRAY: {
                return this.ioSerialiser.getDoubleArray();
            }
            case CHAR_ARRAY: {
                return this.ioSerialiser.getCharArray();
            }
            case STRING_ARRAY: {
                return this.ioSerialiser.getStringArray();
            }
            case ENUM: {
                return this.ioSerialiser.getEnum(null);
            }
            case LIST: {
                return this.ioSerialiser.getList(null);
            }
            case MAP: {
                return this.ioSerialiser.getMap(null);
            }
            case QUEUE: {
                return this.ioSerialiser.getQueue(null);
            }
            case SET: {
                return this.ioSerialiser.getSet(null);
            }
            case COLLECTION: {
                return this.ioSerialiser.getCollection(null);
            }
            case OTHER: {
                return this.ioSerialiser.getCustomData(null);
            }
        }
        throw new IllegalStateException("unknown dataType = " + this.dataType);
    }

    public IoSerialiser getIoSerialiser() {
        return this.ioSerialiser;
    }

    @Override
    public FieldDescription getParent() {
        return this.parent;
    }

    @Override
    public Class<?> getType() {
        return this.dataType.getClassTypes().get(0);
    }

    public int hashCode() {
        return this.fieldNameHashCode;
    }

    @Override
    public boolean isAnnotationPresent() {
        return this.fieldUnit != null || this.fieldDescription != null || this.fieldDirection != null || this.fieldGroups != null && !this.fieldGroups.isEmpty();
    }

    @Override
    public void printFieldStructure() {
        if (this.parent == null) {
            LOGGER.atInfo().log("FielHeader structure (no parent):");
        } else {
            LOGGER.atInfo().addArgument((Object)this.parent).log("FielHeader structure (parent: {}):");
            WireDataFieldDescription.printFieldStructure(this, 0);
        }
        WireDataFieldDescription.printFieldStructure(this, 0);
    }

    public String toString() {
        return String.format("[fieldName=%s, fieldType=%s]", this.fieldName, this.dataType.getAsString());
    }

    protected static void printFieldStructure(FieldDescription field, int recursionLevel) {
        String mspace = WireDataFieldDescription.spaces(recursionLevel * ClassUtils.getIndentationNumberOfSpace());
        LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)field.toString()).log("{}{}");
        if (field.isAnnotationPresent()) {
            LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)field.getFieldUnit()).addArgument((Object)field.getFieldDescription()).addArgument((Object)field.getFieldDirection()).addArgument(field.getFieldGroups()).log("{}     <meta-info: unit:'{}' description:'{}' direction:'{}' groups:'{}'>");
        }
        field.getChildren().forEach(f -> WireDataFieldDescription.printFieldStructure(f, recursionLevel + 1));
    }

    private static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }
}

