/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.spi;

import io.opencmw.serialiser.IoBuffer;
import io.opencmw.serialiser.utils.AssertUtils;
import io.opencmw.serialiser.utils.ByteArrayCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Unsafe;

public class FastByteBuffer
implements IoBuffer {
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final String INVALID_UTF_8 = "Invalid UTF-8";
    private static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final int DEFAULT_MIN_CAPACITY_INCREASE = 1024;
    private static final int DEFAULT_MAX_CAPACITY_INCREASE = 102400;
    private static final Unsafe unsafe;
    private final ReadWriteLock internalLock = new ReentrantReadWriteLock();
    private final StringBuilder builder = new StringBuilder(100);
    private ByteArrayCache byteArrayCache;
    private int intPos;
    private int intLimit;
    private byte[] buffer;
    private boolean enforceSimpleStringEncoding;
    private boolean autoResize;

    public FastByteBuffer() {
        this(1024);
    }

    public FastByteBuffer(byte[] buffer, int limit) {
        Objects.requireNonNull(buffer, "buffer");
        if (buffer.length < limit) {
            throw new IllegalArgumentException(String.format("limit %d >= capacity %d", limit, buffer.length));
        }
        this.buffer = buffer;
        this.intLimit = limit;
        this.intPos = 0;
    }

    public FastByteBuffer(int size) {
        this(size, false, null);
    }

    public FastByteBuffer(int size, boolean autoResize, ByteArrayCache byteArrayCache) {
        AssertUtils.gtEqThanZero("size", size);
        this.buffer = new byte[size];
        this.intPos = 0;
        this.intLimit = this.buffer.length;
        this.autoResize = autoResize;
        this.byteArrayCache = byteArrayCache;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void checkAvailable(int bytes) {
        if (this.intPos + bytes > this.intLimit) {
            throw new IndexOutOfBoundsException("read unavailable " + bytes + " bytes at position " + this.intPos + " (limit: " + this.intLimit + ")");
        }
    }

    public void checkAvailableAbsolute(int position) {
        if (position > this.intLimit) {
            throw new IndexOutOfBoundsException("read unavailable bytes at end position " + position + " (limit: " + this.intLimit + ")");
        }
    }

    @Override
    public void clear() {
        this.intPos = 0;
        this.intLimit = this.capacity();
    }

    @Override
    public byte[] elements() {
        return this.buffer;
    }

    @Override
    public void ensureAdditionalCapacity(int capacity) {
        this.ensureCapacity(this.position() + capacity);
    }

    @Override
    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.capacity()) {
            return;
        }
        if (this.intPos > this.capacity()) {
            throw new IllegalStateException("position " + this.intPos + " is beyond buffer capacity " + this.capacity());
        }
        if (!this.autoResize) {
            throw new IndexOutOfBoundsException("required capacity: " + newCapacity + " out of bounds: " + this.capacity() + "and autoResize is disabled");
        }
        int addCapacity = Math.min(Math.max(1024, newCapacity >> 3), 102400);
        this.forceCapacity(newCapacity + addCapacity, this.limit());
    }

    @Override
    public void flip() {
        this.intLimit = this.intPos;
        this.intPos = 0;
    }

    @Override
    public void forceCapacity(int length, int preserve) {
        if (length == this.capacity()) {
            this.intLimit = length;
            return;
        }
        byte[] newBuffer = this.byteArrayCache == null ? new byte[length] : this.byteArrayCache.getArray(length);
        int bytesToCopy = preserve * 1;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.intPos = Math.min(this.intPos, newBuffer.length);
        if (this.byteArrayCache != null) {
            this.byteArrayCache.add(this.buffer);
        }
        this.buffer = newBuffer;
        this.intLimit = this.buffer.length;
    }

    @Override
    public boolean getBoolean() {
        this.checkAvailable(1);
        boolean value = unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        ++this.intPos;
        return value;
    }

    @Override
    public boolean getBoolean(int position) {
        this.checkAvailableAbsolute(position + 1);
        return unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        boolean[] values = initNeeded ? new boolean[arraySize] : dst;
        this.checkAvailable(arraySize * 1);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, arraySize);
        this.intPos += arraySize;
        return values;
    }

    @Override
    public byte getByte() {
        this.checkAvailable(1);
        byte value = unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        ++this.intPos;
        return value;
    }

    @Override
    public byte getByte(int position) {
        this.checkAvailableAbsolute(position + 1);
        return unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        byte[] values = initNeeded ? new byte[arraySize] : dst;
        this.checkAvailable(arraySize);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_BYTE_BASE_OFFSET, arraySize);
        this.intPos += arraySize;
        return values;
    }

    public ByteArrayCache getByteArrayCache() {
        return this.byteArrayCache;
    }

    @Override
    public char getChar() {
        this.checkAvailable(2);
        char value = unsafe.getChar(this.buffer, (long)Unsafe.ARRAY_CHAR_BASE_OFFSET + (long)this.intPos);
        this.intPos += 2;
        return value;
    }

    @Override
    public char getChar(int position) {
        this.checkAvailableAbsolute(position + 2);
        return unsafe.getChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        char[] values = initNeeded ? new char[arraySize] : dst;
        int bytesToCopy = arraySize * 2;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_SHORT_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public double getDouble() {
        this.checkAvailable(8);
        double value = unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        this.intPos += 8;
        return value;
    }

    @Override
    public double getDouble(int position) {
        this.checkAvailableAbsolute(position + 8);
        return unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        double[] values = initNeeded ? new double[arraySize] : dst;
        int bytesToCopy = arraySize * 8;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public float getFloat() {
        this.checkAvailable(4);
        float value = unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        this.intPos += 4;
        return value;
    }

    @Override
    public float getFloat(int position) {
        this.checkAvailableAbsolute(position + 4);
        return unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        float[] values = initNeeded ? new float[arraySize] : dst;
        int bytesToCopy = arraySize * 4;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_FLOAT_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public int getInt() {
        this.checkAvailable(4);
        int value = unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        this.intPos += 4;
        return value;
    }

    @Override
    public int getInt(int position) {
        this.checkAvailableAbsolute(position + 4);
        return unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        int[] values = initNeeded ? new int[arraySize] : dst;
        int bytesToCopy = arraySize * 4;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_INT_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public long getLong() {
        this.checkAvailable(8);
        long value = unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        this.intPos += 8;
        return value;
    }

    @Override
    public long getLong(int position) {
        this.checkAvailableAbsolute(position + 8);
        return unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        long[] values = initNeeded ? new long[arraySize] : dst;
        int bytesToCopy = arraySize * 8;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_LONG_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public short getShort() {
        this.checkAvailable(2);
        short value = unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos);
        this.intPos += 2;
        return value;
    }

    @Override
    public short getShort(int position) {
        this.checkAvailableAbsolute(position + 2);
        return unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        short[] values = initNeeded ? new short[arraySize] : dst;
        int bytesToCopy = arraySize * 2;
        this.checkAvailable(bytesToCopy);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, values, Unsafe.ARRAY_SHORT_BASE_OFFSET, bytesToCopy);
        this.intPos += bytesToCopy;
        return values;
    }

    @Override
    public String getString() {
        if (this.isEnforceSimpleStringEncoding()) {
            return this.getStringISO8859();
        }
        int arraySize = this.getInt();
        this.checkAvailable(arraySize);
        FastByteBuffer.decodeUTF8(this.buffer, this.intPos, arraySize - 1, this.builder);
        this.intPos += arraySize;
        return this.builder.toString();
    }

    @Override
    public String getString(int position) {
        int oldPosition = this.position();
        this.position(position);
        String ret = this.getString();
        this.position(oldPosition);
        return ret;
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        int arraySize = this.getInt();
        this.checkAvailable(arraySize);
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        String[] ret = initNeeded ? new String[arraySize] : dst;
        for (int k = 0; k < arraySize; ++k) {
            ret[k] = this.getString();
        }
        return ret;
    }

    @Override
    public String getStringISO8859() {
        int arraySize = this.getInt();
        this.checkAvailable(arraySize);
        String str = new String(this.buffer, 0, this.intPos, arraySize - 1);
        this.intPos += arraySize;
        return str;
    }

    @Override
    public boolean hasRemaining() {
        return this.position() < this.limit();
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    @Override
    public boolean isEnforceSimpleStringEncoding() {
        return this.enforceSimpleStringEncoding;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int limit() {
        return this.intLimit;
    }

    @Override
    public void limit(int newLimit) {
        if (newLimit > this.capacity() || newLimit < 0) {
            throw new IllegalArgumentException(String.format("invalid newLimit: [0, position: %d, newLimit:%d, %d]", this.intPos, newLimit, this.capacity()));
        }
        this.intLimit = newLimit;
        if (this.intPos > this.intLimit) {
            this.intPos = this.intLimit;
        }
    }

    @Override
    public ReadWriteLock lock() {
        return this.internalLock;
    }

    @Override
    public int position() {
        return this.intPos;
    }

    @Override
    public void position(int newPosition) {
        if (newPosition > this.intLimit || newPosition < 0 || newPosition > this.capacity()) {
            throw new IllegalArgumentException(String.format("invalid newPosition: %d vs. [0, position=%d, limit:%d, capacity:%d]", newPosition, this.intPos, this.intLimit, this.capacity()));
        }
        this.intPos = newPosition;
    }

    @Override
    public void putBoolean(boolean value) {
        this.ensureAdditionalCapacity(1);
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        ++this.intPos;
    }

    @Override
    public void putBoolean(int position, boolean value) {
        this.ensureCapacity(position + 1);
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putBooleanArray(boolean[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, nElements);
        this.intPos += nElements;
    }

    @Override
    public void putByte(byte value) {
        this.ensureAdditionalCapacity(1);
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        ++this.intPos;
    }

    @Override
    public void putByte(int position, byte value) {
        this.ensureCapacity(position + 1);
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putByteArray(byte[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.ensureAdditionalCapacity(nElements + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.intPos, nElements);
        this.intPos += nElements;
    }

    @Override
    public void putChar(char value) {
        this.ensureAdditionalCapacity(2);
        unsafe.putChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 2;
    }

    @Override
    public void putChar(int position, char value) {
        this.ensureCapacity(position + 2);
        unsafe.putChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putCharArray(char[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 2;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putDouble(double value) {
        this.ensureAdditionalCapacity(8);
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 8;
    }

    @Override
    public void putDouble(int position, double value) {
        this.ensureCapacity(position + 8);
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putDoubleArray(double[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_DOUBLE_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 8;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putFloat(float value) {
        this.ensureAdditionalCapacity(4);
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 4;
    }

    @Override
    public void putFloat(int position, float value) {
        this.ensureCapacity(position + 4);
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putFloatArray(float[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_FLOAT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 4;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putInt(int value) {
        this.ensureAdditionalCapacity(4);
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 4;
    }

    @Override
    public void putInt(int position, int value) {
        this.ensureCapacity(position + 4);
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putIntArray(int[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 4;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putLong(long value) {
        this.ensureAdditionalCapacity(8);
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 8;
    }

    @Override
    public void putLong(int position, long value) {
        this.ensureCapacity(position + 8);
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putLongArray(long[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_LONG_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 8;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putShort(short value) {
        this.ensureAdditionalCapacity(2);
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.intPos, value);
        this.intPos += 2;
    }

    @Override
    public void putShort(int position, short value) {
        this.ensureCapacity(position + 2);
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putShortArray(short[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 2;
        this.ensureAdditionalCapacity(bytesToCopy + 4);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.intPos, bytesToCopy);
        this.intPos += bytesToCopy;
    }

    @Override
    public void putString(String string) {
        if (string == null) {
            this.putString("");
            return;
        }
        if (this.isEnforceSimpleStringEncoding()) {
            this.putStringISO8859(string);
            return;
        }
        int utf16StringLength = string.length();
        int initialPos = this.intPos;
        this.intPos += 4;
        this.ensureAdditionalCapacity(3 * utf16StringLength + 4);
        int strLength = FastByteBuffer.encodeUTF8(string, this.buffer, this.intPos, 3 * utf16StringLength);
        int endPos = this.intPos + strLength;
        this.putInt(initialPos, strLength + 1);
        this.intPos = endPos;
        this.putByte((byte)0);
    }

    @Override
    public void putString(int position, String value) {
        int oldPosition = this.position();
        this.position(position);
        this.putString(value);
        this.position(oldPosition);
    }

    @Override
    public void putStringArray(String[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int originalPos = this.intPos;
        this.putInt(nElements);
        if (values == null) {
            return;
        }
        try {
            if (this.isEnforceSimpleStringEncoding()) {
                for (int k = 0; k < nElements; ++k) {
                    this.putStringISO8859(values[k]);
                }
                return;
            }
            for (int k = 0; k < nElements; ++k) {
                this.putString(values[k]);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.intPos = originalPos;
            throw e;
        }
    }

    @Override
    public void putStringISO8859(String string) {
        if (string == null) {
            this.putStringISO8859("");
            return;
        }
        int initialPos = this.intPos;
        this.intPos += 4;
        int strLength = FastByteBuffer.encodeISO8859(string, this.buffer, this.intPos, string.length());
        int endPos = this.intPos + strLength;
        this.intPos = initialPos;
        this.putInt(strLength + 1);
        this.intPos = endPos;
        this.putByte((byte)0);
    }

    @Override
    public int remaining() {
        return this.intLimit - this.intPos;
    }

    @Override
    public void reset() {
        this.intPos = 0;
        this.intLimit = this.buffer.length;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public void setByteArrayCache(ByteArrayCache byteArrayCache) {
        this.byteArrayCache = byteArrayCache;
    }

    @Override
    public void setEnforceSimpleStringEncoding(boolean state) {
        this.enforceSimpleStringEncoding = state;
    }

    public String toString() {
        return super.toString() + String.format(" - [0, position=%d, limit:%d, capacity:%d]", this.intPos, this.intLimit, this.capacity());
    }

    @Override
    public void trim() {
        this.trim(this.position());
    }

    @Override
    public void trim(int requestedCapacity) {
        if (requestedCapacity >= this.capacity() || this.position() > requestedCapacity) {
            return;
        }
        int bytesToCopy = Math.min(Math.max(requestedCapacity, this.position()), this.capacity()) * 1;
        byte[] newBuffer = this.byteArrayCache == null ? new byte[requestedCapacity] : this.byteArrayCache.getArrayExact(requestedCapacity);
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        if (this.byteArrayCache != null) {
            this.byteArrayCache.add(this.buffer);
        }
        this.buffer = newBuffer;
        this.intLimit = newBuffer.length;
    }

    public static FastByteBuffer wrap(byte[] byteArray) {
        return FastByteBuffer.wrap(byteArray, byteArray.length);
    }

    public static FastByteBuffer wrap(byte[] byteArray, int length) {
        return new FastByteBuffer(byteArray, length);
    }

    private static void copyMemory(Object srcBase, int srcOffset, Object destBase, int destOffset, int nBytes) {
        unsafe.copyMemory(srcBase, srcOffset, destBase, destOffset, nBytes);
    }

    private static void decodeUTF8(byte[] bytes, int offset, int size, StringBuilder result) {
        byte byte1;
        int remaining;
        if ((offset | size | bytes.length - offset - size) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, offset=%d, size=%d", bytes.length, offset, size));
        }
        result.setLength(size);
        long readPos = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset;
        int resultPos = 0;
        for (remaining = size; remaining > 0 && (byte1 = unsafe.getByte(bytes, readPos)) >= 0; --remaining) {
            ++readPos;
            result.setCharAt(resultPos++, (char)byte1);
        }
        while (remaining > 0) {
            byte byte3;
            byte byte2;
            byte1 = unsafe.getByte(bytes, readPos++);
            --remaining;
            if (byte1 >= 0) {
                byte b;
                result.setCharAt(resultPos++, (char)byte1);
                while (remaining > 0 && (b = unsafe.getByte(bytes, readPos)) >= 0) {
                    ++readPos;
                    --remaining;
                    result.setCharAt(resultPos++, (char)b);
                }
                continue;
            }
            if (byte1 < -32) {
                if (remaining < 1) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                byte2 = unsafe.getByte(bytes, readPos++);
                --remaining;
                int resultPos1 = resultPos++;
                if (byte1 < -62) {
                    throw new IllegalArgumentException("Invalid UTF-8: Illegal leading byte in 2 bytes UTF");
                }
                if (byte2 > -65) {
                    throw new IllegalArgumentException("Invalid UTF-8: Illegal trailing byte in 2 bytes UTF");
                }
                result.setCharAt(resultPos1, (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F));
                continue;
            }
            if (byte1 < -16) {
                if (remaining < 2) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                byte2 = unsafe.getByte(bytes, readPos++);
                byte3 = unsafe.getByte(bytes, readPos++);
                int resultPos1 = resultPos++;
                if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || byte3 > -65) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                result.setCharAt(resultPos1, (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F));
                remaining -= 2;
                continue;
            }
            if (remaining < 3) {
                throw new IllegalArgumentException(INVALID_UTF_8);
            }
            byte2 = unsafe.getByte(bytes, readPos++);
            byte3 = unsafe.getByte(bytes, readPos++);
            byte byte4 = unsafe.getByte(bytes, readPos++);
            int resultPos1 = resultPos++;
            if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || byte4 > -65) {
                throw new IllegalArgumentException(INVALID_UTF_8);
            }
            int codepoint = (byte1 & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            result.setCharAt(resultPos1, (char)(55232 + (codepoint >>> 10)));
            result.setCharAt(resultPos1 + 1, (char)(56320 + (codepoint & 0x3FF)));
            remaining -= 3;
            ++resultPos;
        }
        result.setLength(resultPos);
    }

    private static int encodeISO8859(String sequence, byte[] bytes, int offset, int length) {
        int base = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        for (int i = 0; i < length; ++i) {
            unsafe.putByte(bytes, (long)base + (long)i, (byte)(sequence.charAt(i) & 0xFF));
        }
        return length;
    }

    private static int encodeUTF8(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int base = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        int limit = base + length;
        for (i = 0; i < utf16Length && base + i < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            unsafe.putByte(bytes, (long)base + (long)i, (byte)c);
        }
        if (i == utf16Length) {
            return utf16Length;
        }
        base += i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && base < limit) {
                unsafe.putByte(bytes, base++, (byte)c);
            } else if (c < '\u0800' && base <= limit - 2) {
                unsafe.putByte(bytes, base++, (byte)(0x3C0 | c >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c));
            } else if ((c < '\ud800' || '\udfff' < c) && base <= limit - 3) {
                unsafe.putByte(bytes, base++, (byte)(0x1E0 | c >>> 12));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c));
            } else if (base <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                unsafe.putByte(bytes, base++, (byte)(0xF0 | codePoint >>> 18));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + base);
            }
            ++i;
        }
        return base - Unsafe.ARRAY_BYTE_BASE_OFFSET - offset;
    }

    static {
        try {
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            unsafe.putObjectVolatile(cls, unsafe.staticFieldOffset(logger), null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new SecurityException(e);
        }
    }
}

