/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser.spi;

import io.opencmw.serialiser.IoBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ByteBuffer
implements IoBuffer {
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_DOUBLE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private final ReadWriteLock internalLock = new ReentrantReadWriteLock();
    private final java.nio.ByteBuffer nioByteBuffer;
    private boolean enforceSimpleStringEncoding;

    public ByteBuffer() {
        this(1000);
    }

    public ByteBuffer(int nCapacity) {
        this.nioByteBuffer = java.nio.ByteBuffer.wrap(new byte[nCapacity]);
        this.nioByteBuffer.mark();
    }

    @Override
    public int capacity() {
        return this.nioByteBuffer.capacity();
    }

    @Override
    public void clear() {
        this.nioByteBuffer.clear();
    }

    @Override
    public byte[] elements() {
        return this.nioByteBuffer.array();
    }

    @Override
    public void ensureAdditionalCapacity(int capacity) {
    }

    @Override
    public void ensureCapacity(int capacity) {
    }

    @Override
    public void flip() {
        this.nioByteBuffer.flip();
    }

    @Override
    public void forceCapacity(int length, int preserve) {
    }

    @Override
    public boolean getBoolean() {
        return this.nioByteBuffer.get() > 0;
    }

    @Override
    public boolean getBoolean(int position) {
        return this.nioByteBuffer.get(position) > 0;
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        boolean[] ret = initNeeded ? new boolean[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getBoolean();
        }
        return ret;
    }

    @Override
    public byte getByte() {
        return this.nioByteBuffer.get();
    }

    @Override
    public byte getByte(int position) {
        return this.nioByteBuffer.get(position);
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        byte[] ret = initNeeded ? new byte[arraySize] : dst;
        this.nioByteBuffer.get(ret, 0, arraySize);
        return ret;
    }

    @Override
    public char getChar() {
        return this.nioByteBuffer.getChar();
    }

    @Override
    public char getChar(int position) {
        return this.nioByteBuffer.getChar(position);
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        char[] ret = initNeeded ? new char[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getChar();
        }
        return ret;
    }

    @Override
    public double getDouble() {
        return this.nioByteBuffer.getDouble();
    }

    @Override
    public double getDouble(int position) {
        return this.nioByteBuffer.getDouble(position);
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        double[] ret = initNeeded ? new double[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getDouble();
        }
        return ret;
    }

    @Override
    public float getFloat() {
        return this.nioByteBuffer.getFloat();
    }

    @Override
    public float getFloat(int position) {
        return this.nioByteBuffer.getFloat(position);
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        float[] ret = initNeeded ? new float[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getFloat();
        }
        return ret;
    }

    @Override
    public int getInt() {
        return this.nioByteBuffer.getInt();
    }

    @Override
    public int getInt(int position) {
        return this.nioByteBuffer.getInt(position);
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        int[] ret = initNeeded ? new int[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getInt();
        }
        return ret;
    }

    @Override
    public long getLong() {
        return this.nioByteBuffer.getLong();
    }

    @Override
    public long getLong(int position) {
        return this.nioByteBuffer.getLong(position);
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        long[] ret = initNeeded ? new long[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getLong();
        }
        return ret;
    }

    @Override
    public short getShort() {
        return this.nioByteBuffer.getShort();
    }

    @Override
    public short getShort(int position) {
        return this.nioByteBuffer.getShort(position);
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        short[] ret = initNeeded ? new short[arraySize] : dst;
        for (int i = 0; i < arraySize; ++i) {
            ret[i] = this.getShort();
        }
        return ret;
    }

    @Override
    public String getString() {
        int arraySize = this.getInt() - 1;
        byte[] values = new byte[arraySize];
        this.nioByteBuffer.get(values, 0, arraySize);
        this.getByte();
        return new String(values, 0, arraySize, StandardCharsets.UTF_8);
    }

    @Override
    public String getString(int position) {
        int oldPosition = this.nioByteBuffer.position();
        this.nioByteBuffer.position(position);
        String ret = this.getString();
        this.nioByteBuffer.position(oldPosition);
        return ret;
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        String[] ret = initNeeded ? new String[arraySize] : dst;
        for (int k = 0; k < arraySize; ++k) {
            ret[k] = this.getString();
        }
        return ret;
    }

    @Override
    public String getStringISO8859() {
        int arraySize = this.getInt() - 1;
        byte[] values = new byte[arraySize];
        this.nioByteBuffer.get(values, 0, arraySize);
        this.getByte();
        return new String(values, 0, arraySize, StandardCharsets.ISO_8859_1);
    }

    @Override
    public boolean hasRemaining() {
        return this.nioByteBuffer.hasRemaining();
    }

    @Override
    public boolean isEnforceSimpleStringEncoding() {
        return this.enforceSimpleStringEncoding;
    }

    @Override
    public void setEnforceSimpleStringEncoding(boolean state) {
        this.enforceSimpleStringEncoding = state;
    }

    @Override
    public boolean isReadOnly() {
        return this.nioByteBuffer.isReadOnly();
    }

    @Override
    public int limit() {
        return this.nioByteBuffer.limit();
    }

    @Override
    public void limit(int newLimit) {
        this.nioByteBuffer.limit(newLimit);
    }

    @Override
    public ReadWriteLock lock() {
        return this.internalLock;
    }

    @Override
    public int position() {
        return this.nioByteBuffer.position();
    }

    @Override
    public void position(int newPosition) {
        this.nioByteBuffer.position(newPosition);
    }

    @Override
    public void putBoolean(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    @Override
    public void putBoolean(int position, boolean value) {
        this.nioByteBuffer.put(position, (byte)(value ? 1 : 0));
    }

    @Override
    public void putBooleanArray(boolean[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.putBoolean(src[i]);
        }
    }

    @Override
    public void putByte(byte b) {
        this.nioByteBuffer.put(b);
    }

    @Override
    public void putByte(int position, byte value) {
        this.nioByteBuffer.put(position, value);
    }

    @Override
    public void putByteArray(byte[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        this.nioByteBuffer.put(src, 0, nElements);
    }

    @Override
    public void putChar(char value) {
        this.nioByteBuffer.putChar(value);
    }

    @Override
    public void putChar(int position, char value) {
        this.nioByteBuffer.putChar(position, value);
    }

    @Override
    public void putCharArray(char[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 2);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putChar(src[i]);
        }
    }

    @Override
    public void putDouble(double value) {
        this.nioByteBuffer.putDouble(value);
    }

    @Override
    public void putDouble(int position, double value) {
        this.nioByteBuffer.putDouble(position, value);
    }

    @Override
    public void putDoubleArray(double[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 8);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putDouble(src[i]);
        }
    }

    @Override
    public void putFloat(float value) {
        this.nioByteBuffer.putFloat(value);
    }

    @Override
    public void putFloat(int position, float value) {
        this.nioByteBuffer.putFloat(position, value);
    }

    @Override
    public void putFloatArray(float[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 4);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putFloat(src[i]);
        }
    }

    @Override
    public void putInt(int value) {
        this.nioByteBuffer.putInt(value);
    }

    @Override
    public void putInt(int position, int value) {
        this.nioByteBuffer.putInt(position, value);
    }

    @Override
    public void putIntArray(int[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 4);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putInt(src[i]);
        }
    }

    @Override
    public void putLong(long value) {
        this.nioByteBuffer.putLong(value);
    }

    @Override
    public void putLong(int position, long value) {
        this.nioByteBuffer.putLong(position, value);
    }

    @Override
    public void putLongArray(long[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 8);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putLong(src[i]);
        }
    }

    @Override
    public void putShort(short value) {
        this.nioByteBuffer.putShort(value);
    }

    @Override
    public void putShort(int position, short value) {
        this.nioByteBuffer.putShort(position, value);
    }

    @Override
    public void putShortArray(short[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.ensureAdditionalCapacity(nElements * 2);
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        for (int i = 0; i < nElements; ++i) {
            this.nioByteBuffer.putShort(src[i]);
        }
    }

    @Override
    public void putString(String string) {
        if (this.isEnforceSimpleStringEncoding()) {
            this.putStringISO8859(string);
            return;
        }
        if (string == null) {
            this.putInt(1);
            this.putByte((byte)0);
            return;
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.putInt(bytes.length + 1);
        this.ensureAdditionalCapacity(bytes.length + 1);
        this.nioByteBuffer.put(bytes, 0, bytes.length);
        this.putByte((byte)0);
    }

    @Override
    public void putString(int position, String value) {
        int oldPosition = this.nioByteBuffer.position();
        this.nioByteBuffer.position(position);
        this.putString(value);
        this.nioByteBuffer.position(oldPosition);
    }

    @Override
    public void putStringArray(String[] src, int n) {
        int srcSize = src == null ? 0 : src.length;
        int nElements = n >= 0 ? Math.min(n, srcSize) : srcSize;
        this.putInt(nElements);
        if (src == null) {
            return;
        }
        if (this.isEnforceSimpleStringEncoding()) {
            for (int k = 0; k < nElements; ++k) {
                this.putStringISO8859(src[k]);
            }
            return;
        }
        for (int k = 0; k < nElements; ++k) {
            this.putString(src[k]);
        }
    }

    @Override
    public void putStringISO8859(String string) {
        int strLength = string == null ? 0 : string.length();
        this.putInt(strLength + 1);
        for (int i = 0; i < strLength; ++i) {
            this.putByte((byte)(string.charAt(i) & 0xFF));
        }
        this.putByte((byte)0);
    }

    @Override
    public int remaining() {
        return this.nioByteBuffer.remaining();
    }

    @Override
    public void reset() {
        this.nioByteBuffer.position(0);
        this.nioByteBuffer.mark();
        this.nioByteBuffer.limit(this.nioByteBuffer.capacity());
        this.nioByteBuffer.reset();
        this.nioByteBuffer.mark();
    }

    @Override
    public void trim() {
    }

    @Override
    public void trim(int requestedCapacity) {
    }
}

