/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.serialiser;

import de.gsi.dataset.utils.ByteArrayCache;
import io.opencmw.serialiser.DataType;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.FieldSerialiser;
import io.opencmw.serialiser.IoBuffer;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.spi.BinarySerialiser;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import io.opencmw.serialiser.spi.CmwLightSerialiser;
import io.opencmw.serialiser.spi.JsonSerialiser;
import io.opencmw.serialiser.spi.WireDataFieldDescription;
import io.opencmw.serialiser.spi.iobuffer.FieldBoxedValueArrayHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldBoxedValueHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldCollectionsHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldDataSetHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldMapHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldMultiArrayHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldPrimitiveValueHelper;
import io.opencmw.serialiser.spi.iobuffer.FieldPrimitveValueArrayHelper;
import io.opencmw.serialiser.utils.ClassUtils;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoClassSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoClassSerialiser.class);
    public static final String UNCHECKED_CAST_SUPPRESSION = "unchecked";
    private static final Map<String, Constructor<Object>> CLASS_CONSTRUCTOR_MAP = new ConcurrentHashMap<String, Constructor<Object>>();
    protected final List<IoSerialiser> ioSerialisers = new ArrayList<IoSerialiser>();
    private final Map<Type, List<FieldSerialiser<?>>> classMap = new ConcurrentHashMap();
    private final Map<FieldSerialiserKey, FieldSerialiserValue> cachedFieldMatch = new ConcurrentHashMap<FieldSerialiserKey, FieldSerialiserValue>();
    protected IoSerialiser matchedIoSerialiser;
    protected IoBuffer dataBuffer;
    protected Consumer<FieldDescription> startMarkerFunction;
    protected Consumer<FieldDescription> endMarkerFunction;
    private boolean autoMatchSerialiser = true;
    private boolean useCustomJsonSerialiser;

    @SafeVarargs
    public IoClassSerialiser(IoBuffer ioBuffer, Class<? extends IoSerialiser> ... ioSerialiserTypeClass) {
        this.dataBuffer = ioBuffer;
        this.ioSerialisers.add(new BinarySerialiser(this.dataBuffer));
        this.ioSerialisers.add(new JsonSerialiser(this.dataBuffer));
        this.ioSerialisers.add(new CmwLightSerialiser(this.dataBuffer));
        if (ioSerialiserTypeClass.length > 0) {
            this.setMatchedIoSerialiser(ioSerialiserTypeClass[0]);
        } else {
            this.setMatchedIoSerialiser(this.ioSerialisers.get(0));
        }
        FieldPrimitiveValueHelper.register(this);
        FieldPrimitveValueArrayHelper.register(this);
        FieldBoxedValueHelper.register(this);
        FieldBoxedValueArrayHelper.register(this);
        FieldCollectionsHelper.register(this);
        this.addClassDefinition(new FieldSerialiser<Enum>((io, obj, field) -> field.getField().set(obj, io.getEnum((Enum)field.getField().get(obj))), (io, obj, field) -> io.getEnum((Enum)(field == null ? obj : field.getField().get(obj))), (io, obj, field) -> io.put((FieldDescription)field, (Enum)field.getField().get(obj)), Enum.class, new Class[0]));
        FieldMapHelper.register(this);
        FieldDataSetHelper.register(this);
        FieldMultiArrayHelper.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassDefinition(FieldSerialiser<?> serialiser) {
        if (serialiser == null) {
            throw new IllegalArgumentException("serialiser must not be null");
        }
        if (serialiser.getClassPrototype() == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        if (serialiser.getGenericsPrototypes() == null) {
            throw new IllegalArgumentException("types must not be null");
        }
        Map<Type, List<FieldSerialiser<?>>> map = this.knownClasses();
        synchronized (map) {
            List list = this.knownClasses().computeIfAbsent(serialiser.getClassPrototype(), key -> new ArrayList());
            if (list.isEmpty() || !list.contains(serialiser)) {
                list.add(serialiser);
            }
        }
    }

    public void autoUpdateSerialiser() {
        this.ioSerialisers.forEach(s -> s.setBuffer(this.dataBuffer));
        if (!this.isAutoMatchSerialiser()) {
            return;
        }
        int originalPosition = this.dataBuffer.position();
        for (IoSerialiser ioSerialiser : this.ioSerialisers) {
            try {
                ioSerialiser.checkHeaderInfo();
                this.setMatchedIoSerialiser(ioSerialiser);
                LOGGER.atTrace().addArgument((Object)this.matchedIoSerialiser).addArgument((Object)this.matchedIoSerialiser.getBuffer().capacity()).log("set autoUpdateSerialiser() to {} - buffer capacity = {}");
                this.dataBuffer.position(originalPosition);
                return;
            }
            catch (Throwable e) {
                LOGGER.atTrace().setCause(e).addArgument((Object)ioSerialiser).log("could not match IoSerialiser '{}'");
                this.dataBuffer.position(originalPosition);
            }
        }
    }

    public <E> FieldSerialiser<E> cacheFindFieldSerialiser(Type clazz, List<Type> classGenericArguments) {
        return this.cachedFieldMatch.computeIfAbsent(new FieldSerialiserKey(clazz, classGenericArguments), key -> new FieldSerialiserValue(this.findFieldSerialiser(clazz, classGenericArguments))).get();
    }

    public <T> T deserialiseObject(WireDataFieldDescription fieldRoot, T obj) {
        FieldSerialiser<?> fieldSerialiser;
        this.autoUpdateSerialiser();
        int startPosition = this.matchedIoSerialiser.getBuffer().position();
        ClassFieldDescription clazz = ClassUtils.getFieldDescription(obj.getClass(), new Class[0]);
        FieldSerialiser<?> existingSerialiser = clazz.getFieldSerialiser();
        FieldSerialiser<Object> fieldSerialiser2 = fieldSerialiser = existingSerialiser == null ? this.cacheFindFieldSerialiser(clazz.getType(), clazz.getActualTypeArguments()) : existingSerialiser;
        if (clazz.getFieldSerialiser() == null && fieldSerialiser != null) {
            clazz.setFieldSerialiser(fieldSerialiser);
        }
        this.matchedIoSerialiser.getBuffer().position(startPosition);
        if (fieldSerialiser != null) {
            FieldDescription rawObjectFieldDescription = fieldRoot.getChildren().get(0).getChildren().get(0);
            this.matchedIoSerialiser.getBuffer().position(rawObjectFieldDescription.getDataStartPosition());
            if (rawObjectFieldDescription.getDataType() == DataType.OTHER) {
                return (T)this.matchedIoSerialiser.getCustomData(fieldSerialiser);
            }
            return (T)fieldSerialiser.getReturnObjectFunction().apply(this.matchedIoSerialiser, obj, clazz);
        }
        if (!fieldRoot.getChildren().isEmpty() && !fieldRoot.getChildren().get(0).getFieldName().isEmpty()) {
            for (FieldDescription child : fieldRoot.getChildren()) {
                this.deserialise(obj, obj.getClass(), child, clazz, 0);
            }
            return obj;
        }
        List<FieldDescription> fieldRootChildren = fieldRoot.getChildren().get(0).getChildren();
        for (FieldDescription fieldDescription : fieldRootChildren) {
            ClassFieldDescription subFieldDescription = (ClassFieldDescription)clazz.findChildField(fieldDescription.getFieldNameHashCode(), fieldDescription.getFieldName());
            if (subFieldDescription == null) continue;
            this.deserialise(obj, obj.getClass(), fieldDescription, subFieldDescription, 1);
        }
        return obj;
    }

    public <T> T deserialiseObject(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T obj = constructor.newInstance(new Object[0]);
            return this.deserialiseObject(obj);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("no public constructor for class " + clazz.getCanonicalName(), e);
        }
    }

    public <T> T deserialiseObject(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null (yet)");
        }
        this.autoUpdateSerialiser();
        if (this.matchedIoSerialiser instanceof JsonSerialiser) {
            return ((JsonSerialiser)this.matchedIoSerialiser).deserialiseObject(obj);
        }
        WireDataFieldDescription fieldRoot = this.parseWireFormat();
        return this.deserialiseObject(fieldRoot, obj);
    }

    public void finaliseBuffer(ByteArrayCache arrayCache) {
        try {
            if (arrayCache == null) {
                ByteArrayCache.getInstance().add((Object)this.dataBuffer.elements());
            } else {
                arrayCache.add((Object)this.dataBuffer.elements());
            }
            this.dataBuffer = null;
            for (IoSerialiser serialiser : this.ioSerialisers) {
                serialiser.setBuffer(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <E> FieldSerialiser<E> findFieldSerialiser(Type type, List<Type> classGenericArguments) {
        Class<?> clazz = ClassUtils.getRawType(type);
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        List<FieldSerialiser<?>> directClassMatchList = this.classMap.get(type);
        if (directClassMatchList != null && !directClassMatchList.isEmpty()) {
            if (directClassMatchList.size() == 1 || classGenericArguments == null || classGenericArguments.isEmpty()) {
                return directClassMatchList.get(0);
            }
            for (FieldSerialiser<?> entry2 : directClassMatchList) {
                if (!this.checkClassCompatibility(classGenericArguments, entry2.getGenericsPrototypes())) continue;
                return entry2;
            }
        }
        ArrayList potentialMatchingKeys = new ArrayList(10);
        for (Type key : this.knownClasses().keySet()) {
            Class<?> clazz2 = ClassUtils.getRawType(key);
            if (!clazz2.isAssignableFrom(clazz)) continue;
            potentialMatchingKeys.add(clazz2);
        }
        if (potentialMatchingKeys.isEmpty()) {
            return null;
        }
        ArrayList interfaceMatchList = new ArrayList(10);
        for (Class clazz3 : potentialMatchingKeys) {
            List<FieldSerialiser<?>> fieldSerialisers = this.knownClasses().get(clazz3);
            if (fieldSerialisers.isEmpty()) continue;
            interfaceMatchList.addAll(fieldSerialisers);
        }
        if (interfaceMatchList.size() == 1 || classGenericArguments == null || classGenericArguments.isEmpty()) {
            return (FieldSerialiser)interfaceMatchList.get(0);
        }
        for (FieldSerialiser fieldSerialiser : interfaceMatchList) {
            if (!this.checkClassCompatibility(classGenericArguments, fieldSerialiser.getGenericsPrototypes())) continue;
            return fieldSerialiser;
        }
        return interfaceMatchList.stream().filter(entry -> entry.getGenericsPrototypes().isEmpty()).findFirst().orElse(null);
    }

    public IoBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public IoSerialiser getMatchedIoSerialiser() {
        return this.matchedIoSerialiser;
    }

    public final <E> BiFunction<Type, Type[], FieldSerialiser<E>> getSerialiserLookupFunction() {
        return (primaryType, secondaryType) -> {
            if (primaryType == null) {
                throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"no serialiser implementation found for classType = null"})));
            }
            return this.cacheFindFieldSerialiser(ClassUtils.getRawType(primaryType), secondaryType == null ? Collections.emptyList() : Arrays.asList(secondaryType));
        };
    }

    public boolean isAutoMatchSerialiser() {
        return this.autoMatchSerialiser;
    }

    public boolean isUseCustomJsonSerialiser() {
        return this.useCustomJsonSerialiser;
    }

    public Map<Type, List<FieldSerialiser<?>>> knownClasses() {
        return this.classMap;
    }

    public WireDataFieldDescription parseWireFormat() {
        this.autoUpdateSerialiser();
        int startPosition = this.matchedIoSerialiser.getBuffer().position();
        this.matchedIoSerialiser.getBuffer().position(startPosition);
        return this.matchedIoSerialiser.parseIoStream(true);
    }

    public void serialiseObject(Object rootObj, ClassFieldDescription classField, int recursionDepth) {
        FieldSerialiser<?> fieldSerialiser;
        FieldSerialiser<?> existingSerialiser = classField.getFieldSerialiser();
        FieldSerialiser<Object> fieldSerialiser2 = fieldSerialiser = existingSerialiser == null ? this.cacheFindFieldSerialiser(classField.getType(), classField.getActualTypeArguments()) : existingSerialiser;
        if (fieldSerialiser != null && recursionDepth != 0) {
            if (existingSerialiser == null) {
                classField.setFieldSerialiser(fieldSerialiser);
            }
            if (classField.getDataType() == DataType.OTHER) {
                WireDataFieldDescription header = this.matchedIoSerialiser.putFieldHeader(classField.getFieldName(), classField.getDataType());
                fieldSerialiser.getWriterFunction().accept(this.matchedIoSerialiser, rootObj, classField);
                this.matchedIoSerialiser.updateDataEndMarker(header);
            } else {
                fieldSerialiser.getWriterFunction().accept(this.matchedIoSerialiser, rootObj, classField);
            }
            return;
        }
        if (classField.getChildren().isEmpty()) {
            return;
        }
        if (recursionDepth != 0 && this.startMarkerFunction != null) {
            this.startMarkerFunction.accept(classField);
        }
        Object newRoot = classField.getField() == null ? rootObj : classField.getField().get(rootObj);
        for (FieldDescription fieldDescription : classField.getChildren()) {
            ClassFieldDescription field = (ClassFieldDescription)fieldDescription;
            if (!field.isPrimitive()) {
                Object reference = field.getField().get(newRoot);
                if (!field.isPrimitive() && reference == null) continue;
            }
            this.serialiseObject(newRoot, field, recursionDepth + 1);
        }
        if (recursionDepth != 0 && this.endMarkerFunction != null) {
            this.endMarkerFunction.accept(classField);
        }
    }

    public void serialiseObject(Object obj) {
        FieldSerialiser<?> fieldSerialiser;
        if (this.matchedIoSerialiser instanceof JsonSerialiser && this.useCustomJsonSerialiser) {
            ((JsonSerialiser)this.matchedIoSerialiser).serialiseObject(obj);
            return;
        }
        if (obj == null) {
            this.matchedIoSerialiser.putHeaderInfo(new FieldDescription[0]);
            String dataEndMarkerName = "OBJ_ROOT_END";
            WireDataFieldDescription dataEndMarker = new WireDataFieldDescription(this.matchedIoSerialiser, null, "OBJ_ROOT_END".hashCode(), "OBJ_ROOT_END", DataType.START_MARKER, -1, -1, -1);
            this.matchedIoSerialiser.putEndMarker(dataEndMarker);
            return;
        }
        ClassFieldDescription classField = ClassUtils.getFieldDescription(obj.getClass(), new Class[0]);
        FieldSerialiser<?> existingSerialiser = classField.getFieldSerialiser();
        FieldSerialiser<Object> fieldSerialiser2 = fieldSerialiser = existingSerialiser == null ? this.cacheFindFieldSerialiser(classField.getType(), classField.getActualTypeArguments()) : existingSerialiser;
        if (fieldSerialiser == null) {
            this.matchedIoSerialiser.putHeaderInfo(classField);
            this.serialiseObject(obj, classField, 0);
            this.matchedIoSerialiser.putEndMarker(classField);
        } else {
            if (existingSerialiser == null) {
                classField.setFieldSerialiser(fieldSerialiser);
            }
            this.matchedIoSerialiser.putHeaderInfo(new FieldDescription[0]);
            FieldSerialiser<?> castFieldSerialiser = fieldSerialiser;
            this.matchedIoSerialiser.putCustomData(classField, obj, obj.getClass(), castFieldSerialiser);
            String dataEndMarkerName = "OBJ_ROOT_END";
            WireDataFieldDescription dataEndMarker = new WireDataFieldDescription(this.matchedIoSerialiser, null, "OBJ_ROOT_END".hashCode(), "OBJ_ROOT_END", DataType.START_MARKER, -1, -1, -1);
            this.matchedIoSerialiser.putEndMarker(dataEndMarker);
        }
    }

    public void setAutoMatchSerialiser(boolean autoMatchSerialiser) {
        this.autoMatchSerialiser = autoMatchSerialiser;
    }

    public void setDataBuffer(IoBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public void setMatchedIoSerialiser(Class<? extends IoSerialiser> serialiserTemplate) {
        if (serialiserTemplate == null) {
            throw new IllegalArgumentException("serialiserTemplate must not be null");
        }
        for (IoSerialiser ioSerialiser : this.ioSerialisers) {
            if (!ioSerialiser.getClass().equals(serialiserTemplate)) continue;
            this.setMatchedIoSerialiser(ioSerialiser);
            return;
        }
        throw new IllegalArgumentException("IoSerialiser '" + serialiserTemplate.getCanonicalName() + "' not registered with this = " + this);
    }

    public void setUseCustomJsonSerialiser(boolean useCustomJsonSerialiser) {
        this.useCustomJsonSerialiser = useCustomJsonSerialiser;
    }

    protected boolean checkClassCompatibility(List<Type> ref1, List<Type> ref2) {
        if (ref1.size() != ref2.size()) {
            return false;
        }
        if (ref1.isEmpty()) {
            return true;
        }
        for (int i = 0; i < ref1.size(); ++i) {
            Class<?> class2;
            Class<?> class1 = ClassUtils.getRawType(ref1.get(i));
            if (class1.equals(class2 = ClassUtils.getRawType(ref2.get(i))) || class2.isAssignableFrom(class1)) continue;
            return false;
        }
        return true;
    }

    protected <E> void deserialise(Object obj, Class<E> clazz, FieldDescription fieldRoot, ClassFieldDescription classField, int recursionDepth) {
        FieldSerialiser<?> fieldSerialiser;
        assert (obj != null);
        assert (clazz != null);
        FieldSerialiser<?> existingSerialiser = classField.getFieldSerialiser();
        FieldSerialiser<Object> fieldSerialiser2 = fieldSerialiser = existingSerialiser == null ? this.cacheFindFieldSerialiser(classField.getType(), classField.getActualTypeArguments()) : existingSerialiser;
        if (fieldSerialiser != null) {
            if (existingSerialiser == null) {
                classField.setFieldSerialiser(fieldSerialiser);
            }
            this.matchedIoSerialiser.getBuffer().position(fieldRoot.getDataStartPosition());
            classField.getFieldSerialiser().getReaderFunction().accept(this.matchedIoSerialiser, obj, classField);
            return;
        }
        if (fieldRoot.getFieldNameHashCode() != classField.getFieldNameHashCode()) {
            if (fieldRoot.getChildren().isEmpty()) {
                return;
            }
            for (FieldDescription fieldDescription : fieldRoot.getChildren()) {
                ClassFieldDescription subFieldDescription = (ClassFieldDescription)classField.findChildField(fieldDescription.getFieldNameHashCode(), fieldDescription.getFieldName());
                if (subFieldDescription == null) continue;
                this.deserialise(obj, obj.getClass(), fieldDescription, subFieldDescription, recursionDepth + 1);
            }
            return;
        }
        Class<?> fieldClass = ClassUtils.getRawType(classField.getType());
        if (classField.isFinal() && !fieldClass.isInterface()) {
            LOGGER.atWarn().addArgument((Object)classField.getParent()).addArgument((Object)classField.getFieldName()).log("cannot (read: better should not) set final field '{}-{}'");
            return;
        }
        Object ref = classField.getField() == null ? obj : classField.getField().get(obj);
        Object subRef = ref == null ? classField.allocateMemberClassField(obj) : ref;
        for (FieldDescription fieldDescription : fieldRoot.getChildren()) {
            ClassFieldDescription subFieldDescription = (ClassFieldDescription)classField.findChildField(fieldDescription.getFieldNameHashCode(), fieldDescription.getFieldName());
            if (subFieldDescription == null) continue;
            this.deserialise(subRef, subRef.getClass(), fieldDescription, subFieldDescription, recursionDepth + 1);
        }
    }

    private void setMatchedIoSerialiser(IoSerialiser matchedIoSerialiser) {
        this.matchedIoSerialiser = matchedIoSerialiser;
        this.matchedIoSerialiser.setBuffer(this.dataBuffer);
        this.matchedIoSerialiser.setFieldSerialiserLookupFunction(this.getSerialiserLookupFunction());
        assert (this.matchedIoSerialiser.getBuffer() == this.dataBuffer);
        this.startMarkerFunction = this.matchedIoSerialiser::putStartMarker;
        this.endMarkerFunction = this.matchedIoSerialiser::putEndMarker;
        LOGGER.atTrace().addArgument((Object)matchedIoSerialiser).log("setMatchedIoSerialiser to {}");
    }

    public static int computeHashCode(Class<?> classPrototype, List<Type> classGenericArguments) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (classPrototype == null ? 0 : classPrototype.getName().hashCode());
        if (classGenericArguments == null || classGenericArguments.isEmpty()) {
            return result;
        }
        for (Type arg : classGenericArguments) {
            result = 31 * result + (arg == null ? 0 : arg.getTypeName().hashCode());
        }
        return result;
    }

    public static Constructor<Object> getClassConstructorByName(String name, Class<?> ... parameterTypes) {
        return CLASS_CONSTRUCTOR_MAP.computeIfAbsent(name, key -> {
            try {
                return ClassUtils.getClassByName(key).getDeclaredConstructor(parameterTypes);
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)Arrays.toString(parameterTypes)).addArgument((Object)name).log("exception while getting constructor{} for class {}");
                return null;
            }
        });
    }

    public static String[] getClassNames(List<Class<?>> classGenericArguments) {
        if (classGenericArguments == null) {
            return new String[0];
        }
        String[] argStrings = new String[classGenericArguments.size()];
        for (int i = 0; i < argStrings.length; ++i) {
            argStrings[i] = classGenericArguments.get(i).getName();
        }
        return argStrings;
    }

    public static String getGenericFieldSimpleTypeString(List<Type> classArguments) {
        if (classArguments == null || classArguments.isEmpty()) {
            return "";
        }
        return classArguments.stream().map(Type::getTypeName).collect(Collectors.joining(", ", "<", ">"));
    }

    private static class FieldSerialiserValue {
        private final FieldSerialiser<?> fieldSerialiser;

        private FieldSerialiserValue(FieldSerialiser<?> fieldSerialiser) {
            this.fieldSerialiser = fieldSerialiser;
        }

        private FieldSerialiser<?> get() {
            return this.fieldSerialiser;
        }
    }

    private static class FieldSerialiserKey {
        private final Type clazz;
        private final List<Type> classGenericArguments;

        private FieldSerialiserKey(Type clazz, List<Type> classGenericArguments) {
            this.clazz = clazz;
            this.classGenericArguments = classGenericArguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldSerialiserKey that = (FieldSerialiserKey)o;
            return this.clazz.equals(that.clazz) && this.classGenericArguments.equals(that.classGenericArguments);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.classGenericArguments);
        }

        public String toString() {
            return "FieldSerialiserKey{clazz=" + this.clazz + ", classGenericArguments=" + this.classGenericArguments + "}";
        }
    }
}

