/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class WorkerThreadFactory
implements ThreadFactory {
    private static final int MAX_THREADS = Math.max(Math.max(4, Runtime.getRuntime().availableProcessors()), Integer.parseInt(System.getProperties().getProperty("OpenCMW.defaultPoolSize", "10")));
    private static final AtomicInteger TREAD_COUNTER = new AtomicInteger();
    private static final ThreadFactory DEFAULT_FACTORY = Executors.defaultThreadFactory();
    private static final WorkerThreadFactory SELF = new WorkerThreadFactory("DefaultOpenCmwWorker");
    private final String poolName;
    private final int nThreads;
    private final ExecutorService pool;

    public WorkerThreadFactory(String poolName) {
        this(poolName, -1);
    }

    public WorkerThreadFactory(String poolName, int nThreads) {
        this.poolName = poolName;
        this.nThreads = nThreads <= 0 ? MAX_THREADS : nThreads;
        this.pool = Executors.newFixedThreadPool(this.nThreads, this);
        if (this.pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.pool).setRejectedExecutionHandler((runnable, executor) -> {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = DEFAULT_FACTORY.newThread(r);
        TREAD_COUNTER.incrementAndGet();
        thread.setName(this.poolName + "#" + TREAD_COUNTER.intValue());
        thread.setDaemon(true);
        return thread;
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public static WorkerThreadFactory getInstance() {
        return SELF;
    }

    public int getNumbersOfThreads() {
        return this.nThreads;
    }
}

