/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.utils;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CustomFuture<T>
implements Future<T> {
    private static final String FUTURE_HAS_BEEN_CANCELLED = "future has been cancelled";
    protected final Lock lock = new ReentrantLock();
    protected final Condition processorNotifyCondition = this.lock.newCondition();
    protected final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicBoolean requestCancel = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private T reply;
    private Throwable exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done.getAndSet(true)) {
            return false;
        }
        this.cancelled.set(true);
        this.notifyListener();
        return !this.requestCancel.getAndSet(true);
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        try {
            return this.get(0L, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException("TimeoutException should not occur here", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.cancelled.get()) {
            throw new CancellationException(FUTURE_HAS_BEEN_CANCELLED);
        }
        if (this.isDone()) {
            if (this.exception == null) {
                return this.reply;
            }
            throw new ExecutionException(this.exception);
        }
        this.lock.lock();
        try {
            while (!this.isDone()) {
                if (timeout > 0L) {
                    if (!this.processorNotifyCondition.await(timeout, unit)) {
                        throw new TimeoutException("timeout = " + timeout + " " + unit);
                    }
                } else {
                    this.processorNotifyCondition.await();
                }
                if (!this.cancelled.get()) continue;
                throw new CancellationException(FUTURE_HAS_BEEN_CANCELLED);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.reply;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    public void setReply(T newValue) {
        if (this.done.getAndSet(true)) {
            throw new IllegalStateException("future is not running anymore (either cancelled or already notified)");
        }
        this.reply = newValue;
        this.notifyListener();
    }

    public void setException(Throwable exception) {
        if (this.done.getAndSet(true)) {
            throw new IllegalStateException("future is not running anymore (either cancelled or already notified)");
        }
        this.exception = exception;
        this.notifyListener();
    }

    private void notifyListener() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

