/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.filter;

import io.opencmw.Filter;
import io.opencmw.QueryParameterParser;
import io.opencmw.filter.FilterRegistry;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SubscriptionMatcher
implements BiPredicate<URI, URI> {
    protected final boolean isPathOnly;

    @SafeVarargs
    public SubscriptionMatcher(Class<? extends Filter> ... filterConfig) {
        Objects.requireNonNull(filterConfig, "filterConfig must not be null");
        this.isPathOnly = filterConfig.length == 0;
        FilterRegistry.registerNewFilter(filterConfig);
    }

    @Override
    public boolean test(@NotNull URI notified, @NotNull URI subscriber) {
        return this.isPathOnly ? SubscriptionMatcher.testPathOnly(notified, subscriber) : this.testPathAndContext(notified, subscriber);
    }

    private boolean testPathAndContext(URI notified, URI subscriber) {
        if (!SubscriptionMatcher.testPathOnly(notified, subscriber)) {
            return false;
        }
        String queryNotification = notified.getQuery();
        String querySubscriber = subscriber.getQuery();
        if (Objects.equals(querySubscriber, queryNotification)) {
            return true;
        }
        if (queryNotification != null && querySubscriber == null) {
            return true;
        }
        Map<String, String> mapNotify = this.getReducedMap(queryNotification);
        Map<String, String> mapSubscribe = this.getReducedMap(querySubscriber);
        Map<String, Filter> filterMapLocal = FilterRegistry.getKeyFilterMap();
        return mapSubscribe.entrySet().stream().filter(e -> {
            String ctxKey = (String)e.getKey();
            Filter protoFilter = (Filter)filterMapLocal.get(ctxKey);
            if (protoFilter == null) {
                return false;
            }
            String subscriptionQuerySubString = (String)e.getValue();
            String notifyQuerySubString = (String)mapNotify.get(ctxKey);
            if (notifyQuerySubString == null && !subscriptionQuerySubString.isBlank()) {
                return true;
            }
            Filter subscriptionFilter = protoFilter.get(subscriptionQuerySubString);
            if (subscriptionFilter == null) {
                return false;
            }
            return !subscriptionFilter.matches(protoFilter.get(notifyQuerySubString));
        }).findFirst().isEmpty();
    }

    protected Map<String, String> getReducedMap(String query) {
        return QueryParameterParser.getMap(query).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List values = (List)e.getValue();
            return Objects.requireNonNullElse((String)values.get(values.size() - 1), "");
        }));
    }

    public static boolean testPathOnly(@NotNull URI notified, @NotNull URI subscriber) {
        String pathNotification = notified.getPath();
        String pathSubscriber = subscriber.getPath();
        int asterisk = pathSubscriber.indexOf(42);
        if (asterisk == -1) {
            return pathNotification.equals(pathSubscriber) || pathSubscriber.isBlank();
        }
        String pathSubscriberCleaned = StringUtils.removeEnd((String)pathSubscriber, (String)"*");
        return pathNotification.startsWith(pathSubscriberCleaned) || pathSubscriber.isBlank();
    }
}

