/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.filter;

import io.opencmw.Filter;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import io.opencmw.serialiser.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class FilterRegistry {
    private static final AtomicReference<Map<String, Filter>> MAP_KEY_FILTER = new AtomicReference(new HashMap());
    private static final AtomicReference<Map<Class<? extends Filter>, Filter>> MAP_CLASS_FILTER = new AtomicReference(new HashMap());
    private static final AtomicReference<Map<Class<? extends Filter>, String>> MAP_CLASS_FILTER_KEY = new AtomicReference(new HashMap());

    private FilterRegistry() {
    }

    public static Map<String, Filter> getKeyFilterMap() {
        return Collections.unmodifiableMap(MAP_KEY_FILTER.get());
    }

    public static Map<Class<? extends Filter>, Filter> getClassFilterMap() {
        return Collections.unmodifiableMap(MAP_CLASS_FILTER.get());
    }

    public static Map<Class<? extends Filter>, String> getClassFilterKeyMap() {
        return Collections.unmodifiableMap(MAP_CLASS_FILTER_KEY.get());
    }

    public static void clear() {
        MAP_KEY_FILTER.set(new HashMap());
        MAP_CLASS_FILTER.set(new HashMap());
        MAP_CLASS_FILTER_KEY.set(new HashMap());
    }

    public static boolean checkClassForNewFilters(Object object) {
        if (object == null) {
            return false;
        }
        boolean newFilter = false;
        ClassFieldDescription fieldDescription = ClassUtils.getFieldDescription(Class.class.isAssignableFrom(object.getClass()) ? (Class<?>)object : object.getClass(), (Class[])new Class[0]);
        for (FieldDescription child : fieldDescription.getChildren()) {
            ClassFieldDescription field = (ClassFieldDescription)child;
            if (!Filter.class.isAssignableFrom((Class)field.getType())) continue;
            newFilter |= FilterRegistry.registerNewFilter((Class)field.getType());
        }
        return newFilter;
    }

    @SafeVarargs
    public static boolean registerNewFilter(Class<? extends Filter> ... filterConfig) {
        Map<Class<? extends Filter>, Filter> classFilterMap = MAP_CLASS_FILTER.get();
        if (Arrays.stream(filterConfig).filter(newFilter -> classFilterMap.get(newFilter) == null).findFirst().isEmpty()) {
            return false;
        }
        Map<String, Filter> oldKeyFilterMap = FilterRegistry.getKeyFilterMap();
        Map<Class<? extends Filter>, Filter> oldClassFilterMap = FilterRegistry.getClassFilterMap();
        Map<Class<? extends Filter>, String> oldClassFilterKEyMap = FilterRegistry.getClassFilterKeyMap();
        HashMap<String, Filter> newKeyHashMap = new HashMap<String, Filter>(oldKeyFilterMap);
        HashMap<Class<? extends Filter>, Filter> newClassHashMap = new HashMap<Class<? extends Filter>, Filter>(oldClassFilterMap);
        HashMap<Class<? extends Filter>, String> newClassKeyHashMap = new HashMap<Class<? extends Filter>, String>(oldClassFilterKEyMap);
        try {
            for (Class<? extends Filter> aClass : filterConfig) {
                Constructor<? extends Filter> constructor = aClass.getDeclaredConstructor(new Class[0]);
                Filter prototype = constructor.newInstance(new Object[0]);
                String key = prototype.getKey();
                newKeyHashMap.put(key, prototype);
                newClassHashMap.put(aClass, prototype);
                newClassKeyHashMap.put(aClass, key);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("filter must be public and have a public default constructor", e);
        }
        while (!MAP_KEY_FILTER.compareAndSet(oldKeyFilterMap, newKeyHashMap)) {
            oldKeyFilterMap = MAP_KEY_FILTER.get();
            newKeyHashMap.putAll(oldKeyFilterMap);
        }
        while (!MAP_CLASS_FILTER.compareAndSet(oldClassFilterMap, newClassHashMap)) {
            oldClassFilterMap = MAP_CLASS_FILTER.get();
            newClassHashMap.putAll(oldClassFilterMap);
        }
        while (!MAP_CLASS_FILTER_KEY.compareAndSet(oldClassFilterKEyMap, newClassKeyHashMap)) {
            oldClassFilterKEyMap = MAP_CLASS_FILTER_KEY.get();
            newClassKeyHashMap.putAll(oldClassFilterKEyMap);
        }
        return true;
    }
}

