/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.filter;

import io.opencmw.Filter;
import io.opencmw.OpenCmwProtocol;
import java.net.URI;
import java.util.Objects;
import java.util.function.Predicate;

public class EvtTypeFilter
implements Filter {
    public static final String KEY = "evtType";
    public DataType evtType = DataType.UNKNOWN;
    public OpenCmwProtocol.Command updateType = OpenCmwProtocol.Command.UNKNOWN;
    public URI property = OpenCmwProtocol.EMPTY_URI;
    protected int hashCode = 0;

    public EvtTypeFilter() {
    }

    public EvtTypeFilter(String ctxValue) {
        try {
            String[] subComponent = ctxValue.split(":");
            if (subComponent.length < 2 || subComponent.length > 3) {
                throw new IllegalArgumentException("cannot parse '" + ctxValue + "'");
            }
            if (!EvtTypeFilter.class.getSimpleName().equalsIgnoreCase(subComponent[0])) {
                throw new IllegalArgumentException("cannot parse '" + ctxValue + "'");
            }
            this.evtType = DataType.valueOf(subComponent[1]);
            if (subComponent.length == 3) {
                this.property = URI.create(subComponent[2]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot parse '" + ctxValue + "'", e);
        }
    }

    public static Predicate<EvtTypeFilter> isTimingData() {
        return t -> t.evtType == DataType.TIMING_EVENT;
    }

    public static Predicate<EvtTypeFilter> isTimingData(String propertyName) {
        return t -> t.evtType == DataType.TIMING_EVENT && Objects.equals(t.property.getPath(), propertyName);
    }

    public static Predicate<EvtTypeFilter> isDeviceData() {
        return t -> t.evtType == DataType.DEVICE_DATA;
    }

    public static Predicate<EvtTypeFilter> isDeviceData(String propertyName) {
        return t -> t.evtType == DataType.DEVICE_DATA && Objects.equals(t.property.getPath(), propertyName);
    }

    public static Predicate<EvtTypeFilter> isSettingsData() {
        return t -> t.evtType == DataType.SETTING_SUPPLY_DATA;
    }

    public static Predicate<EvtTypeFilter> isSettingsData(String propertyName) {
        return t -> t.evtType == DataType.SETTING_SUPPLY_DATA && Objects.equals(t.property.getPath(), propertyName);
    }

    @Override
    public void clear() {
        this.hashCode = 0;
        this.evtType = DataType.UNKNOWN;
        this.updateType = OpenCmwProtocol.Command.UNKNOWN;
        this.property = OpenCmwProtocol.EMPTY_URI;
    }

    @Override
    public void copyTo(Filter other) {
        if (!(other instanceof EvtTypeFilter)) {
            return;
        }
        ((EvtTypeFilter)other).hashCode = this.hashCode;
        ((EvtTypeFilter)other).evtType = this.evtType;
        ((EvtTypeFilter)other).property = this.property;
        ((EvtTypeFilter)other).updateType = this.updateType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EvtTypeFilter)) {
            return false;
        }
        EvtTypeFilter other = (EvtTypeFilter)obj;
        return this.evtType == other.evtType && this.updateType == other.updateType && Objects.equals(this.property, other.property);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getValue() {
        return EvtTypeFilter.class.getSimpleName() + ":" + this.evtType + ":" + this.property;
    }

    @Override
    public EvtTypeFilter get(String value) {
        try {
            return new EvtTypeFilter(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean matches(Filter other) {
        return this.equals(other);
    }

    @Override
    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = Objects.hash(new Object[]{this.evtType, this.updateType, this.property})) : this.hashCode;
    }

    @Override
    public String toString() {
        return "[" + EvtTypeFilter.class.getSimpleName() + ": evtType=" + this.evtType + " typeName='" + this.property + "']";
    }

    public static enum DataType {
        TIMING_EVENT,
        AGGREGATE_DATA,
        DEVICE_DATA,
        SETTING_SUPPLY_DATA,
        PROCESSED_DATA,
        OTHER,
        UNKNOWN;

    }
}

