/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.domain;

import io.opencmw.MimeType;
import io.opencmw.serialiser.annotations.MetaInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.zeromq.util.ZData;

@MetaInfo(description="domain object definition for receiving/sending generic binary data")
public class BinaryData {
    public String resourceName = "default";
    public MimeType contentType = MimeType.UNKNOWN;
    public byte[] data = new byte[0];
    public int dataSize = -1;

    public BinaryData() {
    }

    public BinaryData(String resourceName, MimeType contentType, byte[] data) {
        this(resourceName, contentType, data, -1);
    }

    public BinaryData(String resourceName, MimeType contentType, byte[] data, int dataSize) {
        this.resourceName = resourceName;
        this.contentType = contentType;
        this.data = data;
        this.dataSize = dataSize;
        this.checkConsistency();
    }

    public void checkConsistency() {
        if (this.resourceName == null || this.resourceName.isBlank()) {
            throw new IllegalArgumentException("resourceName must not be blank");
        }
        if (this.contentType == null) {
            throw new IllegalArgumentException("mimeType must not be blank");
        }
        if (this.data == null || this.dataSize >= 0 && this.data.length < this.dataSize) {
            throw new IllegalArgumentException("data[" + (Serializable)(this.data == null ? "null" : Integer.valueOf(this.data.length)) + "] must be larger than dataSize=" + this.dataSize);
        }
    }

    public void moveTo(@NotNull BinaryData other) {
        other.resourceName = this.resourceName;
        other.contentType = this.contentType;
        other.data = this.data;
        other.dataSize = this.dataSize;
        other.checkConsistency();
    }

    public String toString() {
        return "BinaryData{resourceName='" + this.resourceName + "', contentType=" + (this.contentType == null ? "null" : this.contentType.name()) + "(\"" + this.contentType + "\"), dataSize=" + this.dataSize + ", data=" + ZData.toString((byte[])this.data) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryData)) {
            return false;
        }
        BinaryData that = (BinaryData)o;
        if (!Objects.equals(this.resourceName, that.resourceName) || this.contentType != that.contentType || this.data == null && that.data != null || this.data != null && that.data == null) {
            return false;
        }
        if (this.data == null) {
            return true;
        }
        int minSize = this.dataSize >= 0 ? Math.min(this.data.length, this.dataSize) : this.data.length;
        return Arrays.equals(this.data, 0, minSize, that.data, 0, that.data.length);
    }

    public int hashCode() {
        int result = this.resourceName == null ? 0 : this.resourceName.hashCode();
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    protected static String fixPreAndPost(String name) {
        String nonNullName = name == null ? "/" : name.trim();
        Object fixedPrefix = nonNullName.startsWith("/") ? nonNullName : "/" + nonNullName;
        return ((String)fixedPrefix).endsWith("/") ? fixedPrefix : (String)fixedPrefix + "/";
    }

    protected static String genExportName(String name) {
        int e;
        BinaryData.checkField("genExportName(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            p = 0;
        }
        if ((e = name.lastIndexOf(46)) < 0) {
            e = name.length();
        }
        return name.substring(p, e).replace("/", "");
    }

    protected static String genExportNameData(String name) {
        BinaryData.checkField("genExportNameData(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            p = 0;
        }
        return name.substring(p).replace("/", "");
    }

    protected static String getCategory(String name) {
        BinaryData.checkField("getCategory(name)", name);
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return BinaryData.fixPreAndPost("");
        }
        return BinaryData.fixPreAndPost(name.substring(0, p + 1));
    }

    private static void checkField(String field, String category) {
        if (category == null) {
            throw new IllegalArgumentException(field + "category not be null");
        }
        if (category.isBlank()) {
            throw new IllegalArgumentException(field + "must not be blank");
        }
    }
}

