/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw;

import com.lmax.disruptor.EventHandler;
import io.opencmw.Filter;
import io.opencmw.FilterPredicate;
import io.opencmw.utils.SharedPointer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingBufferEvent
implements FilterPredicate,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingBufferEvent.class);
    public long arrivalTimeStamp;
    public long parentSequenceNumber;
    public final Filter[] filters;
    public SharedPointer<Object> payload;
    public final List<Throwable> throwables = new ArrayList<Throwable>();

    @SafeVarargs
    public RingBufferEvent(Class<? extends Filter> ... filterConfig) {
        assert (filterConfig != null);
        this.filters = new Filter[filterConfig.length];
        for (int i = 0; i < this.filters.length; ++i) {
            try {
                this.filters[i] = filterConfig[i].getConstructor(new Class[0]).newInstance(new Object[0]);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("filter initialisations error - could not instantiate class:" + filterConfig[i], e);
            }
        }
        this.clear();
    }

    public RingBufferEvent clone() {
        RingBufferEvent retVal = new RingBufferEvent((Class[])Arrays.stream(this.filters).map(Object::getClass).toArray(Class[]::new));
        this.copyTo(retVal);
        return retVal;
    }

    public void copyTo(RingBufferEvent other) {
        other.arrivalTimeStamp = this.arrivalTimeStamp;
        other.parentSequenceNumber = this.parentSequenceNumber;
        for (Filter filter : this.filters) {
            filter.copyTo((Filter)other.findFilter(filter.getClass()));
        }
        other.payload = this.payload == null ? null : this.payload.getCopy();
        other.throwables.clear();
        other.throwables.addAll(this.throwables);
    }

    public <T extends Filter> T findFilter(Class<T> filterType) {
        for (Filter filter : this.filters) {
            if (!filter.getClass().isAssignableFrom(filterType)) continue;
            return (T)((Filter)filterType.cast(filter));
        }
        return null;
    }

    public <T extends Filter> T getFilter(Class<T> filterType) {
        T filter = this.findFilter(filterType);
        if (filter != null) {
            return filter;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("requested filter type '").append(filterType.getSimpleName()).append(" not part of ").append(RingBufferEvent.class.getSimpleName()).append(" definition: ");
        RingBufferEvent.printToStringArrayList(builder, "[", "]", this.filters);
        throw new IllegalArgumentException(builder.toString());
    }

    public boolean matches(Predicate<RingBufferEvent> predicate) {
        return predicate.test(this);
    }

    public <T extends Filter> boolean matches(Class<T> filterType, Predicate<T> predicate) {
        return predicate.test(this.getFilter(filterType));
    }

    public boolean matches(Class<?> payloadType) {
        return this.payload != null && this.payload.getType() != null && payloadType.isAssignableFrom(this.payload.getType());
    }

    public final void clear() {
        this.arrivalTimeStamp = 0L;
        this.parentSequenceNumber = -1L;
        for (Filter filter : this.filters) {
            filter.clear();
        }
        this.throwables.clear();
        if (this.payload != null) {
            this.payload.release();
        }
        this.payload = null;
    }

    @Override
    public <R extends Filter> boolean test(Class<R> filterClass, Predicate<R> filterPredicate) {
        return filterPredicate.test((Filter)filterClass.cast(this.getFilter(filterClass)));
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.UK);
        StringBuilder builder = new StringBuilder();
        builder.append(RingBufferEvent.class.getSimpleName()).append(": arrivalTimeStamp ").append(this.arrivalTimeStamp).append(" (").append(sdf.format(this.arrivalTimeStamp)).append(") parent sequence number: ").append(this.parentSequenceNumber).append(" - filter: ");
        RingBufferEvent.printToStringArrayList(builder, "[", "]", this.filters);
        if (!this.throwables.isEmpty()) {
            builder.append(" - exceptions (n=").append(this.throwables.size()).append("):\n");
            for (Throwable t : this.throwables) {
                builder.append(RingBufferEvent.getPrintableStackTrace(t)).append('\n');
            }
        }
        return builder.toString();
    }

    public static void printToStringArrayList(StringBuilder builder, String prefix, String postFix, Object ... items) {
        if (prefix != null && !prefix.isBlank()) {
            builder.append(prefix);
        }
        boolean more = false;
        for (Object o : items) {
            if (more) {
                builder.append(", ");
            }
            builder.append(o.getClass().getSimpleName()).append(':').append(o.toString());
            more = true;
        }
        if (postFix != null && !postFix.isBlank()) {
            builder.append(postFix);
        }
    }

    public static String getPrintableStackTrace(Throwable t) {
        if (t == null) {
            return "<null stack trace>";
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RingBufferEvent)) {
            return false;
        }
        RingBufferEvent other = (RingBufferEvent)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.arrivalTimeStamp != other.arrivalTimeStamp) {
            return false;
        }
        if (this.parentSequenceNumber != other.parentSequenceNumber) {
            return false;
        }
        if (!Arrays.equals(this.filters, other.filters)) {
            return false;
        }
        if (!Objects.equals(this.payload, other.payload)) {
            return false;
        }
        return this.throwables.equals(other.throwables);
    }

    public int hashCode() {
        int result = (int)(this.arrivalTimeStamp ^ this.arrivalTimeStamp >>> 32);
        result = 31 * result + (int)(this.parentSequenceNumber ^ this.parentSequenceNumber >>> 32);
        result = 31 * result + Arrays.hashCode(this.filters);
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + this.throwables.hashCode();
        return result;
    }

    public static class ClearEventHandler
    implements EventHandler<RingBufferEvent> {
        public void onEvent(RingBufferEvent event, long sequence, boolean endOfBatch) {
            LOGGER.atTrace().addArgument((Object)sequence).addArgument((Object)endOfBatch).log("clearing RingBufferEvent sequence = {} endOfBatch = {}");
            event.clear();
        }
    }
}

