/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw;

import io.opencmw.MimeType;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.util.ZData;

public final class OpenCmwProtocol {
    public static final String COMMAND_MUST_NOT_BE_NULL = "command must not be null";
    public static final byte[] EMPTY_FRAME = new byte[0];
    public static final byte[] BROKER_SHUTDOWN = "broker shutdown".getBytes(StandardCharsets.UTF_8);
    public static final URI EMPTY_URI = URI.create("");
    private static final byte[] PROTOCOL_NAME_CLIENT = "MDPC03".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PROTOCOL_NAME_CLIENT_HTTP = "MDPH03".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PROTOCOL_NAME_WORKER = "MDPW03".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PROTOCOL_NAME_UNKNOWN = "UNKNOWN_PROTOCOL".getBytes(StandardCharsets.UTF_8);
    private static final int MAX_PRINT_LENGTH = 200;
    private static final int FRAME0_SOURCE_ID = 0;
    private static final int FRAME1_PROTOCOL_ID = 1;
    private static final int FRAME2_COMMAND_ID = 2;
    private static final int FRAME3_SERVICE_ID = 3;
    private static final int FRAME4_CLIENT_REQUEST_ID = 4;
    private static final int FRAME5_TOPIC = 5;
    private static final int FRAME6_DATA = 6;
    private static final int FRAME7_ERROR = 7;
    private static final int FRAME8_RBAC_TOKEN = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenCmwProtocol.class);
    private static final String SOCKET_MUST_NOT_BE_NULL = "socket must not be null";
    public static final int N_PROTOCOL_FRAMES = 8;

    public static class Context {
        public final MdpMessage req;
        public MdpMessage rep;
        public MimeType mimeType = MimeType.BINARY;
        public Map<String, Object> htmlData;

        public Context(@NotNull MdpMessage requestMsg) {
            this.req = requestMsg;
            this.rep = new MdpMessage(this.req, Command.FINAL);
        }

        public String toString() {
            return "OpenCmwProtocol.Context{req=" + this.req + ", rep=" + this.rep + ", mimeType=" + this.mimeType.name() + ", htmlData=" + this.htmlData + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context context = (Context)o;
            if (!Objects.equals(this.req, context.req)) {
                return false;
            }
            return Objects.equals(this.rep, context.rep);
        }

        public int hashCode() {
            int result = this.req == null ? 0 : this.req.hashCode();
            result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
            return result;
        }
    }

    public static class MdpMessage {
        public byte[] senderID;
        public MdpSubProtocol protocol;
        public Command command;
        public byte[] serviceNameBytes;
        public byte[] clientRequestID;
        public URI topic;
        public byte[] data;
        public String errors;
        public byte[] rbacToken;

        private MdpMessage() {
        }

        public MdpMessage(byte[] senderID, @NotNull MdpSubProtocol protocol, @NotNull Command command, byte[] serviceID, byte[] clientRequestID, @NotNull URI topic, byte[] data, @NotNull String errors, byte[] rbacToken) {
            this.senderID = senderID == null ? EMPTY_FRAME : senderID;
            this.protocol = protocol;
            this.command = command;
            this.serviceNameBytes = serviceID;
            this.clientRequestID = clientRequestID;
            this.topic = topic;
            this.data = data == null ? EMPTY_FRAME : data;
            this.errors = errors;
            if (data == null && errors.isBlank()) {
                throw new IllegalArgumentException("data must not be null if errors are blank");
            }
            this.rbacToken = rbacToken == null ? EMPTY_FRAME : rbacToken;
        }

        public MdpMessage(@NotNull MdpMessage other) {
            this(other, Command.UNKNOWN);
        }

        public MdpMessage(@NotNull MdpMessage other, @NotNull Command fullCopy) {
            this(MdpMessage.copyOf(other.senderID), other.protocol, fullCopy == Command.UNKNOWN ? other.command : fullCopy, MdpMessage.copyOf(other.serviceNameBytes), MdpMessage.copyOf(other.clientRequestID), other.topic, fullCopy == Command.UNKNOWN ? MdpMessage.copyOf(other.data) : EMPTY_FRAME, fullCopy == Command.UNKNOWN ? other.errors : "", fullCopy == Command.UNKNOWN ? MdpMessage.copyOf(other.rbacToken) : EMPTY_FRAME);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MdpMessage)) {
                return false;
            }
            MdpMessage other = (MdpMessage)obj;
            if (!(this.protocol == other.protocol && this.command == other.command && Arrays.equals(this.serviceNameBytes, other.serviceNameBytes) && Arrays.equals(this.clientRequestID, other.clientRequestID) && Objects.equals(this.topic, other.topic) && Arrays.equals(this.data, other.data) && Objects.equals(this.errors, other.errors))) {
                return false;
            }
            return Arrays.equals(this.rbacToken, other.rbacToken);
        }

        public String getSenderName() {
            return this.senderID == null ? "" : ZData.toString((byte[])this.senderID);
        }

        public String getServiceName() {
            return this.serviceNameBytes == null ? "" : ZData.toString((byte[])this.serviceNameBytes);
        }

        public boolean hasRbackToken() {
            return this.rbacToken.length != 0;
        }

        public int hashCode() {
            int result = this.protocol == null ? 0 : this.protocol.hashCode();
            result = 31 * result + Objects.hashCode((Object)this.command);
            result = 31 * result + Arrays.hashCode(this.serviceNameBytes);
            result = 31 * result + Arrays.hashCode(this.clientRequestID);
            result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
            result = 31 * result + Arrays.hashCode(this.data);
            result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
            result = 31 * result + Arrays.hashCode(this.rbacToken);
            return result;
        }

        public boolean send(ZMQ.Socket socket) {
            assert (socket != null) : "socket must not be null";
            assert (this.protocol != null) : "protocol must not be null";
            assert (!this.protocol.equals((Object)MdpSubProtocol.UNKNOWN)) : "protocol must not be UNKNOWN";
            assert (this.command != null) : "command must not be null";
            assert (this.protocol.equals((Object)MdpSubProtocol.PROT_CLIENT) && this.command.isClientCompatible() || this.protocol.equals((Object)MdpSubProtocol.PROT_WORKER) && this.command.isWorkerCompatible()) : "command is client/worker compatible";
            assert (this.serviceNameBytes != null) : "serviceName must not be null";
            assert (this.clientRequestID != null) : "clientRequestID must not be null";
            assert (this.topic != null) : "topic must not be null";
            assert (this.data != null || this.errors != null && !this.errors.isBlank()) : "data must not be null and errors be blank";
            ZMsg msg = new ZMsg();
            if (socket.getSocketType() == SocketType.ROUTER) {
                if (this.senderID == null) {
                    throw new IllegalArgumentException("senderID must be non-null when using ROUTER sockets");
                }
                msg.add(new ZFrame(this.senderID));
            }
            msg.add(new ZFrame(this.protocol.data));
            msg.add(new ZFrame(this.command.data));
            msg.add(new ZFrame(this.serviceNameBytes));
            msg.add(new ZFrame(this.clientRequestID));
            msg.addString(this.topic.toString());
            msg.add(new ZFrame(this.data == null ? EMPTY_FRAME : this.data));
            msg.addString(this.errors == null ? "" : this.errors);
            msg.add(new ZFrame(this.rbacToken));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().addArgument((Object)msg.toString()).log("sending message {}");
            }
            return msg.send(socket);
        }

        public String toString() {
            String errStr = this.errors == null || this.errors.isBlank() ? "no-exception" : "\u001b[31m exception thrown: " + this.errors + "\u001b[0m";
            return "MdpMessage{senderID='" + ZData.toString((byte[])this.senderID) + "', " + this.protocol + ", " + this.command + ", serviceName='" + this.getServiceName() + "', clientRequestID='" + ZData.toString((byte[])this.clientRequestID) + "', topic='" + this.topic + "', data='" + MdpMessage.dataToString(this.data) + "', " + errStr + ", rbac='" + ZData.toString((byte[])this.rbacToken) + "'}";
        }

        protected static String dataToString(byte[] data) {
            if (data == null) {
                return "";
            }
            boolean isText = true;
            for (byte aData : data) {
                if (aData >= 32) continue;
                isText = false;
                break;
            }
            if (isText) {
                return new String(data, ZMQ.CHARSET);
            }
            if (data.length < 200) {
                return ZData.strhex((byte[])data);
            }
            return ZData.strhex((byte[])Arrays.copyOf(data, 200)) + "[" + (data.length - 200) + " more bytes]";
        }

        public static MdpMessage receive(ZMQ.Socket socket) {
            return MdpMessage.receive(socket, true);
        }

        public static MdpMessage receive(@NotNull ZMQ.Socket socket, boolean wait) {
            String errors;
            URI topic;
            List<byte[]> rawFrames;
            int flags = wait ? 0 : 1;
            ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)socket, (int)flags);
            if (msg == null) {
                return null;
            }
            if (socket.getSocketType() != SocketType.ROUTER) {
                msg.push(EMPTY_FRAME);
            }
            if (socket.getSocketType() == SocketType.SUB || socket.getSocketType() == SocketType.XSUB) {
                msg.pollFirst();
            }
            if ((rawFrames = msg.stream().map(ZFrame::getData).collect(Collectors.toUnmodifiableList())).size() <= 8) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument((Object)rawFrames.size()).addArgument((Object)MdpMessage.dataToString(rawFrames)).log("received message size is < 8: {} rawMessage: {}");
                }
                return null;
            }
            byte[] senderID = socket.getSocketType() == SocketType.ROUTER ? (byte[])rawFrames.get(0) : EMPTY_FRAME;
            MdpSubProtocol protocol = MdpSubProtocol.getProtocol((byte[])rawFrames.get(1));
            if (protocol.equals((Object)MdpSubProtocol.UNKNOWN)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument((Object)ZData.toString((byte[])rawFrames.get(1))).addArgument((Object)MdpMessage.dataToString(rawFrames)).log("unknown protocol: '{}' rawMessage: {}");
                }
                return null;
            }
            Command command = Command.getCommand(rawFrames.get(2));
            if (command.equals((Object)Command.UNKNOWN)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument((Object)ZData.toString((byte[])rawFrames.get(2))).addArgument((Object)MdpMessage.dataToString(rawFrames)).log("unknown command: '{}' rawMessage: {}");
                }
                return null;
            }
            byte[] serviceNameBytes = rawFrames.get(3);
            if (serviceNameBytes == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().addKeyValue("a", (Object)"dd").log("");
                    LOGGER.atWarn().addArgument((Object)MdpMessage.dataToString(rawFrames)).log("serviceNameBytes is null, rawMessage: {}");
                }
                return null;
            }
            byte[] clientRequestID = rawFrames.get(4);
            byte[] topicBytes = rawFrames.get(5);
            if (topicBytes == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument((Object)MdpMessage.dataToString(rawFrames)).log("topic is null, rawMessage: {}");
                }
                return null;
            }
            String topicString = new String(topicBytes, StandardCharsets.UTF_8);
            try {
                topic = new URI(topicString);
            }
            catch (URISyntaxException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().setCause((Throwable)e).addArgument((Object)topicString).addArgument((Object)topicString).log("topic URI cannot be parsed {}  - {}");
                }
                return null;
            }
            byte[] data = rawFrames.get(6);
            byte[] errorBytes = rawFrames.get(7);
            String string = errors = errorBytes == null || errorBytes.length == 0 ? "" : new String(errorBytes, StandardCharsets.UTF_8);
            if (data == null && errors.isBlank()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument((Object)MdpMessage.dataToString(rawFrames)).log("data is null and errors is blank - {}");
                }
                return null;
            }
            byte[] rbacTokenByte = rawFrames.size() == 9 ? rawFrames.get(8) : null;
            byte[] rbacToken = rawFrames.size() == 9 && rbacTokenByte != null ? rbacTokenByte : EMPTY_FRAME;
            return new MdpMessage(senderID, protocol, command, serviceNameBytes, clientRequestID, topic, data, errors, rbacToken);
        }

        public static boolean send(ZMQ.Socket socket, List<MdpMessage> replies) {
            assert (socket != null) : "socket must not be null";
            assert (replies != null);
            if (replies.isEmpty()) {
                return false;
            }
            boolean sendState = false;
            Iterator<MdpMessage> iter = replies.iterator();
            while (iter.hasNext()) {
                MdpMessage reply = iter.next();
                reply.command = iter.hasNext() ? Command.PARTIAL : Command.FINAL;
                sendState |= reply.send(socket);
            }
            return sendState;
        }

        protected static byte[] copyOf(byte[] original) {
            return original == null ? EMPTY_FRAME : Arrays.copyOf(original, original.length);
        }

        protected static String dataToString(List<byte[]> data) {
            return data.stream().map(ZData::toString).collect(Collectors.joining(", ", "[#frames= " + data.size() + ": ", "]"));
        }
    }

    public static enum Command {
        GET_REQUEST(1, true, true),
        SET_REQUEST(2, true, true),
        PARTIAL(3, true, true),
        FINAL(4, true, true),
        READY(5, true, true),
        DISCONNECT(6, true, true),
        SUBSCRIBE(7, true, true),
        UNSUBSCRIBE(8, true, true),
        W_NOTIFY(9, false, true),
        W_HEARTBEAT(16, true, true),
        UNKNOWN(-1, false, false);

        private final byte[] data;
        private final boolean isForClients;
        private final boolean isForWorkers;

        private Command(int value, boolean client, boolean worker) {
            this.data = new byte[]{(byte)(value & 0xFF)};
            this.isForClients = client;
            this.isForWorkers = worker;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isClientCompatible() {
            return this.isForClients;
        }

        public boolean isWorkerCompatible() {
            return this.isForWorkers;
        }

        public static Command getCommand(byte[] frame) {
            for (Command knownMdpCommand : Command.values()) {
                if (!Arrays.equals(knownMdpCommand.data, frame) || knownMdpCommand == UNKNOWN) continue;
                return knownMdpCommand;
            }
            return UNKNOWN;
        }
    }

    public static enum MdpSubProtocol {
        PROT_CLIENT(PROTOCOL_NAME_CLIENT),
        PROT_CLIENT_HTTP(PROTOCOL_NAME_CLIENT_HTTP),
        PROT_WORKER(PROTOCOL_NAME_WORKER),
        UNKNOWN(PROTOCOL_NAME_UNKNOWN);

        private final byte[] data;
        private final String protocolName;

        private MdpSubProtocol(byte[] value) {
            this.data = value;
            this.protocolName = new String(this.data, StandardCharsets.UTF_8);
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return "MdpSubProtocol{'" + this.protocolName + "'}";
        }

        public static MdpSubProtocol getProtocol(byte[] frame) {
            for (MdpSubProtocol knownProtocol : MdpSubProtocol.values()) {
                if (!Arrays.equals(knownProtocol.data, frame) || knownProtocol == UNKNOWN) continue;
                return knownProtocol;
            }
            return UNKNOWN;
        }
    }
}

