/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw;

import io.opencmw.OpenCmwProtocol;
import io.opencmw.utils.SystemProperties;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.zeromq.ZMQ;

public final class OpenCmwConstants {
    public static final String WILDCARD = "*";
    public static final String SCHEME_INPROC = "inproc";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_MDP = "mdp";
    public static final String SCHEME_MDS = "mds";
    public static final String SCHEME_TCP = "tcp";
    public static final String HEARTBEAT = "OpenCMW.heartBeat";
    public static final long HEARTBEAT_DEFAULT = 1000L;
    public static final String HEARTBEAT_LIVENESS = "OpenCMW.heartBeatLiveness";
    public static final int HEARTBEAT_LIVENESS_DEFAULT = 3;
    public static final String SUBSCRIPTION_TIMEOUT = "OpenCMW.subscriptionTimeOut";
    public static final long SUBSCRIPTION_TIMEOUT_DEFAULT = 1000L;
    public static final String N_IO_THREADS = "OpenCMW.nIoThreads";
    public static final int N_IO_THREADS_DEFAULT = 1;
    public static final String HIGH_WATER_MARK = "OpenCMW.hwm";
    public static final int HIGH_WATER_MARK_DEFAULT = 0;
    public static final String CLIENT_TIMEOUT = "OpenCMW.clientTimeOut";
    public static final long CLIENT_TIMEOUT_DEFAULT = 0L;
    public static final String ADDRESS_GIVEN = "address given: ";
    public static final String RECONNECT_THRESHOLD1 = "OpenCMW.reconnectThreshold1";
    public static final int DEFAULT_RECONNECT_THRESHOLD1 = 3;
    public static final String RECONNECT_THRESHOLD2 = "OpenCMW.reconnectThreshold2";
    public static final int DEFAULT_RECONNECT_THRESHOLD2 = 6;

    private OpenCmwConstants() {
    }

    public static String getDeviceName(@NotNull URI endpoint) {
        return StringUtils.stripStart((String)endpoint.getPath(), (String)"/").split("/", 2)[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalHostName() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            if (socket.getLocalAddress() == null) {
                throw new UnknownHostException("bogus exception can be ignored");
            }
            String ip = socket.getLocalAddress().getHostAddress();
            if (ip != null) {
                String string = ip;
                return string;
            }
            String string = "localhost";
            return string;
        }
        catch (SocketException | UnknownHostException e) {
            throw new IllegalStateException("cannot resolve own host IP address", e);
        }
    }

    public static String getPropertyName(@NotNull URI endpoint) {
        return StringUtils.stripStart((String)endpoint.getPath(), (String)"/").split("/", 2)[1];
    }

    public static URI replacePath(@NotNull URI address, @NotNull String pathReplacement) {
        if (pathReplacement.equals(address.getPath())) {
            return address;
        }
        try {
            return new URI(address.getScheme(), address.getAuthority(), pathReplacement, address.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(ADDRESS_GIVEN + address, e);
        }
    }

    public static URI replaceQuery(@NotNull URI address, String queryReplacement) {
        if (queryReplacement != null && queryReplacement.equals(address.getQuery())) {
            return address;
        }
        try {
            return new URI(address.getScheme(), address.getAuthority(), address.getPath(), queryReplacement, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(ADDRESS_GIVEN + address, e);
        }
    }

    public static URI replaceScheme(@NotNull URI address, @NotNull String schemeReplacement) {
        if (address.getScheme() != null && address.getScheme().toLowerCase(Locale.UK).equals(SCHEME_INPROC)) {
            return address;
        }
        try {
            return new URI(schemeReplacement, address.getAuthority(), address.getPath(), address.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(ADDRESS_GIVEN + address, e);
        }
    }

    public static URI replaceSchemeKeepOnlyAuthority(@NotNull URI address, @NotNull String schemeReplacement) {
        return URI.create(schemeReplacement + "://" + Objects.requireNonNull(address.getAuthority(), "authority is null: " + address));
    }

    public static URI resolveHost(@NotNull URI address, @NotNull String hostName) {
        if (address.getScheme() != null && address.getScheme().toLowerCase(Locale.UK).equals(SCHEME_INPROC) || address.getAuthority() == null || !address.getAuthority().toLowerCase(Locale.UK).contains(WILDCARD)) {
            return address;
        }
        try {
            String[] splitAuthority = StringUtils.split((String)address.getAuthority(), (String)":");
            int port = splitAuthority.length >= 2 ? Integer.parseInt(splitAuthority[1]) : address.getPort();
            return new URI(address.getScheme(), null, hostName, port, address.getPath(), address.getQuery(), null);
        }
        catch (NumberFormatException | URISyntaxException e) {
            throw new IllegalArgumentException(ADDRESS_GIVEN + address, e);
        }
    }

    public static void setDefaultSocketParameters(@NotNull ZMQ.Socket socket) {
        int heartBeatInterval = (int)SystemProperties.getValueIgnoreCase(HEARTBEAT, 1000L);
        int liveness = SystemProperties.getValueIgnoreCase(HEARTBEAT_LIVENESS, 3);
        socket.setHWM(SystemProperties.getValueIgnoreCase(HIGH_WATER_MARK, 0));
        socket.setHeartbeatContext(OpenCmwProtocol.MdpSubProtocol.PROT_CLIENT.getData());
        socket.setHeartbeatTtl(heartBeatInterval * liveness);
        socket.setHeartbeatTimeout(heartBeatInterval * liveness);
        socket.setHeartbeatIvl(heartBeatInterval);
    }

    public static URI stripPathTrailingSlash(@NotNull URI address) {
        try {
            return new URI(address.getScheme(), address.getAuthority(), StringUtils.stripEnd((String)address.getPath(), (String)"/"), address.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(ADDRESS_GIVEN + address, e);
        }
    }
}

