/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.utils;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SystemProperties {
    private static final Properties SYSTEM_PROPERTIES = System.getProperties();

    private SystemProperties() {
    }

    public static String getProperty(String key) {
        return SYSTEM_PROPERTIES.getProperty(key);
    }

    public static String getPropertyIgnoreCase(String key, String defaultValue) {
        String value = SYSTEM_PROPERTIES.getProperty(key);
        if (null != value) {
            return value;
        }
        Set<Map.Entry<Object, Object>> systemProperties = SYSTEM_PROPERTIES.entrySet();
        for (Map.Entry<Object, Object> entry : systemProperties) {
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return defaultValue;
    }

    public static String getPropertyIgnoreCase(String key) {
        return SystemProperties.getPropertyIgnoreCase(key, null);
    }

    public static double getValue(String key, double defaultValue) {
        String value = SystemProperties.getProperty(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public static int getValue(String key, int defaultValue) {
        String value = SystemProperties.getProperty(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static double getValueIgnoreCase(String key, double defaultValue) {
        String value = SystemProperties.getPropertyIgnoreCase(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public static int getValueIgnoreCase(String key, int defaultValue) {
        String value = SystemProperties.getPropertyIgnoreCase(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static Object put(Object key, Object value) {
        return SYSTEM_PROPERTIES.put(key, value);
    }
}

