/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class SharedPointer<T> {
    private static final String CLASS_NAME = SharedPointer.class.getSimpleName().intern();
    private T payload;
    private Consumer<Object> destroyFunction;
    private final AtomicInteger payloadUseCount = new AtomicInteger(0);

    public SharedPointer<T> set(T payload) {
        return this.set(payload, null);
    }

    public SharedPointer<T> set(T payload, Consumer<Object> destroyFunction) {
        assert (payload != null) : "object must not be null";
        int usageCount = this.payloadUseCount.get();
        if (usageCount > 0) {
            throw new IllegalStateException("cannot set new variable - object not yet released - usageCount: " + usageCount);
        }
        this.payload = payload;
        this.destroyFunction = destroyFunction;
        this.payloadUseCount.getAndIncrement();
        return this;
    }

    public T get() {
        return this.payload;
    }

    public <R> R get(Class<R> classType) {
        return classType.cast(this.payload);
    }

    public int getReferenceCount() {
        return this.payloadUseCount.get();
    }

    public Class<?> getType() {
        return this.payload == null ? null : this.payload.getClass();
    }

    public SharedPointer<T> getCopy() {
        this.payloadUseCount.getAndIncrement();
        return this;
    }

    public void release() {
        if (this.payload == null || this.payloadUseCount.decrementAndGet() > 0) {
            return;
        }
        if (this.destroyFunction != null) {
            this.destroyFunction.accept(this.payload);
        }
        this.payload = null;
    }

    public String toString() {
        if (this.payload == null) {
            return CLASS_NAME + "[useCount= " + this.payloadUseCount.get() + ", has destructor=" + (this.destroyFunction != null) + ", <?>.class, null]";
        }
        return CLASS_NAME + "[useCount= " + this.payloadUseCount.get() + ", has destructor=" + (this.destroyFunction != null) + ", " + this.payload.getClass().getSimpleName() + ".class, '" + this.payload.toString() + "']";
    }
}

