/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.utils;

import java.util.ArrayList;

public class LimitedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 7158175707385120597L;
    private int limit;

    public LimitedArrayList(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit = '" + limit + "'must be >=1 ");
        }
        this.limit = limit;
    }

    @Override
    public boolean add(E o) {
        boolean added = super.add(o);
        while (added && this.size() > this.limit) {
            super.remove(0);
        }
        return added;
    }

    public int getLimit() {
        return this.limit;
    }

    public int setLimit(int newLimit) {
        if (newLimit < 1) {
            throw new IllegalArgumentException("limit = '" + this.limit + "'must be >=1 ");
        }
        this.limit = newLimit;
        return this.limit;
    }
}

