/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.rbac;

import io.opencmw.rbac.BasicRbacRole;
import io.opencmw.rbac.RbacRole;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.zeromq.ZMQ;

public class RbacToken {
    private static final String RBAC_TOKEN_PREFIX = "RBAC";
    private final String signedHashCode;
    private final RbacRole<? extends RbacRole<?>> rbacRole;
    private final String stringRepresentation;
    private final byte[] byteRepresentation;

    public RbacToken(RbacRole<? extends RbacRole<?>> rbacRole, String signedHashCode) {
        if (rbacRole == null) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"rbacRole must not be null: null"})));
        }
        if (signedHashCode == null) {
            throw new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"signedHashCode must not be null: null"})));
        }
        this.rbacRole = rbacRole;
        this.signedHashCode = signedHashCode;
        this.stringRepresentation = "RBAC=" + this.rbacRole.getName() + "," + signedHashCode;
        this.byteRepresentation = this.stringRepresentation.getBytes(StandardCharsets.UTF_8);
    }

    public RbacRole<? extends RbacRole<?>> getRole() {
        return this.rbacRole;
    }

    public String getSignedHashCode() {
        return this.signedHashCode;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.byteRepresentation, this.byteRepresentation.length);
    }

    public static RbacToken from(byte[] rbacToken) {
        return RbacToken.from(rbacToken, rbacToken.length);
    }

    public static RbacToken from(byte[] rbacToken, int length) {
        return RbacToken.from(new String(rbacToken, 0, length, ZMQ.CHARSET));
    }

    public static RbacToken from(String rbacToken) {
        if (rbacToken == null || rbacToken.isBlank()) {
            return new RbacToken(BasicRbacRole.ANYONE, "");
        }
        String[] component = rbacToken.split("[,=]");
        if (component.length != 3 || !RBAC_TOKEN_PREFIX.equals(component[0])) {
            return new RbacToken(BasicRbacRole.NULL, "");
        }
        return new RbacToken(BasicRbacRole.NULL.getRole(component[1]), component[2]);
    }
}

