/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.filter;

import com.jsoniter.spi.JsoniterSpi;
import io.opencmw.Filter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class TimingCtx
implements Filter {
    public static final String WILD_CARD = "ALL";
    public static final int WILD_CARD_VALUE = -1;
    public static final String SELECTOR_PREFIX = "FAIR.SELECTOR.";
    public String selector = "";
    public int cid;
    public int sid;
    public int pid;
    public int gid;
    public long bpcts;
    public String ctxName;
    protected int hashCode = 0;

    public TimingCtx() {
        this.clear();
    }

    @Override
    public void clear() {
        this.hashCode = 0;
        this.selector = "";
        this.cid = -1;
        this.sid = -1;
        this.pid = -1;
        this.gid = -1;
        this.bpcts = -1L;
        this.ctxName = "";
    }

    @Override
    public void copyTo(Filter other) {
        if (!(other instanceof TimingCtx)) {
            return;
        }
        TimingCtx otherCtx = (TimingCtx)other;
        otherCtx.selector = this.selector;
        otherCtx.cid = this.cid;
        otherCtx.sid = this.sid;
        otherCtx.pid = this.pid;
        otherCtx.gid = this.gid;
        otherCtx.bpcts = this.bpcts;
        otherCtx.ctxName = this.ctxName;
        otherCtx.hashCode = this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingCtx otherCtx = (TimingCtx)o;
        if (this.hashCode != otherCtx.hashCode() || this.cid != otherCtx.cid || this.sid != otherCtx.sid || this.pid != otherCtx.pid || this.gid != otherCtx.gid || this.bpcts != otherCtx.bpcts) {
            return false;
        }
        return Objects.equals(this.selector, otherCtx.selector);
    }

    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.selector == null ? 0 : this.selector.hashCode();
        this.hashCode = 31 * this.hashCode + this.cid;
        this.hashCode = 31 * this.hashCode + this.sid;
        this.hashCode = 31 * this.hashCode + this.pid;
        this.hashCode = 31 * this.hashCode + this.gid;
        this.hashCode = 31 * this.hashCode + Long.hashCode(this.bpcts);
        return this.hashCode;
    }

    public Predicate<TimingCtx> matches(TimingCtx other) {
        return t -> this.equals(other);
    }

    public void setSelector(String selector, long bpcts) {
        if (bpcts < 0L) {
            throw new IllegalArgumentException("BPCTS time stamp < 0 :" + bpcts);
        }
        try {
            this.clear();
            this.selector = Objects.requireNonNull(selector, "selector string must not be null");
            this.bpcts = bpcts;
            String selectorUpper = selector.toUpperCase(Locale.UK);
            if (selector.isBlank() || WILD_CARD.equals(selectorUpper)) {
                return;
            }
            String[] identifiers = StringUtils.replace((String)selectorUpper, (String)SELECTOR_PREFIX, (String)"", (int)1).split(":");
            if (identifiers.length == 1 && WILD_CARD.equals(identifiers[0])) {
                return;
            }
            block14: for (String tag : identifiers) {
                String[] splitSubComponent = tag.split("=");
                assert (splitSubComponent.length == 2) : "invalid selector: " + selector;
                int value = splitSubComponent[1].equals(WILD_CARD) ? -1 : Integer.parseInt(splitSubComponent[1]);
                switch (splitSubComponent[0]) {
                    case "C": {
                        this.cid = value;
                        continue block14;
                    }
                    case "S": {
                        this.sid = value;
                        continue block14;
                    }
                    case "P": {
                        this.pid = value;
                        continue block14;
                    }
                    case "T": {
                        this.gid = value;
                        continue block14;
                    }
                    default: {
                        this.clear();
                        throw new IllegalArgumentException("cannot parse selector: '" + selector + "' sub-tag: " + tag);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.clear();
            throw new IllegalArgumentException("Invalid selector or bpcts: " + selector, t);
        }
    }

    public static TimingCtx get(String ctxString) {
        TimingCtx ctx = new TimingCtx();
        ctx.setSelector(ctxString, 0L);
        return ctx;
    }

    @Override
    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.UK);
        return "[" + TimingCtx.class.getSimpleName() + ": bpcts=" + this.bpcts + " (\"" + sdf.format(this.bpcts / 1000000L) + "\"), selector='" + this.selector + "', cid=" + this.cid + ", sid=" + this.sid + ", pid=" + this.pid + ", gid=" + this.gid + "]";
    }

    public static Predicate<TimingCtx> matches(int cid, int sid, int pid, long bpcts) {
        return t -> t.bpcts == bpcts && t.cid == cid && TimingCtx.wildCardMatch(t.sid, sid) && TimingCtx.wildCardMatch(t.pid, pid);
    }

    public static Predicate<TimingCtx> matches(int cid, int sid, long bpcts) {
        return t -> t.bpcts == bpcts && TimingCtx.wildCardMatch(t.cid, cid) && TimingCtx.wildCardMatch(t.sid, sid);
    }

    public static Predicate<TimingCtx> matches(int cid, long bpcts) {
        return t -> t.bpcts == bpcts && TimingCtx.wildCardMatch(t.cid, cid);
    }

    public static Predicate<TimingCtx> matches(int cid, int sid, int pid) {
        return t -> TimingCtx.wildCardMatch(t.cid, cid) && TimingCtx.wildCardMatch(t.sid, sid) && TimingCtx.wildCardMatch(t.pid, pid);
    }

    public static Predicate<TimingCtx> matches(int cid, int sid) {
        return t -> TimingCtx.wildCardMatch(t.cid, cid) && TimingCtx.wildCardMatch(t.sid, sid);
    }

    public static Predicate<TimingCtx> matchesBpcts(long bpcts) {
        return t -> t.bpcts == bpcts;
    }

    public static Predicate<TimingCtx> isOlderBpcts(long bpcts) {
        return t -> t.bpcts < bpcts;
    }

    public static Predicate<TimingCtx> isNewerBpcts(long bpcts) {
        return t -> t.bpcts > bpcts;
    }

    protected static boolean wildCardMatch(int a, int b) {
        return a == b || a == -1 || b == -1;
    }

    static {
        JsoniterSpi.registerTypeDecoder(TimingCtx.class, iter -> TimingCtx.get(iter.readString()));
    }
}

