/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.filter;

import io.opencmw.Filter;
import java.util.Objects;
import java.util.function.Predicate;

public class EvtTypeFilter
implements Filter {
    public DataType evtType = DataType.UNKNOWN;
    public UpdateType updateType = UpdateType.UNKNOWN;
    public String typeName = "";
    protected int hashCode = 0;

    @Override
    public void clear() {
        this.hashCode = 0;
        this.evtType = DataType.UNKNOWN;
        this.updateType = UpdateType.UNKNOWN;
        this.typeName = "";
    }

    @Override
    public void copyTo(Filter other) {
        if (!(other instanceof EvtTypeFilter)) {
            return;
        }
        ((EvtTypeFilter)other).hashCode = this.hashCode;
        ((EvtTypeFilter)other).evtType = this.evtType;
        ((EvtTypeFilter)other).typeName = this.typeName;
        ((EvtTypeFilter)other).updateType = this.updateType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EvtTypeFilter)) {
            return false;
        }
        EvtTypeFilter other = (EvtTypeFilter)obj;
        return this.evtType == other.evtType && this.updateType == other.updateType && Objects.equals(this.typeName, other.typeName);
    }

    @Override
    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = Objects.hash(new Object[]{this.evtType, this.updateType, this.typeName})) : this.hashCode;
    }

    @Override
    public String toString() {
        return "[" + EvtTypeFilter.class.getSimpleName() + ": evtType=" + this.evtType + " typeName='" + this.typeName + "']";
    }

    public static Predicate<EvtTypeFilter> isTimingData() {
        return t -> t.evtType == DataType.TIMING_EVENT;
    }

    public static Predicate<EvtTypeFilter> isTimingData(String typeName) {
        return t -> t.evtType == DataType.TIMING_EVENT && Objects.equals(t.typeName, typeName);
    }

    public static Predicate<EvtTypeFilter> isDeviceData() {
        return t -> t.evtType == DataType.DEVICE_DATA;
    }

    public static Predicate<EvtTypeFilter> isDeviceData(String typeName) {
        return t -> t.evtType == DataType.DEVICE_DATA && Objects.equals(t.typeName, typeName);
    }

    public static Predicate<EvtTypeFilter> isSettingsData() {
        return t -> t.evtType == DataType.SETTING_SUPPLY_DATA;
    }

    public static Predicate<EvtTypeFilter> isSettingsData(String typeName) {
        return t -> t.evtType == DataType.SETTING_SUPPLY_DATA && Objects.equals(t.typeName, typeName);
    }

    public static enum UpdateType {
        EMPTY,
        PARTIAL,
        COMPLETE,
        OTHER,
        UNKNOWN;

    }

    public static enum DataType {
        TIMING_EVENT,
        AGGREGATE_DATA,
        DEVICE_DATA,
        SETTING_SUPPLY_DATA,
        PROCESSED_DATA,
        OTHER,
        UNKNOWN;

    }
}

