/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw;

import io.opencmw.MimeType;
import io.opencmw.filter.TimingCtx;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.spi.ClassFieldDescription;
import io.opencmw.serialiser.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class QueryParameterParser {
    public static final String MIME_TYPE_TAG = "contentType";
    public static final ConcurrentMap<Type, TriConsumer> STRING_TO_CLASS_CONVERTER = new ConcurrentHashMap<Type, TriConsumer>();
    public static final ConcurrentMap<Type, BiFunction<Object, ClassFieldDescription, String>> CLASS_TO_STRING_CONVERTER = new ConcurrentHashMap<Type, BiFunction<Object, ClassFieldDescription, String>>();
    public static final ConcurrentMap<Type, BiFunction<Object, ClassFieldDescription, Object>> CLASS_TO_OBJECT_CONVERTER = new ConcurrentHashMap<Type, BiFunction<Object, ClassFieldDescription, Object>>();

    private QueryParameterParser() {
    }

    public static URI appendQueryParameter(URI oldUri, String appendQuery) throws URISyntaxException {
        if (appendQuery == null || appendQuery.isBlank()) {
            return oldUri;
        }
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)(oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery), oldUri.getFragment());
    }

    public static String generateQueryParameter(Map<String, ?> queryParameterMap) {
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<String, ?>> entrySet = queryParameterMap.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = entrySet.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            Map.Entry<String, ?> item = iterator.next();
            String key = item.getKey();
            Object values = item.getValue();
            if (!first) {
                builder.append('&');
            }
            if (values == null) {
                builder.append(key);
            } else if (List.class.isAssignableFrom(values.getClass())) {
                List list = (List)values;
                for (Object val : list) {
                    if (!first) {
                        builder.append('&');
                    }
                    if (val == null) {
                        builder.append(key);
                    } else {
                        builder.append(key).append('=').append(val);
                    }
                    first = false;
                }
            } else {
                builder.append(key).append('=').append(values);
            }
            first = false;
        }
        return builder.toString();
    }

    public static String generateQueryParameter(Object obj) {
        ClassFieldDescription fieldDescription = ClassUtils.getFieldDescription(obj.getClass(), (Class[])new Class[0]);
        StringBuilder builder = new StringBuilder();
        List children = fieldDescription.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            ClassFieldDescription field = (ClassFieldDescription)children.get(index);
            BiFunction mapFunction = (BiFunction)CLASS_TO_STRING_CONVERTER.get(field.getType());
            String str = mapFunction == null ? (String)((BiFunction)CLASS_TO_STRING_CONVERTER.get(Object.class)).apply(obj, field) : (String)mapFunction.apply(obj, field);
            builder.append(field.getFieldName()).append('=').append(str == null ? "" : URLEncoder.encode(str, StandardCharsets.UTF_8));
            if (index == children.size() - 1) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public static Map<String, List<String>> getMap(String queryParam) {
        if (queryParam == null || queryParam.isBlank()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(StringUtils.split((String)queryParam, (String)"&;")).map(QueryParameterParser::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    @NotNull
    public static MimeType getMimeType(String queryString) {
        List<String> mimeTypeList = QueryParameterParser.getMap(queryString).get(MIME_TYPE_TAG);
        return mimeTypeList == null || mimeTypeList.isEmpty() ? MimeType.UNKNOWN : MimeType.getEnum(mimeTypeList.get(mimeTypeList.size() - 1));
    }

    public static <T> T parseQueryParameter(Class<T> clazz, String queryString) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassFieldDescription fieldDescription = ClassUtils.getFieldDescription(clazz, (Class[])new Class[0]);
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        T obj = constructor.newInstance(new Object[0]);
        Map<String, List<String>> queryMap = QueryParameterParser.getMap(queryString);
        for (FieldDescription f : fieldDescription.getChildren()) {
            ClassFieldDescription field = (ClassFieldDescription)f;
            List<String> values = queryMap.get(field.getFieldName());
            TriConsumer mapFunction = (TriConsumer)STRING_TO_CLASS_CONVERTER.get(field.getType());
            if (mapFunction == null || values == null || values.isEmpty()) continue;
            String value = values.get(values.size() - 1);
            try {
                mapFunction.accept(value, obj, field);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error parsing value '" + value + "' for field: '" + clazz.getName() + "::" + field.getFieldName() + "'", e);
            }
        }
        return obj;
    }

    public static URI removeQueryParameter(URI oldUri, String removeQuery) throws URISyntaxException {
        if (removeQuery == null || removeQuery.isBlank() || oldUri.getQuery() == null) {
            return oldUri;
        }
        Map<String, List<String>> query = QueryParameterParser.getMap(oldUri.getQuery());
        int idx = removeQuery.indexOf(61);
        if (idx >= 0) {
            String key = idx > 0 ? removeQuery.substring(0, idx) : removeQuery;
            String value = idx > 0 && removeQuery.length() > idx + 1 ? removeQuery.substring(idx + 1) : null;
            List<String> entry = query.get(key);
            if (entry != null) {
                entry.remove(value);
                if (entry.isEmpty()) {
                    query.remove(value);
                }
            }
        } else {
            query.remove(removeQuery);
        }
        String newQueryParameter = QueryParameterParser.generateQueryParameter(query);
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQueryParameter, oldUri.getFragment());
    }

    static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String queryParameter) {
        int idx = queryParameter.indexOf(61);
        String key = idx > 0 ? queryParameter.substring(0, idx) : queryParameter;
        String value = idx > 0 && queryParameter.length() > idx + 1 ? queryParameter.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(URLDecoder.decode(key, StandardCharsets.UTF_8), (value == null ? null : URLDecoder.decode(value, StandardCharsets.UTF_8)));
    }

    static {
        STRING_TO_CLASS_CONVERTER.put(Boolean.TYPE, (str, obj, field) -> field.getField().setBoolean(obj, Boolean.parseBoolean(str)));
        STRING_TO_CLASS_CONVERTER.put(Byte.TYPE, (str, obj, field) -> field.getField().setByte(obj, Byte.parseByte(str)));
        STRING_TO_CLASS_CONVERTER.put(Short.TYPE, (str, obj, field) -> field.getField().setShort(obj, Short.parseShort(str)));
        STRING_TO_CLASS_CONVERTER.put(Integer.TYPE, (str, obj, field) -> field.getField().setInt(obj, Integer.parseInt(str)));
        STRING_TO_CLASS_CONVERTER.put(Long.TYPE, (str, obj, field) -> field.getField().setLong(obj, Long.parseLong(str)));
        STRING_TO_CLASS_CONVERTER.put(Float.TYPE, (str, obj, field) -> field.getField().setFloat(obj, Float.parseFloat(str)));
        STRING_TO_CLASS_CONVERTER.put(Double.TYPE, (str, obj, field) -> field.getField().setDouble(obj, Double.parseDouble(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Boolean.class), (str, obj, field) -> field.getField().set(obj, (Object)Boolean.parseBoolean(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Byte.class), (str, obj, field) -> field.getField().set(obj, (Object)Byte.parseByte(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Short.class), (str, obj, field) -> field.getField().set(obj, (Object)Short.parseShort(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Integer.class), (str, obj, field) -> field.getField().set(obj, (Object)Integer.parseInt(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Long.class), (str, obj, field) -> field.getField().set(obj, (Object)Long.parseLong(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Float.class), (str, obj, field) -> field.getField().set(obj, (Object)Float.valueOf(Float.parseFloat(str))));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Double.class), (str, obj, field) -> field.getField().set(obj, (Object)Double.parseDouble(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)String.class), (str, obj, field) -> field.getField().set(obj, (Object)str));
        BiFunction<Object, ClassFieldDescription, String> objToString = (obj, field) -> {
            Object ret = field.getField().get(obj);
            return ret == null || ret.getClass().equals(Object.class) ? "" : ret.toString();
        };
        CLASS_TO_STRING_CONVERTER.put(Boolean.TYPE, (obj, field) -> Boolean.toString(field.getField().getBoolean(obj)));
        CLASS_TO_STRING_CONVERTER.put(Byte.TYPE, (obj, field) -> Byte.toString(field.getField().getByte(obj)));
        CLASS_TO_STRING_CONVERTER.put(Short.TYPE, (obj, field) -> Short.toString(field.getField().getShort(obj)));
        CLASS_TO_STRING_CONVERTER.put(Integer.TYPE, (obj, field) -> Integer.toString(field.getField().getInt(obj)));
        CLASS_TO_STRING_CONVERTER.put(Long.TYPE, (obj, field) -> Long.toString(field.getField().getLong(obj)));
        CLASS_TO_STRING_CONVERTER.put(Float.TYPE, (obj, field) -> Float.toString(field.getField().getFloat(obj)));
        CLASS_TO_STRING_CONVERTER.put(Double.TYPE, (obj, field) -> Double.toString(field.getField().getDouble(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)boolean[].class), (obj, field) -> Arrays.toString((boolean[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)byte[].class), (obj, field) -> Arrays.toString((byte[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)short[].class), (obj, field) -> Arrays.toString((short[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)int[].class), (obj, field) -> Arrays.toString((int[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)long[].class), (obj, field) -> Arrays.toString((long[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)float[].class), (obj, field) -> Arrays.toString((float[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)double[].class), (obj, field) -> Arrays.toString((double[])field.getField().get(obj)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Boolean.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Byte.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Short.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Integer.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Long.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Float.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Double.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)String.class), (obj, field) -> Objects.requireNonNullElse(field.getField().get(obj), "").toString());
        CLASS_TO_OBJECT_CONVERTER.put(Boolean.TYPE, (obj, field) -> field.getField().getBoolean(obj));
        CLASS_TO_OBJECT_CONVERTER.put(Byte.TYPE, (obj, field) -> field.getField().getByte(obj));
        CLASS_TO_OBJECT_CONVERTER.put(Short.TYPE, (obj, field) -> field.getField().getShort(obj));
        CLASS_TO_OBJECT_CONVERTER.put(Integer.TYPE, (obj, field) -> field.getField().getInt(obj));
        CLASS_TO_OBJECT_CONVERTER.put(Long.TYPE, (obj, field) -> field.getField().getLong(obj));
        CLASS_TO_OBJECT_CONVERTER.put(Float.TYPE, (obj, field) -> Float.valueOf(field.getField().getFloat(obj)));
        CLASS_TO_OBJECT_CONVERTER.put(Double.TYPE, (obj, field) -> field.getField().getDouble(obj));
        CLASS_TO_OBJECT_CONVERTER.put((Type)((Object)Object.class), (obj, field) -> field.getField().get(obj));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)Object.class), (str, obj, field) -> field.getField().set(obj, new Object()));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)MimeType.class), (str, obj, field) -> field.getField().set(obj, (Object)MimeType.getEnum(str)));
        STRING_TO_CLASS_CONVERTER.put((Type)((Object)TimingCtx.class), (str, obj, field) -> field.getField().set(obj, (Object)TimingCtx.get(str)));
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)Object.class), objToString);
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)MimeType.class), (obj, field) -> {
            Object ret = field.getField().get(obj);
            return ret == null || ret.getClass().equals(Object.class) ? "" : ((MimeType)((Object)((Object)ret))).name();
        });
        CLASS_TO_STRING_CONVERTER.put((Type)((Object)TimingCtx.class), (obj, field) -> {
            Object ctx = field.getField().get(obj);
            return ctx instanceof TimingCtx ? ((TimingCtx)ctx).selector : "";
        });
    }

    public static interface TriConsumer {
        public void accept(String var1, Object var2, ClassFieldDescription var3);
    }
}

