/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw;

import com.jsoniter.spi.JsoniterSpi;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum MimeType {
    CSS("text/css", "Cascading Style Sheets (CSS)", ".css"),
    CSV("text/csv", "Comma-separated values (CSV)", ".csv"),
    EVENT_STREAM("text/event-stream", "SSE stream", new String[0]),
    HTML("text/html", "HyperText Markup Language (HTML)", ".htm", ".html"),
    ICS("text/calendar", "iCalendar format", ".ics"),
    JAVASCRIPT("text/javascript", "JavaScript", ".js", ".mjs"),
    JSON("application/json", "JSON format", ".json"),
    JSON_LD("application/ld+json", "JSON-LD format", ".jsonld"),
    TEXT("text/plain", "Text, (generally ASCII or ISO 8859-n)", ".txt"),
    XML("text/xml", "XML", ".xml"),
    YAML("text/yaml", "YAML Ain't Markup Language File", ".yml", ".yaml"),
    AAC("audio/aac", "AAC audio", ".aac"),
    MIDI("audio/midi", "Musical Instrument Digital Interface (MIDI)", ".mid", ".midi"),
    MP3("audio/mpeg", "MP3 audio", ".mp3"),
    OTF("audio/opus", "Opus audio", ".opus"),
    WAV("audio/wav", "Waveform Audio Format", ".wav"),
    WEBM_AUDIO("audio/webm", "WEBM audio", ".weba"),
    BMP("image/bmp", "Windows OS/2 Bitmap Graphics", ".bmp"),
    GIF("image/gif", "Graphics Interchange Format (GIF)", ".gif"),
    ICO("image/vnd.microsoft.icon", "Icon format", ".ico"),
    JPEG("image/jpeg", "JPEG images", ".jpg", ".jpeg"),
    PNG("image/png", "Portable Network Graphics", ".png"),
    APNG("image/apng", "Portable Network Graphics", ".png", ".apng"),
    SVG("image/svg+xml", "Scalable Vector Graphics (SVG)", ".svg"),
    TIFF("image/tiff", "Tagged Image File Format (TIFF)", ".tif", ".tiff"),
    WEBP("image/webp", "WEBP image", ".webp"),
    AVI("video/x-msvideo", "AVI: Audio Video Interleave", ".avi"),
    MP2T("video/mp2t", "MPEG transport stream", ".ts"),
    MPEG("video/mpeg", "MPEG Video", ".mpeg"),
    WEBM_VIDEO("video/webm", "WEBM video", ".webm"),
    BINARY("application/octet-stream", "Any kind of binary data", ".bin"),
    CMWLIGHT("application/cmwlight", "proprietary CERN serialiser binary format", ".cmwlight"),
    BZIP2("application/x-bzip2", "BZip2 archive", ".bz2"),
    DOC("application/msword", "Microsoft Word", ".doc"),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Microsoft Word (OpenXML)", ".docx"),
    GZIP("application/gzip", "GZip Compressed Archive", ".gz"),
    JAR("application/java-archive", "Java Archive (JAR)", ".jar"),
    ODP("application/vnd.oasis.opendocument.presentation", "OpenDocument presentation document", ".odp"),
    ODS("application/vnd.oasis.opendocument.spreadsheet", "OpenDocument spreadsheet document", ".ods"),
    ODT("application/vnd.oasis.opendocument.text", "OpenDocument text document", ".odt"),
    OGG("application/ogg", "OGG Audio/Video File", ".ogx", ".ogv", ".oga"),
    PDF("application/pdf", "Adobe Portable Document Format (PDF)", ".pdf"),
    PHP("application/x-httpd-php", "Hypertext Preprocessor (Personal Home Page)", ".php"),
    PPT("application/vnd.ms-powerpoint", "Microsoft PowerPoint", ".ppt"),
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation", "Microsoft PowerPoint (OpenXML)", ".pptx"),
    RAR("application/vnd.rar", "RAR archive", ".rar"),
    RTF("application/rtf", "Rich Text Format (RTF)", ".rtf"),
    TAR("application/x-tar", "Tape Archive (TAR)", ".tar"),
    VSD("application/vnd.visio", "Microsoft Visio", ".vsd"),
    XHTML("application/xhtml+xml", "XHTML", ".xhtml"),
    XLS("application/vnd.ms-excel", "Microsoft Excel", ".xls"),
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Microsoft Excel (OpenXML)", ".xlsx"),
    ZIP("application/zip", "ZIP archive", ".zip"),
    UNKNOWN("unknown/unknown", "unknown data format", new String[0]);

    private final String mediaType;
    private final String description;
    private final Type type;
    private final String subType;
    private final List<String> fileEndings;

    private MimeType(String definition, String description, String ... endings) {
        this.mediaType = definition;
        this.description = description;
        this.type = Type.getEnum(definition);
        this.subType = definition.split("/")[1];
        this.fileEndings = Arrays.asList(endings);
    }

    public List<String> getFileEndings() {
        return this.fileEndings;
    }

    public String getSubType() {
        return this.subType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isImageData() {
        return Type.IMAGE.equals((Object)this.getType());
    }

    public boolean isNonDisplayableData() {
        return !this.isImageData() && !this.isVideoData();
    }

    public boolean isTextData() {
        return Type.TEXT.equals((Object)this.getType());
    }

    public boolean isVideoData() {
        return Type.VIDEO.equals((Object)this.getType());
    }

    public String toString() {
        return this.mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDescription() {
        return this.description;
    }

    public static MimeType getEnum(String mimeType) {
        if (mimeType == null || mimeType.isBlank()) {
            return UNKNOWN;
        }
        String trimmed = mimeType.toLowerCase(Locale.UK).trim();
        for (MimeType mType : MimeType.values()) {
            if (trimmed.contains(mType.mediaType)) {
                return mType;
            }
            if (!trimmed.equalsIgnoreCase(mType.name())) continue;
            return mType;
        }
        return UNKNOWN;
    }

    public static MimeType getEnumByFileName(String fileName) {
        if (fileName == null || fileName.isBlank()) {
            return UNKNOWN;
        }
        String trimmed = fileName.toLowerCase(Locale.UK).trim();
        for (MimeType mType : MimeType.values()) {
            for (String ending : mType.getFileEndings()) {
                if (!trimmed.endsWith(ending)) continue;
                return mType;
            }
        }
        return UNKNOWN;
    }

    static {
        JsoniterSpi.registerTypeDecoder(MimeType.class, iter -> MimeType.getEnum(iter.readString()));
    }

    public static enum Type {
        AUDIO("audio"),
        IMAGE("image"),
        VIDEO("video"),
        TEXT("text"),
        APPLICATION("application"),
        UNKNOWN("unknown");

        private final String typeDef;

        private Type(String subType) {
            this.typeDef = subType;
        }

        public String toString() {
            return this.typeDef;
        }

        public static Type getEnum(String type) {
            if (type == null || type.isBlank()) {
                return UNKNOWN;
            }
            String stripped = type.split("/")[0];
            for (Type mSubType : Type.values()) {
                if (!mSubType.typeDef.equalsIgnoreCase(stripped)) continue;
                return mSubType;
            }
            return UNKNOWN;
        }
    }
}

